/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.results.export;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geolang.ascema.managerdomain.domain.UnprocessableResultStored;
import com.geolang.ascema.managerpersistence.exportdata.IExportData;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnprocessableExportData
implements IExportData {
    private String taskInstanceName;
    private String deviceName;
    private String filePath;
    private String reason;
    private String reasonType;
    private String link;

    public static UnprocessableExportData nullData() {
        UnprocessableExportData ret = new UnprocessableExportData();
        ret.deviceName = "";
        ret.filePath = "";
        ret.taskInstanceName = "";
        ret.reasonType = "";
        ret.reason = "";
        ret.link = "";
        return ret;
    }

    public boolean isNullData() {
        return this.deviceName.isEmpty() && this.filePath.isEmpty();
    }

    public static UnprocessableExportData fromResult(UnprocessableResultStored stored, String taskName) {
        UnprocessableExportData ret = new UnprocessableExportData();
        ret.taskInstanceName = taskName;
        ret.deviceName = stored.getDeviceName();
        ret.filePath = stored.getFilePath();
        ret.reason = stored.getReason();
        ret.reasonType = stored.getReasonType().toString();
        ret.link = stored.getLink();
        return ret;
    }

    public List<String> fieldNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (Field f : UnprocessableExportData.class.getDeclaredFields()) {
            ret.add(f.getName());
        }
        return ret;
    }

    public List<String> fieldValues() {
        ArrayList<String> ret = new ArrayList<String>();
        for (Field f : UnprocessableExportData.class.getDeclaredFields()) {
            try {
                Object obj = f.get(this);
                if (obj != null) {
                    ret.add(obj.toString());
                    continue;
                }
                ret.add("");
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(UnprocessableExportData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return ret;
    }

    public String toJson(ObjectMapper mapper) throws JsonProcessingException {
        return mapper.writeValueAsString((Object)this);
    }

    public String getTaskInstanceName() {
        return this.taskInstanceName;
    }

    public String getReasonType() {
        return this.reasonType;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getReason() {
        return this.reason;
    }

    public String getLink() {
        return this.link;
    }
}

