/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.results.export;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.geolang.ascema.managerpersistence.exportdata.IExportData;
import com.geolang.ascema.managerservice.controllers.results.export.CsvExportWriter;
import com.geolang.ascema.managerservice.controllers.results.export.IExportWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.EncryptionMethod;

public class JsonExportWriter
implements IExportWriter {
    private PrintWriter printWriter;
    private final ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new JavaTimeModule())).build();
    private boolean first = true;
    private String filename;
    private ZipOutputStream zipOut;
    private int count = 0;
    private File zipFile;
    private ZipParameters zipParameters;

    public void start(Path folderPath, String filename, String pwd) throws IOException {
        this.filename = filename;
        this.zipParameters = new ZipParameters();
        Path zipPath = Paths.get(folderPath.toString(), filename + ".zip");
        this.zipFile = zipPath.toFile();
        FileOutputStream fos = new FileOutputStream(this.zipFile);
        if (pwd != null && !pwd.isEmpty()) {
            this.zipParameters.setEncryptFiles(true);
            this.zipParameters.setEncryptionMethod(EncryptionMethod.AES);
            this.zipOut = new ZipOutputStream((OutputStream)fos, pwd.toCharArray());
        } else {
            this.zipOut = new ZipOutputStream((OutputStream)fos);
        }
        this.printWriter = new PrintWriter((OutputStream)this.zipOut);
    }

    public File end() {
        try {
            this.zipOut.close();
        }
        catch (IOException ex) {
            Logger.getLogger(JsonExportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.zipFile;
    }

    public void writeEnties(Stream<IExportData> str) {
        this.createJsonFile();
        AtomicInteger rowCount = new AtomicInteger(1);
        str.forEach(data -> {
            try {
                rowCount.incrementAndGet();
                String val = data.toJson(this.mapper);
                if (!this.first) {
                    this.printWriter.print(",");
                } else {
                    this.first = false;
                }
                this.printWriter.println(val);
                if (rowCount.get() >= 100000) {
                    this.closeJsonFile();
                    this.createJsonFile();
                    rowCount.set(1);
                    this.first = true;
                }
            }
            catch (JsonProcessingException ex) {
                Logger.getLogger(JsonExportWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.closeJsonFile();
    }

    private void createJsonFile() {
        try {
            Path currentFilePath = Paths.get(this.filename + "_" + this.count + ".json", new String[0]);
            ++this.count;
            this.zipParameters.setFileNameInZip(currentFilePath.toString());
            this.zipOut.putNextEntry(this.zipParameters);
            this.printWriter.println("[");
        }
        catch (IOException ex) {
            Logger.getLogger(CsvExportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void closeJsonFile() {
        try {
            this.printWriter.println("]");
            this.printWriter.flush();
            this.zipOut.closeEntry();
        }
        catch (IOException ex) {
            Logger.getLogger(JsonExportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

