/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.results.export;

import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerdomain.web.ExportFormat;
import com.geolang.ascema.managerdomain.web.UnprocessableDataSliceRequest;
import com.geolang.ascema.managerdomain.web.results.DataRequest;
import com.geolang.ascema.managerservice.controllers.DatabaseSearchController;
import com.geolang.ascema.managerservice.controllers.results.ResultsManager;
import com.geolang.ascema.managerservice.controllers.results.UnprocessableResultsManager;
import com.geolang.ascema.managerservice.controllers.results.export.CsvExportWriter;
import com.geolang.ascema.managerservice.controllers.results.export.ExcelExportWriter;
import com.geolang.ascema.managerservice.controllers.results.export.ExportController;
import com.geolang.ascema.managerservice.controllers.results.export.IExportWriter;
import com.geolang.ascema.managerservice.controllers.results.export.JsonExportWriter;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ExportController {
    private static final Logger LOG = Logger.getLogger(ExportController.class.getName());
    @Autowired
    private ResultsManager resultsManager;
    @Autowired
    private DatabaseSearchController dbResults;
    @Autowired
    private UnprocessableResultsManager unprocessableManager;
    private final String exportFolder = WorkingFolder.getExportFolder();

    public ExportController() {
        try {
            FileUtils.cleanDirectory((File)new File(this.exportFolder));
        }
        catch (IOException ex) {
            Logger.getLogger(ExportController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Transactional(readOnly=true)
    public File getDbExport(String user, String taskId, ExportFormat format, String pwd, boolean decrypt, boolean showIgnore, int minConfidence) throws IOException {
        Optional writerOpt = this.getWriter(format);
        if (writerOpt.isEmpty()) {
            throw new IOException("unrecognised format");
        }
        IExportWriter writer = (IExportWriter)writerOpt.get();
        String path = this.exportFolder + File.separator + UUID.randomUUID().toString();
        Instant instant = Instant.now().truncatedTo(ChronoUnit.SECONDS);
        String str = instant.toString().replace("-", "").replace(":", "");
        String filename = "export_" + user + "_" + str;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        writer.start(folder.toPath(), filename, pwd);
        try (Stream stream = this.dbResults.getExportStream(taskId, decrypt, showIgnore, minConfidence);){
            writer.writeEnties(stream);
        }
        return writer.end();
    }

    @Transactional(readOnly=true)
    public File getExport(String user, DataRequest req, ExportFormat format, String pwd) throws IOException {
        Optional writerOpt = this.getWriter(format);
        if (writerOpt.isEmpty()) {
            throw new IOException("unrecognised format");
        }
        IExportWriter writer = (IExportWriter)writerOpt.get();
        String path = this.exportFolder + File.separator + UUID.randomUUID().toString();
        Instant instant = Instant.now().truncatedTo(ChronoUnit.SECONDS);
        String str = instant.toString().replace("-", "").replace(":", "");
        String filename = "export_" + user + "_" + str;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        writer.start(folder.toPath(), filename, pwd);
        try (Stream stream = this.resultsManager.getExportStream(req);){
            writer.writeEnties(stream);
        }
        return writer.end();
    }

    @Transactional(readOnly=true)
    public File getUnprocessableExport(String user, UnprocessableDataSliceRequest req, ExportFormat format, String pwd) throws IOException {
        Optional writerOpt = this.getWriter(format);
        if (writerOpt.isEmpty()) {
            throw new IOException("unrecognised format");
        }
        IExportWriter writer = (IExportWriter)writerOpt.get();
        String path = this.exportFolder + File.separator + UUID.randomUUID().toString();
        Instant instant = Instant.now().truncatedTo(ChronoUnit.SECONDS);
        String str = instant.toString().replace("-", "").replace(":", "");
        String filename = "export_" + user + "_" + str;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        writer.start(folder.toPath(), filename, pwd);
        try (Stream stream = this.unprocessableManager.getExportStream(req);){
            writer.writeEnties(stream);
        }
        return writer.end();
    }

    private Optional<IExportWriter> getWriter(ExportFormat format) {
        CsvExportWriter writer;
        switch (1.$SwitchMap$com$geolang$ascema$managerdomain$web$ExportFormat[format.ordinal()]) {
            case 1: {
                writer = new CsvExportWriter();
                break;
            }
            case 2: {
                writer = new ExcelExportWriter();
                break;
            }
            case 3: {
                writer = new JsonExportWriter();
                break;
            }
            default: {
                LOG.log(Level.SEVERE, "Unknown export format {0}", format);
                return Optional.empty();
            }
        }
        return Optional.of(writer);
    }
}

