/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.results.export;

import com.geolang.ascema.managerpersistence.exportdata.IExportData;
import com.geolang.ascema.managerservice.controllers.results.export.IExportWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelExportWriter
implements IExportWriter {
    private SXSSFWorkbook wb;
    private SXSSFSheet sh;
    private String filename;
    private File zipFile;
    private ZipParameters zipParameters;
    private ZipOutputStream zipOut;
    private int count = 0;

    public void start(Path folderPath, String filename, String pwd) throws IOException {
        this.filename = filename;
        this.zipParameters = new ZipParameters();
        Path zipPath = Paths.get(folderPath.toString(), filename + ".zip");
        this.zipFile = zipPath.toFile();
        FileOutputStream fos = new FileOutputStream(this.zipFile);
        if (pwd != null && !pwd.isEmpty()) {
            this.zipParameters.setEncryptFiles(true);
            this.zipParameters.setEncryptionMethod(EncryptionMethod.AES);
            this.zipOut = new ZipOutputStream((OutputStream)fos, pwd.toCharArray());
        } else {
            this.zipOut = new ZipOutputStream((OutputStream)fos);
        }
    }

    public File end() {
        try {
            this.zipOut.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ExcelExportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.zipFile;
    }

    public void writeEnties(Stream<IExportData> str) {
        AtomicBoolean first = new AtomicBoolean(true);
        AtomicInteger rowCount = new AtomicInteger(1);
        str.forEach(data -> {
            if (first.get()) {
                this.createWorkbook(data);
                first.set(false);
            }
            SXSSFRow row = this.sh.createRow(rowCount.getAndIncrement());
            List vals = data.fieldValues();
            for (int i = 0; i < vals.size(); ++i) {
                row.createCell(i).setCellValue((String)vals.get(i));
            }
            if (rowCount.get() >= 100000) {
                this.endWorkbook();
                this.createWorkbook(data);
                rowCount.set(1);
            }
        });
        this.endWorkbook();
    }

    private void createWorkbook(IExportData data) {
        try {
            Path currentFilePath = Paths.get(this.filename + "_" + this.count + ".xlsx", new String[0]);
            ++this.count;
            this.zipParameters.setFileNameInZip(currentFilePath.toString());
            this.zipOut.putNextEntry(this.zipParameters);
            this.wb = new SXSSFWorkbook(10000);
            this.sh = this.wb.createSheet();
            SXSSFRow r = this.sh.createRow(0);
            List headers = data.fieldNames();
            for (int i = 0; i < headers.size(); ++i) {
                r.createCell(i).setCellValue((String)headers.get(i));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ExcelExportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void endWorkbook() {
        try {
            this.wb.write((OutputStream)this.zipOut);
            this.wb.close();
            this.zipOut.closeEntry();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ExcelExportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ExcelExportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

