/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.results.export;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geolang.ascema.managerdomain.domain.DatabaseResultStored;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerpersistence.exportdata.IExportData;
import com.geolang.ascema.managerpersistence.results.ResultEncryptorCache;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DBExportData
implements IExportData {
    private final List<String> vals = new ArrayList();
    private static List<String> headers = null;

    public static void setHeaders(List<String> headers, boolean decrypt) {
        DBExportData.headers = new ArrayList();
        DBExportData.headers.add("Table");
        DBExportData.headers.addAll(headers);
        DBExportData.headers.add("Matching Column");
        DBExportData.headers.add("Pattern Name");
        DBExportData.headers.add("Confidence");
        DBExportData.headers.add("Classification Labels");
        if (decrypt) {
            DBExportData.headers.add("Match Text");
        }
    }

    public DBExportData(DatabaseResultStored s, boolean decrypt, ClassificationLabelStore labelStore) {
        this.vals.add(s.getTableFullName());
        this.vals.addAll(s.getRowval());
        this.vals.add((String)headers.get(s.getColNum()));
        this.vals.add(s.getPatternDisplayName());
        this.vals.add(s.getConfidenceLevel().getDisplayName());
        Set labels = labelStore.getForPatternOrDefault(s.getPatternDisplayName(), s.getPatternName());
        this.vals.add(String.join((CharSequence)",", labels));
        if (decrypt) {
            String decrypted = ResultEncryptorCache.getInstance().getEncryptorForDeviceId(s.getDeviceId()).dec(s.getMatchingText());
            this.vals.add(decrypted);
        }
    }

    public List<String> fieldValues() {
        return this.vals;
    }

    public List<String> fieldNames() {
        return headers;
    }

    public String toJson(ObjectMapper mapper) throws JsonProcessingException {
        JsonObject obj = new JsonObject();
        for (int i = 0; i < this.vals.size(); ++i) {
            obj.addProperty((String)headers.get(i), (String)this.vals.get(i));
        }
        return obj.toString();
    }
}

