/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.results.export;

import com.geolang.ascema.managerpersistence.exportdata.IExportData;
import com.geolang.ascema.managerservice.controllers.results.export.IExportWriter;
import com.geolang.ascema.managerservice.rest.DataValidation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.commons.text.StringEscapeUtils;

public class CsvExportWriter
implements IExportWriter {
    private PrintWriter printWriter;
    private ZipOutputStream zipOut;
    private ZipParameters zipParameters;
    private String filename;
    private int count = 0;
    File zipFile;

    public void start(Path folderPath, String filename, String pwd) throws IOException {
        this.filename = filename;
        this.zipParameters = new ZipParameters();
        Path zipPath = Paths.get(folderPath.toString(), filename + ".zip");
        this.zipFile = zipPath.toFile();
        FileOutputStream fos = new FileOutputStream(this.zipFile);
        if (pwd != null && !pwd.isEmpty()) {
            this.zipParameters.setEncryptFiles(true);
            this.zipParameters.setEncryptionMethod(EncryptionMethod.AES);
            this.zipOut = new ZipOutputStream((OutputStream)fos, pwd.toCharArray());
        } else {
            this.zipOut = new ZipOutputStream((OutputStream)fos);
        }
        this.printWriter = new PrintWriter((OutputStream)this.zipOut);
    }

    public File end() {
        try {
            this.zipOut.close();
        }
        catch (IOException ex) {
            Logger.getLogger(CsvExportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.zipFile;
    }

    public void writeEnties(Stream<IExportData> str) {
        AtomicBoolean first = new AtomicBoolean(true);
        AtomicInteger rowCount = new AtomicInteger(1);
        str.forEach(data -> {
            if (first.get()) {
                this.createCsv(data);
                first.set(false);
            }
            rowCount.incrementAndGet();
            List vals = data.fieldValues();
            ListIterator<String> iter = vals.listIterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                if (DataValidation.startsWithCsvInjectionSymbol((String)s)) {
                    s = s.substring(1);
                }
                String escaped = StringEscapeUtils.escapeCsv((String)s).replaceAll("\\R", " ");
                iter.set(escaped);
            }
            String val = String.join((CharSequence)",", vals);
            this.printWriter.println(val);
            if (rowCount.get() >= 100000) {
                this.closeCsv();
                this.createCsv(data);
                rowCount.set(1);
            }
        });
        this.closeCsv();
    }

    private void createCsv(IExportData data) {
        try {
            String currentFilePath = Paths.get(this.filename + "_" + this.count + ".csv", new String[0]).toString();
            ++this.count;
            this.zipParameters.setFileNameInZip(currentFilePath);
            this.zipOut.putNextEntry(this.zipParameters);
            List headers = data.fieldNames();
            String head = String.join((CharSequence)",", headers);
            this.printWriter.println(head);
        }
        catch (IOException ex) {
            Logger.getLogger(CsvExportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void closeCsv() {
        try {
            this.printWriter.flush();
            this.zipOut.closeEntry();
        }
        catch (IOException ex) {
            Logger.getLogger(CsvExportWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

