/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.results;

import com.geolang.ascema.endpointcommon.domain.BaseResult;
import com.geolang.ascema.endpointcommon.domain.PasswordProtectedResult;
import com.geolang.ascema.endpointcommon.domain.UnprocessableFileResult;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.UnprocessableResultStored;
import com.geolang.ascema.managerdomain.web.UnprocessableDataPoint;
import com.geolang.ascema.managerdomain.web.UnprocessableDataSliceRequest;
import com.geolang.ascema.managerdomain.web.UnprocessableResultsPage;
import com.geolang.ascema.managerpersistence.UnprocessableResultsStore;
import com.geolang.ascema.managerpersistence.exportdata.IExportData;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.results.export.UnprocessableExportData;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class UnprocessableResultsManager {
    @Autowired
    private UnprocessableResultsStore store;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private AuditLogService auditLog;
    @Autowired
    private DeviceService deviceService;

    synchronized void addResult(UnprocessableFileResult unprocessableFileResult) {
        UnprocessableResultStored res = new UnprocessableResultStored(unprocessableFileResult, this.getDeviceName((BaseResult)unprocessableFileResult));
        boolean alreadyExists = this.store.alreadyExists(res);
        if (!alreadyExists) {
            this.store.save(res);
            this.auditLog.unProcessableFileSeen(this.taskManager, unprocessableFileResult);
        }
    }

    synchronized void addResult(PasswordProtectedResult passwordProtectedResult) {
        UnprocessableResultStored res = new UnprocessableResultStored(passwordProtectedResult, this.getDeviceName((BaseResult)passwordProtectedResult));
        boolean alreadyExists = this.store.alreadyExists(res);
        if (!alreadyExists) {
            this.store.save(res);
            this.auditLog.passwordProtectedFileSeen(this.taskManager, passwordProtectedResult);
        }
    }

    private String getDeviceName(BaseResult res) {
        String deviceName = res.getDeviceName();
        Optional reg = this.deviceService.getDeviceFromId(res.getDeviceId(), true);
        if (reg.isPresent()) {
            DeviceRegistration dr = (DeviceRegistration)reg.get();
            deviceName = dr.getDisplayName() != null && !dr.getDisplayName().isEmpty() ? dr.getDisplayName() : dr.deviceDescriptionOrCloudName();
        }
        return deviceName;
    }

    public Page<UnprocessableResultStored> findByTaskInstanceId(String taskInstanceId, Pageable pageable) {
        return this.store.findByTaskInstanceId(taskInstanceId, pageable);
    }

    public void deleteByTaskInstanceId(String taskInstanceId) {
        this.store.deleteByTaskInstanceId(taskInstanceId);
    }

    public void deleteByTaskInstanceIdAndDevice(String taskInstanceId, String deviceId) {
        this.store.deleteByTaskInstanceIdAndDeviceId(taskInstanceId, deviceId);
    }

    public long getCount(String taskInstanceId, String deviceId) {
        if (deviceId == null || deviceId.isEmpty()) {
            return this.store.countByTaskInstanceId(taskInstanceId);
        }
        return this.store.countByTaskInstanceIdAndDevice(taskInstanceId, deviceId);
    }

    public UnprocessableResultsPage getPageOfResults(UnprocessableDataSliceRequest req) {
        PageRequest pageable = PageRequest.of((int)req.getPage(), (int)req.getSize());
        String filter = req.getFilter() == null ? null : req.getFilter();
        Page srs = req.getDeviceId() == null || req.getDeviceId().isEmpty() ? this.store.getPagedResultsForTaskId(req.getTaskTemplateId(), filter, (Pageable)pageable) : this.store.getPagedResultsForDeviceAndTaskIds(req.getDeviceId(), req.getTaskTemplateId(), filter, (Pageable)pageable);
        UnprocessableResultsPage ret = new UnprocessableResultsPage();
        ret.setPageParts(srs);
        for (UnprocessableResultStored r : srs.toList()) {
            ret.getData().add(new UnprocessableDataPoint(r));
        }
        return ret;
    }

    public Stream<IExportData> getExportStream(UnprocessableDataSliceRequest req) {
        return this.store.streamForTaskInstance(req.getTaskTemplateId(), req.getFilter()).map(t -> {
            String taskName = t.getTaskInstanceId();
            Optional instOpt = this.taskManager.getTaskInstanceFromId(req.getTaskTemplateId());
            if (instOpt.isPresent()) {
                taskName = ((TaskInstance)instOpt.get()).getDisplayName();
            }
            UnprocessableExportData ret = UnprocessableExportData.fromResult((UnprocessableResultStored)t, (String)taskName);
            return ret;
        });
    }
}

