/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.results;

import com.geolang.ascema.endpointcommon.database.DatabaseSearchResult;
import com.geolang.ascema.endpointcommon.domain.BaseResult;
import com.geolang.ascema.endpointcommon.domain.ConfirmResult;
import com.geolang.ascema.endpointcommon.domain.EmbeddingResult;
import com.geolang.ascema.endpointcommon.domain.PasswordProtectedResult;
import com.geolang.ascema.endpointcommon.domain.QuarantineResult;
import com.geolang.ascema.endpointcommon.domain.RetrievalResult;
import com.geolang.ascema.endpointcommon.domain.SearchResult;
import com.geolang.ascema.endpointcommon.domain.UnprocessableFileResult;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerevents.ConfirmResultEvent;
import com.geolang.ascema.managerevents.DatabaseResultsAvailableEvent;
import com.geolang.ascema.managerevents.ResultsAvailableEvent;
import com.geolang.ascema.managerservice.controllers.DatabaseSearchController;
import com.geolang.ascema.managerservice.controllers.KnowledgeBaseController;
import com.geolang.ascema.managerservice.controllers.results.ResultsManager;
import com.geolang.ascema.managerservice.controllers.results.ResultsReciever;
import com.geolang.ascema.managerservice.controllers.results.UnprocessableResultsManager;
import com.geolang.ascema.managerservice.controllers.retrieval.FileRetrievalManager;
import com.geolang.ascema.managerservice.controllers.tasks.actions.QuarantineController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResultsReciever {
    @Autowired
    private ResultsManager resultsManager;
    @Autowired
    private DatabaseSearchController dbResultsMgr;
    @Autowired
    private UnprocessableResultsManager unprocessableManager;
    @Autowired
    private FileRetrievalManager fileRetrievalManager;
    @Autowired
    private QuarantineController qManager;
    @Autowired
    private KnowledgeBaseController knowledgeBaseController;

    public boolean addResult(BaseResult result) {
        switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$BaseResult$ResultType[result.getResultType().ordinal()]) {
            case 1: {
                RetrievalResult rr = (RetrievalResult)result;
                return this.fileRetrievalManager.addResult(rr);
            }
            case 2: 
            case 3: {
                SearchResult sr = (SearchResult)result;
                boolean ret = this.resultsManager.processSearchResult(sr);
                MessageBus.getBus().post((Object)new ResultsAvailableEvent(sr));
                return ret;
            }
            case 4: {
                DatabaseSearchResult sr = (DatabaseSearchResult)result;
                boolean ret = this.dbResultsMgr.storeResult(sr);
                MessageBus.getBus().post((Object)new DatabaseResultsAvailableEvent(sr));
                return ret;
            }
            case 5: {
                this.unprocessableManager.addResult((UnprocessableFileResult)result);
                break;
            }
            case 6: {
                this.unprocessableManager.addResult((PasswordProtectedResult)result);
                break;
            }
            case 7: {
                ConfirmResult res = (ConfirmResult)result;
                this.resultsManager.processConfirmResult(res);
                MessageBus.getBus().post((Object)new ConfirmResultEvent(res));
                break;
            }
            case 8: {
                QuarantineResult res = (QuarantineResult)result;
                this.qManager.updateResult(res);
                return true;
            }
            case 9: {
                this.knowledgeBaseController.addDocument((EmbeddingResult)result);
                return true;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

