/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.results;

import com.geolang.ascema.domainmodelpublic.IPatternMatchResult;
import com.geolang.ascema.domainmodelpublic.PatternMatchResult;
import com.geolang.ascema.domainmodelpublic.ResultStatus;
import com.geolang.ascema.domainmodelpublic.ResultStatusReason;
import com.geolang.ascema.endpointcommon.discovery.encrypt.MatchingTextEncryptor;
import com.geolang.ascema.endpointcommon.domain.AlertMsg;
import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.BaseResult;
import com.geolang.ascema.endpointcommon.domain.CloudPlatformAreaType;
import com.geolang.ascema.endpointcommon.domain.ConfirmResult;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.Job;
import com.geolang.ascema.endpointcommon.domain.JobState;
import com.geolang.ascema.endpointcommon.domain.NamedArea;
import com.geolang.ascema.endpointcommon.domain.SearchResult;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionResult;
import com.geolang.ascema.endpointcommon.messages.servernotification.OpenFileServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerNotificationBase;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.domain.BaseMatchStored;
import com.geolang.ascema.managerdomain.domain.JobDeviceState;
import com.geolang.ascema.managerdomain.domain.MatchStored;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.dto.DTOResult;
import com.geolang.ascema.managerdomain.dto.DTOResultIdAndPath;
import com.geolang.ascema.managerdomain.dto.GroupBy;
import com.geolang.ascema.managerdomain.web.results.DataRequest;
import com.geolang.ascema.managerevents.ResultsStateChangeEvent;
import com.geolang.ascema.managerpersistence.CloudUserMappingStore;
import com.geolang.ascema.managerpersistence.DatabaseCleaner;
import com.geolang.ascema.managerpersistence.EventHistoryStore;
import com.geolang.ascema.managerpersistence.StoredResultStore;
import com.geolang.ascema.managerpersistence.exportdata.IExportData;
import com.geolang.ascema.managerpersistence.results.DataPoint;
import com.geolang.ascema.managerpersistence.results.DataPointSlice;
import com.geolang.ascema.managerpersistence.results.DataPointWithChildren;
import com.geolang.ascema.managerpersistence.results.MatchesManager;
import com.geolang.ascema.managerpersistence.results.datapoint.DataPointFac;
import com.geolang.ascema.managerpersistence.results.datapoint.DataPointManager;
import com.geolang.ascema.managerpersistence.serviceinterfaces.ITaskManager;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.AlertingController;
import com.geolang.ascema.managerservice.controllers.ServerMessagesOutQueue;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.results.ResultsManager;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.controllers.tasks.actions.ActionsController;
import com.geolang.ascema.managerservice.controllers.tasks.actions.DeferredActionsController;
import jakarta.annotation.PostConstruct;
import jakarta.persistence.EntityManager;
import java.lang.invoke.CallSite;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ResultsManager {
    private static final Logger LOG = Logger.getLogger(ResultsManager.class.getName());
    @Lazy
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private StoredResultStore resultsStore;
    @Autowired
    private DeviceService endpointService;
    @Autowired
    private AuditLogService auditLog;
    @Autowired
    private EventHistoryStore eventHistoryStore;
    @Autowired
    private CloudUserMappingStore cloudUserMappingStore;
    @Autowired
    AlertingController alertingController;
    @Autowired
    private DataPointFac dpFac;
    @Autowired
    MatchesManager matchesManager;
    @Autowired
    private DeferredActionsController deferredController;
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private DataPointManager pageCache;
    @Autowired
    private ActionsController actionRunner;
    @Autowired
    private DataSource dataSource;
    private final Map<String, MatchingTextEncryptor> encryptorCache = new HashMap();
    private final ExecutorService cleanupExecutor = Executors.newSingleThreadExecutor();

    @PostConstruct
    public void init() throws Exception {
        this.entityManager.setProperty("jakarta.persistence.query.timeout", (Object)6000);
        this.cleanupExecutor.submit(() -> this.removeDeadResults());
    }

    private void removeDeadResults() {
        ArrayList<String> taskIds = new ArrayList<String>();
        try (Connection db = this.dataSource.getConnection();
             CallableStatement st = db.prepareCall("select distinct TASK_INSTANCE_ID from SEARCH_RESULT_STORED where TASK_INSTANCE_ID NOT IN (select UID from TASK_INSTANCE)");){
            ResultSet res = st.executeQuery();
            while (res.next()) {
                String taskInstanceId = res.getString(1);
                taskIds.add(taskInstanceId);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DatabaseCleaner.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (String taskInstanceId : taskIds) {
            LOG.log(Level.INFO, "Remove dead results that have no task instance {0}", taskInstanceId);
            try {
                this.resultsStore.deleteAllResultsForTaskInstance(taskInstanceId);
            }
            catch (DataAccessException ex) {
                Logger.getLogger(DatabaseCleaner.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public Stream<IExportData> getExportStream(DataRequest req) {
        return this.pageCache.getLeafResultsStream(req);
    }

    @Transactional(readOnly=true)
    public List<DataPoint> getSubSlice(DataRequest req) {
        return this.pageCache.getSubSlice(req);
    }

    @Transactional(readOnly=true)
    public Optional<DataPointSlice> getResultsSlice(DataRequest req) {
        return this.pageCache.getResultsSlice(req);
    }

    @Transactional(readOnly=true)
    public Optional<DataPointSlice> getLatestResultsForCloudUser(DataRequest req) {
        List taskIds = this.taskManager.getLatestUnifiedSearchTasksWithPartialAndRealtime();
        return this.pageCache.getUserIdLatestSlice(req, taskIds);
    }

    @Transactional(readOnly=true)
    public Optional<DataPointSlice> getLatestResultsForDevice(DataRequest req) {
        String deviceId = req.getKey();
        List taskIds = this.taskManager.getLatestInstancesSearchAndRealtimeForDeviceWithPartial(deviceId);
        if (taskIds.isEmpty()) {
            LOG.log(Level.WARNING, "no task instances found for device {0}", deviceId);
            return Optional.empty();
        }
        return this.pageCache.getDeviceLatestSlice(req, taskIds);
    }

    @Transactional(readOnly=true)
    public List<DataPoint> getLatestResultsForCloudUserForFilePath(String filePath, DataRequest req) {
        List taskIds = this.taskManager.getLatestUnifiedSearchTasksWithPartialAndRealtime();
        return this.pageCache.getUserIdDatapointsForFile(filePath, taskIds, req);
    }

    @Transactional(readOnly=true)
    public List<DataPoint> getLatestResultsForDeviceForFilePath(String filePath, DataRequest req) {
        String deviceId = req.getKey();
        List taskIds = this.taskManager.getLatestInstancesSearchAndRealtimeForDeviceWithPartial(deviceId);
        if (taskIds.isEmpty()) {
            LOG.log(Level.WARNING, "no task instances found for device {0}", deviceId);
            return Collections.emptyList();
        }
        return this.pageCache.getDeviceDatapointsForFile(filePath, taskIds, req);
    }

    @Transactional(readOnly=true, propagation=Propagation.SUPPORTS)
    public Optional<SearchResultStored> getResultById(Long id) {
        return this.resultsStore.getStoredResultById(id);
    }

    public List<String> getLatestInstancesForDeviceWhereJobIsFinished(String deviceId) {
        List types = BaseCommand.getSearchAndRTCommandTypes();
        return this.taskManager.getLatestInstancesForDeviceWhereJobRanToCompletion(deviceId, types);
    }

    @Transactional(readOnly=true, propagation=Propagation.SUPPORTS)
    public Stream<DTOResult> getResultsInQuarantine(String deviceId) {
        return this.resultsStore.getResultsInQuarantine(deviceId);
    }

    @Transactional(readOnly=true, propagation=Propagation.SUPPORTS)
    public Stream<DTOResult> getResultsForTaskInstanceAndDevice(String jobPlanId, String deviceId) {
        return this.resultsStore.getSearchResultsForTaskInstanceAndDevice(jobPlanId, deviceId);
    }

    @Transactional(readOnly=true, propagation=Propagation.SUPPORTS)
    public Stream<SearchResultStored> getStoredResultsForTaskInstanceAndDevice(String jobPlanId, String deviceId) {
        return this.resultsStore.getStoredSearchResultsForTaskInstanceAndDevice(jobPlanId, deviceId);
    }

    @Transactional(readOnly=true, propagation=Propagation.SUPPORTS)
    public Optional<SearchResultStored> getResult(Long id) {
        return this.resultsStore.getResult(id);
    }

    @Transactional(readOnly=true, propagation=Propagation.SUPPORTS)
    public List<MatchStored> getMatchesForResult(Long id) {
        return this.resultsStore.getMatchesForResult(id);
    }

    public Stream<SearchResultStored> stream(String instanceId) {
        return this.resultsStore.stream(instanceId);
    }

    public Optional<DataPoint> getIndividualMatch(Long matchId) {
        DataPoint leaf = this.dpFac.getDataPointFromMatchId(matchId, false);
        if (leaf.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(leaf);
    }

    public Optional<DataPoint> getMatch(Long matchId, GroupBy groupBy, boolean isRetrieval) {
        DataPoint leaf = this.dpFac.getDataPointFromMatchId(matchId, isRetrieval);
        if (leaf.isEmpty()) {
            return Optional.empty();
        }
        String key = leaf.getTopLevelGroupingKey(groupBy);
        DataPointWithChildren inter = DataPointWithChildren.inter((DataPoint)leaf);
        ArrayList<DataPoint> children = new ArrayList<DataPoint>();
        children.add(leaf);
        inter.setChildren(children);
        inter.setNumChildrenAvailable(1);
        DataPointWithChildren rootNode = switch (1.$SwitchMap$com$geolang$ascema$managerdomain$dto$GroupBy[groupBy.ordinal()]) {
            case 1 -> DataPointWithChildren.topLevelDevice((String)key, (String)leaf.getDeviceId());
            case 2 -> DataPointWithChildren.topLevelFile((String)key, (String)leaf.getLink());
            case 3 -> DataPointWithChildren.topLevelPattern((String)key);
            case 4 -> DataPointWithChildren.topLevelNamedArea((String)key);
            case 5 -> DataPointWithChildren.topLevelRepoPath((String)key);
            default -> DataPointWithChildren.topLevelUser((String)key, (String)leaf.getUserId());
        };
        rootNode.addNumChildrenAvailable(1);
        List<DataPointWithChildren> allInters = Collections.singletonList(inter);
        rootNode.setChildren(allInters);
        return Optional.of(rootNode);
    }

    public long getResultsCountForTaskInstance(String jobPlanId) {
        return this.resultsStore.getResultCountsForTaskInstance(jobPlanId);
    }

    public boolean alertManually(String name, Long[] ids, AlertMsg msg, boolean idIsForMatch) {
        boolean ret = true;
        HashSet<String> deviceIds = new HashSet<String>();
        HashMap deviceToClouduserIds = new HashMap();
        HashMap deviceToSearchResult = new HashMap();
        for (Long id : ids) {
            Optional res = Optional.empty();
            if (idIsForMatch) {
                Optional opt = this.matchesManager.findById(id);
                if (opt.isEmpty()) {
                    LOG.log(Level.WARNING, "No match found for id {0}", id);
                } else {
                    Long srsId = ((MatchStored)opt.get()).getSearchResultStoredId();
                    res = this.resultsStore.getResult(srsId);
                }
            } else {
                res = this.resultsStore.getResult(id);
            }
            if (res.isPresent()) {
                SearchResultStored searchResult = (SearchResultStored)res.get();
                NamedArea na = searchResult.getNamedArea();
                CloudPlatformAreaType cloudArea = na.getCloudAreaType();
                if (CloudPlatformAreaType.isGoogle((CloudPlatformAreaType)cloudArea) || CloudPlatformAreaType.isO365((CloudPlatformAreaType)cloudArea)) {
                    if (!deviceToClouduserIds.containsKey(searchResult.getDeviceId())) {
                        deviceToClouduserIds.put(searchResult.getDeviceId(), new HashSet());
                    }
                    ((Set)deviceToClouduserIds.get(searchResult.getDeviceId())).add(searchResult.getUserId());
                } else if (CloudPlatformAreaType.isAtlassian((CloudPlatformAreaType)cloudArea)) {
                    if (!deviceToSearchResult.containsKey(searchResult.getDeviceId())) {
                        deviceToSearchResult.put(searchResult.getDeviceId(), new HashSet());
                    }
                    ((Set)deviceToSearchResult.get(searchResult.getDeviceId())).add(searchResult);
                } else {
                    deviceIds.add(searchResult.getDeviceId());
                }
                this.matchesManager.setStatusFoundToAlerted(searchResult);
                this.auditLog.fileStatusChange(this.taskManager, name, "", ResultStatus.ALERTED, ResultStatusReason.PROCESSED, "", searchResult.getTaskInstanceId(), searchResult.getDeviceId(), searchResult.getFilePath());
                this.entityManager.detach(res.get());
                this.eventHistoryStore.setStatusAlertedManually((ITaskManager)this.taskManager, name, id, searchResult);
                continue;
            }
            LOG.log(Level.WARNING, "Failed to find result to manually alert {0}", id);
            ret = false;
        }
        if (!deviceIds.isEmpty()) {
            this.alertingController.alertMultipleEndpoint(new ArrayList(deviceIds), msg);
        }
        if (!deviceToClouduserIds.isEmpty()) {
            for (Map.Entry entry : deviceToClouduserIds.entrySet()) {
                this.alertingController.alertMultipleCloudUsers((String)entry.getKey(), msg, new ArrayList((Collection)entry.getValue()));
            }
        }
        if (!deviceToSearchResult.isEmpty()) {
            for (Map.Entry entry : deviceToSearchResult.entrySet()) {
                this.alertingController.alertMultipleAtlassianUsers((String)entry.getKey(), msg, new ArrayList((Collection)entry.getValue()));
            }
        }
        return ret;
    }

    public boolean setStatusForAllResults(String user, String email, ResultStatus status, ResultStatusReason reason, String customReason, String searchJobInstanceId, String[] otherTaskIds, String deviceId, String filePath, String subPath) {
        boolean ret = this.setStatusForAllResultsPriv(user, email, status, reason, customReason, searchJobInstanceId, deviceId, filePath, subPath);
        for (String id : otherTaskIds) {
            this.setStatusForAllResultsPriv(user, email, status, reason, customReason, id, deviceId, filePath, subPath);
        }
        MessageBus.getBus().post((Object)new ResultsStateChangeEvent(deviceId));
        return ret;
    }

    public boolean updateSelecteResultStatus(String user, String email, String taskId, String[] otherTaskIds, String deviceId, Collection<MatchStored> results, String filePath, String subPath) {
        boolean ret = this.updateSelecteResultStatusPriv(user, email, taskId, deviceId, results, filePath, subPath);
        if (otherTaskIds != null) {
            for (String id : otherTaskIds) {
                this.updateSelecteResultStatusPriv(user, email, id, deviceId, results, filePath, subPath);
            }
        }
        MessageBus.getBus().post((Object)new ResultsStateChangeEvent(deviceId));
        return ret;
    }

    private boolean setStatusForAllResultsPriv(String user, String email, ResultStatus status, ResultStatusReason reason, String customReason, String searchJobInstanceId, String deviceId, String filePath, String subPath) {
        List res = this.resultsStore.getResultsForTaskInstanceAndDeviceAndFile(searchJobInstanceId, deviceId, filePath);
        if (res == null) {
            LOG.log(Level.WARNING, "Failed to find result to update {0}", filePath);
            return false;
        }
        for (SearchResultStored sr : res) {
            this.matchesManager.setStatus(sr, status, reason, customReason);
        }
        this.auditLog.fileStatusChange(this.taskManager, user, email, status, reason, customReason, searchJobInstanceId, deviceId, filePath);
        this.eventHistoryStore.statusChange((ITaskManager)this.taskManager, user, status, reason, customReason, searchJobInstanceId, deviceId, filePath, subPath);
        if (!res.isEmpty()) {
            this.possiblyFireUndoAction(user, (SearchResultStored)res.get(0));
        }
        return true;
    }

    private boolean updateSelecteResultStatusPriv(String user, String email, String taskId, String deviceId, Collection<MatchStored> results, String filePath, String subPath) {
        List brs = this.resultsStore.getResultsForTaskInstanceAndDeviceAndFile(taskId, deviceId, filePath);
        if (brs.isEmpty()) {
            LOG.warning("Can't find results to update");
            return false;
        }
        boolean ret = false;
        for (SearchResultStored toChange : brs) {
            MatchesManager.MatchesAndChanged mAndS = this.matchesManager.update(toChange, results, filePath, subPath);
            if (mAndS.changed().isEmpty()) continue;
            this.auditLog.resultStatusChange(this.taskManager, user, email, taskId, deviceId, (Collection)mAndS.changed(), filePath);
            this.eventHistoryStore.statusChange((ITaskManager)this.taskManager, user, taskId, deviceId, (Collection)mAndS.changed(), filePath, subPath);
            ret = true;
        }
        this.possiblyFireUndoAction(user, (SearchResultStored)brs.get(0));
        return ret;
    }

    private void possiblyFireUndoAction(String user, SearchResultStored sr) {
        if (!sr.isHasPerformedAction()) {
            return;
        }
        if (sr.getActionableId() == null || sr.getActionableId().isEmpty()) {
            return;
        }
        String taskId = sr.getJobId();
        Optional ti = this.taskManager.getTaskInstanceFromId(taskId);
        if (ti.isEmpty()) {
            LOG.log(Level.WARNING, "Failed to find task instance for undo {0}", taskId);
            return;
        }
        ArrayList allThisActionableId = new ArrayList();
        TaskInstance instance = (TaskInstance)ti.get();
        List allTaskInstanceIds = new ArrayList<String>();
        if (instance.getCommandType().equals((Object)BaseCommand.CommandType.PROTECT)) {
            allTaskInstanceIds.add(instance.getUid());
        } else {
            allTaskInstanceIds = this.taskManager.getLatestUnifiedSearchTasksWithPartial(((TaskInstance)ti.get()).getParentTemplateId());
        }
        HashSet<CallSite> checked = new HashSet<CallSite>();
        for (String instId : allTaskInstanceIds) {
            List allThisTask = this.resultsStore.getResultsForTaskInstanceAndDeviceAndActionableId(instId, sr.getDeviceId(), sr.getActionableId());
            allThisActionableId.addAll(allThisTask);
            for (SearchResultStored srs : allThisTask) {
                if (!srs.isHasPerformedAction()) continue;
                for (MatchStored match : this.matchesManager.getAllResultsList(srs.getId())) {
                    String matchUniqueHopefully = match.getLocation() + srs.getConfirmPath();
                    if (!checked.contains(matchUniqueHopefully) && !match.getStatus().equals((Object)ResultStatus.CONFIRMED_RESOLVED)) {
                        return;
                    }
                    checked.add((CallSite)((Object)matchUniqueHopefully));
                }
            }
        }
        LOG.log(Level.INFO, "all confirmed resolved for {0}", sr.getActionableId());
        TaskInstance inst = (TaskInstance)ti.get();
        if (!inst.isAutomaticUndoActions()) {
            return;
        }
        boolean hasActions = inst.hasActions(sr.getNamedArea());
        if (!hasActions) {
            return;
        }
        LOG.log(Level.INFO, "Fire automatic undo command for {0}", sr.getFilePath());
        for (SearchResultStored srs : allThisActionableId) {
            if (!srs.isHasPerformedAction()) continue;
            this.actionRunner.runAutomaticUndo(user, srs, inst);
        }
    }

    public boolean processSearchResult(SearchResult sr) {
        try {
            int timesFound;
            String filePath = sr.getFilePath();
            sr = this.updateForCloudUserId(sr);
            SearchResultStored toStore = null;
            boolean alertRt = true;
            if (BaseResult.ResultType.SEARCH_RESULT.equals((Object)sr.getResultType())) {
                List existingResults = this.resultsStore.getResultsForTaskInstanceAndDeviceAndFileAndSubPath(sr.getJobId(), sr.getDeviceId(), sr.getFilePath(), sr.getSubPath());
                if (!existingResults.isEmpty()) {
                    Iterator iter = existingResults.iterator();
                    while (iter.hasNext() && toStore == null) {
                        SearchResultStored existing = (SearchResultStored)iter.next();
                        if (!this.identicalResultsApartFromDates(sr, existing)) continue;
                        LOG.log(Level.INFO, "{0} {1} already found", new Object[]{sr.getFilePath(), sr.getSubPath()});
                        toStore = existing;
                        break;
                    }
                }
            } else if (BaseResult.ResultType.RT_PROTECT_RESULT.equals((Object)sr.getResultType())) {
                List existingRTResults = this.resultsStore.getResultsForTaskInstanceAndDeviceAndFileAndSubPath(sr.getJobId(), sr.getDeviceId(), sr.getFilePath(), sr.getSubPath());
                if (existingRTResults.size() > 1) {
                    LOG.log(Level.SEVERE, "should only have one rt result for {0} {1}", new Object[]{sr.getFilePath(), sr.getSubPath()});
                }
                if (!existingRTResults.isEmpty()) {
                    Iterator iter = existingRTResults.iterator();
                    while (iter.hasNext() && toStore == null) {
                        SearchResultStored existing = (SearchResultStored)iter.next();
                        boolean hasPerformedAction = sr.getActionResult().getStatus().equals((Object)ActionResult.ActionResultType.OK);
                        boolean hasIgnoredAction = sr.getActionResult().getStatus().equals((Object)ActionResult.ActionResultType.IGNORED);
                        existing.setHasIgnoredAction(hasIgnoredAction);
                        existing.setHasPerformedAction(hasPerformedAction);
                        existing.setConfirmPath(sr.getConfirmPath());
                        List existingMatches = this.resultsStore.getMatchesForResult(existing.getId());
                        HashMap statusreasons = new HashMap();
                        MatchingTextEncryptor enc = new MatchingTextEncryptor(existing.getDeviceId());
                        AtomicBoolean oneAlerted = new AtomicBoolean(false);
                        existingMatches.forEach(pmr -> {
                            statusreasons.put(String.valueOf(pmr.getMatchingTextDigest()) + Integer.toString(pmr.getLocation()), pmr);
                            if (pmr.getStatus().equals((Object)ResultStatus.ALERTED)) {
                                oneAlerted.set(true);
                            }
                        });
                        alertRt = !oneAlerted.get();
                        sr.getResults().forEach(pm -> {
                            String matchingTextDigest = pm.getMatchingTextDigest().hash();
                            if (statusreasons.containsKey(matchingTextDigest + Integer.toString(pm.getLocation()))) {
                                BaseMatchStored previous = (BaseMatchStored)statusreasons.get(matchingTextDigest + Integer.toString(pm.getLocation()));
                                if (!previous.getStatus().equals((Object)ResultStatus.FOUND) && !previous.getResultStatusReason().equals((Object)ResultStatusReason.REDACTED)) {
                                    pm.setStatus(previous.getStatus());
                                    pm.setResultStatusReason(previous.getResultStatusReason());
                                    pm.setCustomStatusReason(previous.getCustomStatusReason());
                                }
                            } else if (oneAlerted.get()) {
                                pm.setStatus(ResultStatus.ALERTED);
                                LOG.log(Level.INFO, "new result has existing alert for file {0}", filePath);
                            }
                        });
                        this.resultsStore.replaceResults(existing, sr.getResults());
                        toStore = existing;
                        this.update(toStore);
                        LOG.info("Append to existing results");
                    }
                }
            }
            if (toStore == null) {
                Optional optSrs = this.resultsStore.storeNewResults(sr);
                if (!optSrs.isPresent()) {
                    return false;
                }
                toStore = (SearchResultStored)optSrs.get();
                this.eventHistoryStore.addNewResults((ITaskManager)this.taskManager, sr);
                LOG.log(Level.INFO, "Add  {0} results for {1}", new Object[]{toStore.getMatchstored().size(), sr.getFilePath()});
            }
            if (BaseResult.ResultType.SEARCH_RESULT.equals((Object)sr.getResultType()) && (timesFound = this.updateStatusForNewResult(toStore)) > 0) {
                this.resultsStore.setTimesFound(toStore, timesFound);
            }
            if (alertRt && BaseResult.ResultType.RT_PROTECT_RESULT.equals((Object)sr.getResultType())) {
                this.alertRTResultIfNeeded(toStore);
            }
            this.deferredController.createDeferredActionsFromResult(toStore);
            this.auditLog.resultsAdded(this.taskManager, toStore);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "failed to add result {0}", e);
            return false;
        }
    }

    void processConfirmResult(ConfirmResult res) {
        ArrayList<MatchStored> matches = new ArrayList<MatchStored>();
        for (IPatternMatchResult pm : res.getResults()) {
            matches.add(new MatchStored(pm));
        }
        this.updateSelecteResultStatus(res.getCreatedBy(), "", res.getSearchTaskId(), res.getOtherTaskIds(), res.getDeviceId(), matches, res.getFilePath(), res.getSubPath());
    }

    private synchronized MatchingTextEncryptor getEncryptorForDevice(String deviceId) {
        if (this.encryptorCache.containsKey(deviceId)) {
            return (MatchingTextEncryptor)this.encryptorCache.get(deviceId);
        }
        MatchingTextEncryptor enc = new MatchingTextEncryptor(deviceId);
        this.encryptorCache.put(deviceId, enc);
        return enc;
    }

    private int updateStatusForNewResult(SearchResultStored storedResult) {
        Optional opt = this.taskManager.getTaskInstanceFromId(storedResult.getTaskInstanceId());
        if (!opt.isPresent()) {
            return 0;
        }
        TaskInstance taskInstance = (TaskInstance)opt.get();
        String templateId = taskInstance.getParentTemplateId();
        Optional jobds = taskInstance.getStateForDevice(storedResult.getDeviceId());
        Optional job = taskInstance.getExistingJob(storedResult.getDeviceId());
        if (jobds.isPresent() && job.isPresent() && ((JobDeviceState)jobds.get()).getState().equals((Object)JobState.DONE) && ((Job)job.get()).isPerformActionAutomatically()) {
            this.matchesManager.setStatusFoundToAlertedAuto(storedResult);
        }
        BaseResult.ResultType[] types = BaseResult.searchAndRealtimeTypes();
        List previousResultsForDeviceAndFile = this.resultsStore.getPreviousResultsForDeviceAndFilePathAndSubPath(storedResult.getTaskInstanceId(), storedResult.getDeviceId(), storedResult.getFilePath(), storedResult.getSubPath(), types);
        if (previousResultsForDeviceAndFile.isEmpty()) {
            return 0;
        }
        ArrayList<SearchResultStored> previousResults = new ArrayList<SearchResultStored>();
        for (SearchResultStored ssr : previousResultsForDeviceAndFile) {
            Optional optTi = this.taskManager.getTaskInstanceFromId(ssr.getTaskInstanceId());
            if (!optTi.isPresent() || !((TaskInstance)optTi.get()).getParentTemplateId().equals(templateId) || storedResult.getEventDate().equals(ssr.getEventDate())) continue;
            previousResults.add(ssr);
        }
        if (previousResults.isEmpty()) {
            return 0;
        }
        Collections.sort(previousResults);
        SearchResultStored lastInstance = (SearchResultStored)previousResults.get(previousResults.size() - 1);
        int ret = lastInstance.getTimesFound() + 1;
        this.matchesManager.updateResultsFromPrevious(storedResult.getId(), lastInstance);
        this.possiblyFireUndoAction("from previous", storedResult);
        return ret;
    }

    public boolean identicalResultsApartFromDates(SearchResult newResult, SearchResultStored other) {
        List otherMatches = this.matchesManager.getAllResultsList(other.getId());
        other.setMatchstored(otherMatches);
        if (otherMatches.size() != newResult.getResults().size()) {
            return false;
        }
        TreeSet thisresults = new TreeSet(newResult.getResults());
        TreeSet otherresults = new TreeSet(otherMatches);
        Iterator thisIter = thisresults.iterator();
        Iterator otherIter = otherresults.iterator();
        while (thisIter.hasNext()) {
            PatternMatchResult t = (PatternMatchResult)thisIter.next();
            BaseMatchStored o = (BaseMatchStored)otherIter.next();
            if (o.compareTo(t) == 0) continue;
            return false;
        }
        return true;
    }

    private SearchResult updateForCloudUserId(SearchResult sr) {
        String user;
        boolean dontTranslate;
        sr.setUserId("");
        NamedArea area = sr.getNamedArea();
        CloudPlatformAreaType cloudType = area.getCloudAreaType();
        boolean bl = dontTranslate = cloudType.equals((Object)CloudPlatformAreaType.NONE) || cloudType.equals((Object)CloudPlatformAreaType.ALFRESCO);
        if (!dontTranslate && (user = sr.getUser()) != null && !user.isEmpty()) {
            String uuid = this.cloudUserMappingStore.createOrGetUUIDFromEmail(user);
            sr.setUserId(uuid);
        }
        return sr;
    }

    public boolean openFile(String path, String link, String devId, boolean fromMaster) {
        try {
            List res;
            if (!fromMaster && ((res = this.resultsStore.getResultsForDeviceAndFilePath(devId, path, BaseResult.searchAndRealtimeTypes())) == null || res.isEmpty())) {
                LOG.info("Not opening file we haven't seen");
                return false;
            }
            return ServerMessagesOutQueue.Status.SENT.equals(this.endpointService.getOutQueue().sendMessage(devId, (ServerNotificationBase)new OpenFileServerMessage(path, link), false).get());
        }
        catch (InterruptedException | ExecutionException ex) {
            Logger.getLogger(ResultsManager.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public Optional<String> unRedactMatch(Long matchId) {
        Optional storedMatchOpt = this.matchesManager.findById(matchId);
        if (storedMatchOpt.isEmpty()) {
            return Optional.empty();
        }
        MatchStored match = (MatchStored)storedMatchOpt.get();
        Optional srOpt = this.getResultById(match.getSearchResultStoredId());
        if (srOpt.isEmpty()) {
            return Optional.empty();
        }
        SearchResultStored sr = (SearchResultStored)srOpt.get();
        MatchingTextEncryptor enc = new MatchingTextEncryptor(sr.getDeviceId());
        return Optional.of(enc.dec(match.getMatchingText()));
    }

    public List<SearchResultStored> getResultsForDeviceAndFilePath(String deviceId, String filePath, BaseResult.ResultType[] searchAndRealtimeTypes) {
        return this.resultsStore.getResultsForDeviceAndFilePath(deviceId, filePath, searchAndRealtimeTypes);
    }

    public SearchResultStored update(SearchResultStored sr) {
        return this.resultsStore.updateResult(sr);
    }

    public void setStatusOnSearchResultsForTest(SearchResultStored existing, ResultStatus status, ResultStatusReason reason, Date from) {
        this.resultsStore.setStatusOnSearchResultsForTest(existing, status, reason, from);
    }

    public Iterable<SearchResultStored> getResultsForActionableId(String id) {
        return this.resultsStore.getResultsForActionableId(id);
    }

    public Iterable<SearchResultStored> getResultsForActionableIdAndTaskId(String actId, String taskId) {
        return this.resultsStore.getResultsForActionableIdAndTaskId(actId, taskId);
    }

    private void alertRTResultIfNeeded(SearchResultStored sr) {
        Optional opt = this.taskManager.getTaskInstanceFromId(sr.getTaskInstanceId());
        if (!opt.isPresent()) {
            return;
        }
        TaskInstance taskInstance = (TaskInstance)opt.get();
        if (taskInstance.isAlertAutomatically()) {
            DeviceType type = sr.getDeviceType();
            HashSet<String> userIds = new HashSet<String>();
            userIds.add(sr.getUserId());
            boolean alerted = false;
            switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$DeviceType[type.ordinal()]) {
                case 1: 
                case 2: {
                    alerted = this.alertingController.sendAutomatedAlertForCloud(sr.getDeviceId(), userIds, type);
                    break;
                }
                case 3: {
                    alerted = this.alertingController.sendAutomatedAlertForAlfresco(taskInstance.getUid(), sr.getDeviceId());
                    break;
                }
                case 4: {
                    ArrayList<SearchResultStored> forAltassian = new ArrayList<SearchResultStored>();
                    forAltassian.add(sr);
                    alerted = this.alertingController.sendAutomatedAlertForAtlassian(taskInstance.getUid(), sr.getDeviceId(), forAltassian, Optional.empty());
                    break;
                }
            }
            if (alerted) {
                this.matchesManager.setStatusFoundToAlertedAuto(sr);
            }
        }
    }

    public Page<DTOResultIdAndPath> getPagedResultsIdForDeviceAndTaskIds(String deviceId, List<String> taskIds, String filter, boolean showQuarantined, Pageable pageable) {
        return this.resultsStore.getResultsPageForDeviceAndTaskId(showQuarantined, deviceId, taskIds, filter, pageable);
    }
}

