/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.patterns;

import com.geolang.ascema.domainmodelpublic.IPatternMatchResult;
import com.geolang.ascema.domainmodelpublic.PatternMatchResult;
import com.geolang.ascema.domainmodelpublic.pattern.BuiltInPatternNames;
import com.geolang.ascema.domainmodelpublic.pattern.IDisplayPattern;
import com.geolang.ascema.domainmodelpublic.pattern.PatternContextWords;
import com.geolang.ascema.endpointcommon.domain.PatternConfig;
import com.geolang.ascema.endpointcommon.domain.clouditems.MIPLabel;
import com.geolang.ascema.managerdomain.datapoint.Match;
import com.geolang.ascema.managerdomain.domain.BaseMatchStored;
import com.geolang.ascema.managerdomain.domain.MatchStored;
import com.geolang.ascema.managerdomain.domain.SavedCompoundPattern;
import com.geolang.ascema.managerdomain.domain.SavedPattern;
import com.geolang.ascema.managerdomain.domain.SavedSimilarFile;
import com.geolang.ascema.managerdomain.web.TestRegexResponse;
import com.geolang.ascema.managerdomain.web.importexport.PatternExport;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerpersistence.ContextWordStore;
import com.geolang.ascema.managerservice.controllers.patterns.Pattern;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.persist.savedpatterns.CompoundPatternCache;
import com.geolang.ascema.managerservice.persist.savedpatterns.PatternStore;
import com.geolang.ascema.managerservice.rest.PatternsRestService;
import com.geolang.ascema.managerservice.rest.requests.pattern.WebPattern;
import com.geolang.ascema.parsers.ParserFactory;
import com.geolang.ascema.parsers.ParserSimple;
import com.geolang.ascema.patternmatching.Matcher;
import com.geolang.ascema.patternmatching.PatternFactory;
import com.geolang.ascema.patternmatching.internal.IPatternCheck;
import com.geolang.ascema.patternmatching.internal.PatternCheckCollection;
import com.geolang.ascema.patternmatching.internal.operator.AndOperator;
import com.geolang.ascema.patternmatching.internal.operator.NandOperator;
import com.geolang.ascema.patternmatching.internal.operator.NearOperator;
import com.geolang.ascema.patternmatching.internal.operator.NotOperator;
import com.geolang.ascema.patternmatching.internal.operator.OperatorFactory;
import com.geolang.ascema.patternmatching.internal.operator.OrOperator;
import com.geolang.ascema.patternmatching.internal.operator.PatternOperator;
import com.geolang.ascema.patternmatching.patterns.KeywordList;
import com.geolang.ascema.patternmatching.patterns.KeywordListCsvHelper;
import com.geolang.ascema.patternmatching.patterns.MIPLabelPattern;
import com.geolang.ascema.patternmatching.patterns.MetadataPattern;
import com.geolang.ascema.patternmatching.patterns.RegexPattern;
import com.geolang.ascema.patternmatching.patterns.RegexPatternInvalidException;
import com.geolang.ascema.patternmatching.patterns.Tags;
import com.geolang.ascema.patternmatching.patterns.TruePattern;
import com.geolang.ascema.patternmatching.patterns.similar.SimilarHashCreator;
import com.geolang.ascema.patternmatching.patterns.similar.SimilarPattern;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PatternService {
    @Autowired
    private PatternStore savedPatternStore;
    @Autowired
    private ContextWordStore contextWordsStore;
    @Autowired
    private ClassificationLabelStore classificationLabelsStore;
    private CompoundPatternCache compoundPatternStore;
    private static final Logger LOG = Logger.getLogger(PatternService.class.getName());

    @PostConstruct
    public void posty() throws Exception {
        this.initpriv();
    }

    private void initpriv() {
        this.compoundPatternStore = new CompoundPatternCache(this.savedPatternStore);
        this.compoundPatternStore.init();
    }

    public synchronized List<WebPattern> getAllAvailablePatterns() {
        ArrayList<WebPattern> allAvailablePatterns = new ArrayList<WebPattern>();
        for (IDisplayPattern bp : PatternFactory.getAllAvailablePatterns()) {
            Pattern p = new Pattern(bp);
            allAvailablePatterns.add(new WebPattern(p, this));
        }
        return allAvailablePatterns;
    }

    public List<WebPattern> getAllAvailablePatternsForCompound() {
        List ret = this.getAllAvailablePatterns();
        Optional opt = PatternFactory.getBuiltInPattern((String)BuiltInPatternNames.ICD_9_CM.toString(), (PatternContextWords)PatternContextWords.empty());
        if (opt.isPresent()) {
            ret.add(new WebPattern(new Pattern((IDisplayPattern)opt.get()), this));
        }
        if ((opt = PatternFactory.getBuiltInPattern((String)BuiltInPatternNames.ICD_10_CM.toString(), (PatternContextWords)PatternContextWords.empty())).isPresent()) {
            ret.add(new WebPattern(new Pattern((IDisplayPattern)opt.get()), this));
        }
        if ((opt = PatternFactory.getBuiltInPattern((String)BuiltInPatternNames.ICD_11.toString(), (PatternContextWords)PatternContextWords.empty())).isPresent()) {
            ret.add(new WebPattern(new Pattern((IDisplayPattern)opt.get()), this));
        }
        return ret;
    }

    public Optional<WebPattern> getWebpatternFromConfig(PatternConfig config) {
        Optional optPat = PatternFactory.deserialisePattern((String)config.getName(), (PatternContextWords)config.getContextWords());
        if (!optPat.isPresent()) {
            return Optional.empty();
        }
        Pattern p = new Pattern((IDisplayPattern)optPat.get());
        p.setMinConfidence(config.getConfidence());
        p.setMinMatches(config.getMinMatches());
        WebPattern wp = new WebPattern(p, this);
        wp.setDisplayName(config.getPatternDisplayName());
        Optional opt = this.compoundPatternStore.findByDescription(p.getDisplayName());
        if (opt.isPresent()) {
            SavedCompoundPattern scp = (SavedCompoundPattern)opt.get();
            wp.setDescription(scp.getDescription());
            wp.setDisplayName(scp.getName());
        }
        return Optional.of(wp);
    }

    public WebPattern createKeywordPattern(String val) {
        return new WebPattern(new Pattern(PatternFactory.createKeywordPattern((String)val)), this);
    }

    public WebPattern createKeywordPattern(String val, String name, String user) {
        WebPattern wp = new WebPattern(new Pattern(PatternFactory.createKeywordPatternWithName((String)name, (String)val)), !name.isEmpty(), this);
        if (!name.isEmpty()) {
            this.savedPatternStore.addOrUpdateKeyword(name, val, user);
        }
        return wp;
    }

    public Optional<WebPattern> createFilenamePattern(String val) {
        Optional opt = PatternFactory.createFilenamePattern((String)val);
        if (!opt.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new WebPattern(new Pattern((IDisplayPattern)opt.get()), this));
    }

    public Optional<WebPattern> createFilenamePattern(String glob, String name, String user) {
        Optional opt = PatternFactory.createFilenamePatternWithName((String)glob, (String)name);
        if (!opt.isPresent()) {
            return Optional.empty();
        }
        boolean save = !name.isBlank();
        WebPattern wp = new WebPattern(new Pattern((IDisplayPattern)opt.get()), save, this);
        if (save) {
            this.savedPatternStore.addOrUpdateFilenamePattern(name, glob, user);
        }
        return Optional.of(wp);
    }

    public Optional<WebPattern> createMetadataPattern(String key, String val) {
        IDisplayPattern idp = PatternFactory.createMetadataPattern((String)key, (String)val);
        return Optional.of(new WebPattern(new Pattern(idp), this));
    }

    public Optional<WebPattern> createMetadataePatternWithName(String key, String val, String name, String user) {
        IDisplayPattern idp = PatternFactory.createMetadataPatternWithName((String)name, (String)key, (String)val);
        boolean save = !name.isBlank();
        WebPattern wp = new WebPattern(new Pattern(idp), save, this);
        if (save) {
            this.savedPatternStore.addOrUpdateMetadataPattern(key, val, name, user);
        }
        return Optional.of(wp);
    }

    public Optional<WebPattern> createMipsPattern(String displayName, List<MIPLabel> vals) {
        ArrayList<MIPLabelPattern.MipIdAndLabel> labels = new ArrayList<MIPLabelPattern.MipIdAndLabel>();
        for (MIPLabel lab : vals) {
            MIPLabelPattern.MipIdAndLabel l = new MIPLabelPattern.MipIdAndLabel();
            l.id = lab.getId();
            l.label = lab.getName();
            if (l.id != null && l.label != null) {
                labels.add(l);
                continue;
            }
            LOG.log(Level.WARNING, "not adding label {0} {1}", new Object[]{l.id, l.label});
        }
        IDisplayPattern idp = PatternFactory.createMipsLabelPattern((String)displayName, labels);
        return Optional.of(new WebPattern(new Pattern(idp), this));
    }

    public Optional<WebPattern> createMipsLabelPatternWithName(List<MIPLabel> vals, String displayName, String user, boolean save) {
        ArrayList<MIPLabelPattern.MipIdAndLabel> labels = new ArrayList<MIPLabelPattern.MipIdAndLabel>();
        for (MIPLabel lab : vals) {
            MIPLabelPattern.MipIdAndLabel l = new MIPLabelPattern.MipIdAndLabel();
            l.id = lab.getId();
            l.label = lab.getName();
            labels.add(l);
        }
        IDisplayPattern idp = PatternFactory.createMipsLabelPattern((String)displayName, labels);
        WebPattern wp = new WebPattern(new Pattern(idp), save, this);
        if (save) {
            this.savedPatternStore.addOrUpdateMipLabelPattern(displayName, labels, user);
        }
        return Optional.of(wp);
    }

    public Optional<WebPattern> createKeywordListPattern(String displayName, InputStream is, boolean save, String user) {
        try {
            ParserSimple parser = ParserFactory.buildSimpleParser();
            String parsed = parser.parse(is, displayName);
            List parts = KeywordListCsvHelper.parseCsv((String)parsed);
            if (save) {
                this.savedPatternStore.addOrUpdateKeywordList(displayName, parts, user);
            }
            return Optional.of(new WebPattern(new Pattern((IDisplayPattern)new KeywordList(displayName, parts)), save, this));
        }
        catch (IOException ex) {
            Logger.getLogger(PatternService.class.getName()).log(Level.SEVERE, null, ex);
            return Optional.empty();
        }
    }

    public Optional<WebPattern> createSimilarFilePattern(InputStream is, String filePath, String displayName, boolean save, String user) {
        try {
            ParserSimple parser = ParserFactory.buildSimpleParser();
            String text1 = parser.parse(is, filePath);
            IDisplayPattern ipat = null;
            if (save) {
                if (displayName == null || displayName.isEmpty()) {
                    LOG.warning("display name is null or empty in save similarfile pattern");
                    ipat = PatternFactory.createSimilarFilePatternFromParsedText((String)filePath, (String)text1);
                } else {
                    Optional hash;
                    ipat = PatternFactory.createSimilarFilePatternFromParsedText((String)filePath, (String)text1, (String)displayName);
                    if (ipat != null && (hash = SimilarHashCreator.createHash((String)text1)).isPresent()) {
                        this.savedPatternStore.addOrUpdateSimilarFile(filePath, (String)hash.get(), displayName, user);
                    }
                }
            } else {
                ipat = PatternFactory.createSimilarFilePatternFromParsedText((String)filePath, (String)text1);
            }
            if (ipat == null) {
                return Optional.empty();
            }
            return Optional.of(new WebPattern(new Pattern(ipat), this));
        }
        catch (IOException ex) {
            Logger.getLogger(PatternService.class.getName()).log(Level.SEVERE, null, ex);
            return Optional.empty();
        }
    }

    public WebPattern createRegexPattern(String displayName, String regex, boolean save, String user) throws RegexPatternInvalidException {
        IDisplayPattern pat = RegexPattern.getDisplayPattern((String)displayName, (String)regex);
        if (save) {
            this.savedPatternStore.addOrUpdateRegex(displayName, regex, user);
        }
        return new WebPattern(new Pattern(pat), save, this);
    }

    public TestRegexResponse testRegexPattern(String regex, String testdata) {
        try {
            IDisplayPattern pat = RegexPattern.getDisplayPattern((String)"", (String)regex);
            Optional opt = PatternFactory.deserialisePattern((String)pat.getName(), (PatternContextWords)PatternContextWords.empty());
            if (opt.isPresent()) {
                ArrayList<Match> ret = new ArrayList<Match>();
                List pmr = Matcher.getResult((String)"", (String)"", (String)testdata, (PatternCheckCollection)new PatternCheckCollection(Collections.singleton((IPatternCheck)opt.get())));
                for (PatternMatchResult pm : pmr) {
                    ret.add(new Match((BaseMatchStored)new MatchStored((IPatternMatchResult)pm)));
                }
                return new TestRegexResponse(ret);
            }
        }
        catch (RegexPatternInvalidException ex) {
            LOG.log(Level.INFO, "Regex invalid {0}", ex.getMessage());
            return new TestRegexResponse(ex.getMessage());
        }
        return new TestRegexResponse("unknown error");
    }

    public WebPattern createAndCompoundPattern(String left, String right, String name, boolean save, String user) throws CompoundPatternExistsException, CompoundPatternInvalidException {
        AndOperator op = new AndOperator();
        return this.createCompound(left, right, (PatternOperator)op, name, save, user);
    }

    public WebPattern createNandCompoundPattern(String left, String right, String name, boolean save, String user) throws CompoundPatternExistsException, CompoundPatternInvalidException {
        NandOperator op = new NandOperator();
        return this.createCompound(left, right, (PatternOperator)op, name, save, user);
    }

    public WebPattern createNearCompoundPattern(String left, String right, int distance, String name, boolean save, String user) throws CompoundPatternExistsException, CompoundPatternInvalidException {
        NearOperator op = new NearOperator(distance);
        return this.createCompound(left, right, (PatternOperator)op, name, save, user);
    }

    public WebPattern createOrCompoundPattern(String left, String right, String name, boolean save, String user) throws CompoundPatternExistsException, CompoundPatternInvalidException {
        OrOperator op = new OrOperator();
        return this.createCompound(left, right, (PatternOperator)op, name, save, user);
    }

    public WebPattern createNotCompoundPattern(String right, String name, boolean save, String user) throws CompoundPatternExistsException, CompoundPatternInvalidException {
        NotOperator op = new NotOperator();
        return this.createCompound(new TruePattern().getName(), right, (PatternOperator)op, name, save, user);
    }

    private WebPattern createCompound(String left, String right, PatternOperator op, String name, boolean save, String user) throws CompoundPatternInvalidException, CompoundPatternExistsException {
        Optional leftp = PatternFactory.deserialisePattern((String)left, (PatternContextWords)PatternContextWords.empty());
        Optional rightp = PatternFactory.deserialisePattern((String)right, (PatternContextWords)PatternContextWords.empty());
        if (!leftp.isPresent() || !rightp.isPresent()) {
            throw new CompoundPatternInvalidException();
        }
        Pattern pat = new Pattern((IDisplayPattern)PatternFactory.createDisplayCompoundPattern((IDisplayPattern)((IDisplayPattern)leftp.get()), (IDisplayPattern)((IDisplayPattern)rightp.get()), (PatternOperator)op, (PatternContextWords)PatternContextWords.empty()).get());
        WebPattern ret = new WebPattern(pat, this);
        if (name != null && !name.isEmpty()) {
            ret.setDescription(ret.getDisplayName());
            ret.setDisplayName(name);
        }
        if (save) {
            ret.setIsSaved(true);
            Optional existing = this.compoundPatternStore.findByName(name);
            if (existing.isPresent()) {
                throw new CompoundPatternExistsException();
            }
            SavedCompoundPattern scp = new SavedCompoundPattern(((IPatternCheck)leftp.get()).getName(), ((IPatternCheck)rightp.get()).getName(), op.toString(), name, ret.getDescription());
            this.compoundPatternStore.addOrUpdate(scp, user);
            LOG.log(Level.INFO, "saved pattern {0}", scp.getName());
        }
        return ret;
    }

    public List<WebPattern> getAllSavedPatterns() {
        ArrayList<WebPattern> ret = new ArrayList<WebPattern>();
        ArrayList<SavedPattern> todelete = new ArrayList<SavedPattern>();
        for (SavedPattern sp : this.savedPatternStore.getAll()) {
            Optional opt = this.savedPatternToWebPattern(sp);
            if (opt.isPresent()) {
                ret.add((WebPattern)opt.get());
                continue;
            }
            todelete.add(sp);
        }
        if (!todelete.isEmpty()) {
            for (SavedPattern s : todelete) {
                LOG.log(Level.WARNING, "Deleting saved pattern {0} we can''t deserialize", s.getSavedName());
                this.savedPatternStore.deletePatternByName(s.getSavedName(), "server delete");
            }
        }
        return ret;
    }

    public List<PatternMatchResult> expandPatternMatches(List<MatchStored> res) {
        ArrayList<PatternMatchResult> ret = new ArrayList<PatternMatchResult>();
        for (IPatternMatchResult iPatternMatchResult : res) {
            Optional opt;
            String name = iPatternMatchResult.getName();
            if (name.startsWith(BuiltInPatternNames.LISTKEYWORD.toString()) && (opt = this.savedPatternStore.getKeywordListsByName(iPatternMatchResult.getDisplayName())).isPresent()) {
                KeywordList kw = new KeywordList(iPatternMatchResult.getDisplayName(), (List)opt.get());
                name = kw.getName();
            }
            PatternMatchResult pmr = new PatternMatchResult(name, iPatternMatchResult.getDisplayName(), iPatternMatchResult.getLocation(), iPatternMatchResult.getMatchingText(), iPatternMatchResult.getConfidenceOrdinal(), iPatternMatchResult.getStatus(), iPatternMatchResult.getResultStatusReason(), iPatternMatchResult.getCustomStatusReason());
            pmr.setMatchingTextDigest(iPatternMatchResult.getMatchingTextDigest());
            ret.add(pmr);
        }
        return ret;
    }

    private Optional<WebPattern> savedPatternToWebPattern(SavedPattern sp) {
        switch (1.$SwitchMap$com$geolang$ascema$domainmodelpublic$pattern$SpecialPatternType[sp.getType().ordinal()]) {
            case 1: {
                String kw = this.savedPatternStore.keywordFromSavedPattern(sp);
                Pattern pat = new Pattern(PatternFactory.createKeywordPatternWithName((String)sp.getSavedName(), (String)kw));
                WebPattern wp = new WebPattern(pat, true, this);
                return Optional.of(wp);
            }
            case 2: {
                SavedCompoundPattern s = this.savedPatternStore.savedCompoundPatternFromSavedPattern(sp);
                Optional opOpt = OperatorFactory.fromString((String)s.getOperator());
                if (!opOpt.isPresent()) {
                    LOG.log(Level.WARNING, "Failed to deserialise operator {0}", s.getOperator());
                    return Optional.empty();
                }
                Optional leftp = PatternFactory.deserialisePattern((String)s.getLhs(), (PatternContextWords)PatternContextWords.empty());
                Optional rightp = PatternFactory.deserialisePattern((String)s.getRhs(), (PatternContextWords)PatternContextWords.empty());
                if (!leftp.isPresent()) {
                    LOG.log(Level.WARNING, "Failed to deserialise pattern {0}", s.getLhs());
                    return Optional.empty();
                }
                if (!rightp.isPresent()) {
                    LOG.log(Level.WARNING, "Failed to deserialise pattern {0}", s.getRhs());
                    return Optional.empty();
                }
                Pattern pat = new Pattern((IDisplayPattern)PatternFactory.createDisplayCompoundPatternWithSavedName((String)s.getName(), (String)s.getDescription(), (IDisplayPattern)((IDisplayPattern)leftp.get()), (IDisplayPattern)((IDisplayPattern)rightp.get()), (PatternOperator)((PatternOperator)opOpt.get()), (PatternContextWords)PatternContextWords.empty()).get());
                WebPattern wp = new WebPattern(pat, true, this);
                return Optional.of(wp);
            }
            case 3: {
                Optional pat = PatternFactory.createRegexPattern((String)sp.getSavedName(), (String)this.savedPatternStore.regexFromSavedPattern(sp));
                if (!pat.isPresent()) break;
                WebPattern wp = new WebPattern(new Pattern((IDisplayPattern)pat.get()), true, this);
                return Optional.of(wp);
            }
            case 4: {
                MetadataPattern pat = this.savedPatternStore.metadataFromSavedPattern(sp);
                pat.setDisplayName(sp.getSavedName());
                WebPattern wp = new WebPattern(new Pattern((IDisplayPattern)pat), true, this);
                return Optional.of(wp);
            }
            case 5: {
                MIPLabelPattern pat = this.savedPatternStore.mipLabelFromSavedPattern(sp);
                WebPattern wp = new WebPattern(new Pattern((IDisplayPattern)pat), true, this);
                return Optional.of(wp);
            }
            case 6: {
                Optional pat = PatternFactory.createFilenamePatternWithName((String)this.savedPatternStore.filenamePatternFromSavedPattern(sp), (String)sp.getSavedName());
                if (!pat.isPresent()) break;
                WebPattern wp = new WebPattern(new Pattern((IDisplayPattern)pat.get()), true, this);
                return Optional.of(wp);
            }
            case 7: {
                List words = this.savedPatternStore.keywordListFromSavedPattern(sp);
                WebPattern wp = new WebPattern(new Pattern((IDisplayPattern)new KeywordList(sp.getSavedName(), words)), true, this);
                return Optional.of(wp);
            }
            case 8: {
                SavedSimilarFile f = this.savedPatternStore.similarFileFromSavedPattern(sp);
                WebPattern wp = new WebPattern(new Pattern((IDisplayPattern)new SimilarPattern(f.getFilename(), f.getHash(), f.getName())), true, this);
                return Optional.of(wp);
            }
        }
        return Optional.empty();
    }

    public boolean savedPatternNameExists(String name) {
        return this.savedPatternStore.patternExistsByName(name);
    }

    public boolean deletePattern(String name, String user) {
        this.savedPatternStore.deletePatternByName(name, user);
        return true;
    }

    public List<PatternExport> getAllForExport() {
        ArrayList<PatternExport> ret = new ArrayList<PatternExport>();
        block3: for (SavedPattern sp : this.savedPatternStore.getAll()) {
            switch (1.$SwitchMap$com$geolang$ascema$domainmodelpublic$pattern$SpecialPatternType[sp.getType().ordinal()]) {
                case 2: {
                    SavedCompoundPattern s = this.savedPatternStore.savedCompoundPatternFromSavedPattern(sp);
                    PatternExport ep = new PatternExport(sp.getSavedName(), s.getDescription(), sp.getType(), s.getLhs(), s.getRhs(), s.getOperator());
                    ret.add(ep);
                    continue block3;
                }
            }
            PatternExport eps = new PatternExport(sp.getSavedName(), sp.getType(), sp.getPatternBlob());
            ret.add(eps);
        }
        return ret;
    }

    public boolean importPattern(SavedCompoundPattern scp, String user) {
        this.compoundPatternStore.addOrUpdate(scp, user);
        return true;
    }

    public boolean importPattern(SavedPattern sp, String user) {
        this.savedPatternStore.save(sp, user);
        return true;
    }

    public void revertContextWords(String patternDisplayName) {
        this.contextWordsStore.revertToDefault(patternDisplayName);
    }

    public void setContextWords(String patternDisplayName, Set<String> words) {
        this.contextWordsStore.setForPattern(patternDisplayName, words);
    }

    public Set<String> getContextWords(String patternDisplayName) {
        return this.contextWordsStore.getForPattern(patternDisplayName);
    }

    public boolean hasSavedContextWords(String patternDisplayName) {
        return this.contextWordsStore.hasForPattern(patternDisplayName);
    }

    public Set<String> revertClassificationLabels(String patternDisplayName, String patternSerialisedName) {
        return this.classificationLabelsStore.revertToDefault(patternDisplayName, patternSerialisedName);
    }

    public void setClassificationLabels(String patternDisplayName, Set<String> words) {
        this.classificationLabelsStore.setForPattern(patternDisplayName, words);
    }

    public Set<String> getClassificationLabels(String patternDisplayName) {
        return this.classificationLabelsStore.getForPattern(patternDisplayName);
    }

    public boolean hasSavedClassificationLabels(String patternDisplayName) {
        return this.classificationLabelsStore.hasForPattern(patternDisplayName);
    }

    public List<String> getTags() {
        Field[] fields;
        HashSet<String> ret = new HashSet<String>();
        Tags tags = new Tags();
        Class<?> tagclass = tags.getClass();
        for (Field f : fields = tagclass.getFields()) {
            try {
                String s;
                Object obj = f.get(tags);
                if (!(obj instanceof String) || (s = (String)obj).equals("None")) continue;
                ret.add(s);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(PatternsRestService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Set words = this.classificationLabelsStore.getAdditionalLabels();
        ret.addAll(words);
        ArrayList<String> sorted = new ArrayList<String>(ret);
        Collections.sort(sorted);
        return sorted;
    }
}

