/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.patterns;

import com.geolang.ascema.domainmodelpublic.pattern.IDisplayPattern;
import com.geolang.ascema.managerservice.controllers.patterns.Pattern;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.rest.requests.pattern.PatternGroup;
import com.geolang.ascema.managerservice.rest.requests.pattern.WebPattern;
import com.geolang.ascema.patternmatching.PatternFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
public class PatternGroups {
    public static List<PatternGroup> getAvailable(PatternService service) {
        Optional pci;
        ArrayList<PatternGroup> ret = new ArrayList<PatternGroup>();
        Optional gdpr = PatternGroups.getGDPR((PatternService)service);
        if (gdpr.isPresent()) {
            ret.add((PatternGroup)gdpr.get());
        }
        if ((pci = PatternGroups.getPCI((PatternService)service)).isPresent()) {
            ret.add((PatternGroup)pci.get());
        }
        return ret;
    }

    private static Optional<PatternGroup> getGDPR(PatternService service) {
        ArrayList<WebPattern> patterns = new ArrayList<WebPattern>();
        for (IDisplayPattern pat : PatternFactory.getAllAvailablePatterns()) {
            if (!pat.getTags().contains("GDPR")) continue;
            patterns.add(new WebPattern(new Pattern(pat), service));
        }
        return Optional.of(new PatternGroup("GDPR", "General Data Protection Regulation ", patterns));
    }

    private static Optional<PatternGroup> getPCI(PatternService service) {
        ArrayList<WebPattern> patterns = new ArrayList<WebPattern>();
        for (IDisplayPattern pat : PatternFactory.getAllAvailablePatterns()) {
            if (!pat.getTags().contains("PCI")) continue;
            patterns.add(new WebPattern(new Pattern(pat), service));
        }
        return Optional.of(new PatternGroup("PCI", "PCI Data Security Standard", patterns));
    }
}

