/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.patterns;

import com.geolang.ascema.domainmodelpublic.Confidence;
import com.geolang.ascema.domainmodelpublic.pattern.IDisplayPattern;
import com.geolang.ascema.domainmodelpublic.pattern.SpecialPatternGroupNames;
import com.geolang.ascema.domainmodelpublic.pattern.SpecialPatternType;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class Pattern
implements IDisplayPattern {
    private static final long serialVersionUID = 42L;
    private Confidence minConfidence;
    private int minMatches;
    public static String GLOBAL_PATTERN_GROUP_NAME = "Global";
    public static String CRYPTO_PATTERN_GROUP_NAME = "Crypto Currency";
    public static String CUSTOM_PATTERN_GROUP_NAME = "Custom";
    public static String CREDENTIALS_PATTERN_GROUP_NAME = "Credentials";
    public static String GTIN_PATTERN_GROUP_NAME = "Global Trade Numbers";
    public static String ICD_PATTERN_GROUP_NAME = "ICD Codes";
    private final String name;
    protected String displayName;
    protected String desc;
    private final String countryCode;
    private final Set<String> tags;
    private final Set<String> defaultContextWords;
    private final SpecialPatternType specialType;
    private final Confidence defaultConfidenceLevel;

    public Pattern(IDisplayPattern pat) {
        this.minConfidence = pat.getDefaultConfidenceLevel();
        this.minMatches = 1;
        this.defaultContextWords = pat.getDefaultContextWords();
        this.name = pat.getName();
        this.displayName = pat.getDisplayName();
        this.desc = pat.getDescription();
        this.countryCode = pat.getCountryCode();
        this.tags = pat.getTags();
        this.specialType = pat.getSpecialPatternType();
        this.defaultConfidenceLevel = pat.getDefaultConfidenceLevel();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public SpecialPatternType getSpecialPatternType() {
        return this.specialType;
    }

    public String getCountryName() {
        if (this.countryCode.equals(SpecialPatternGroupNames.GLOBAL)) {
            return GLOBAL_PATTERN_GROUP_NAME;
        }
        if (this.countryCode.equals(SpecialPatternGroupNames.CUSTOM)) {
            return CUSTOM_PATTERN_GROUP_NAME;
        }
        if (this.countryCode.equals(SpecialPatternGroupNames.CRYPTO)) {
            return CRYPTO_PATTERN_GROUP_NAME;
        }
        if (this.countryCode.equals(SpecialPatternGroupNames.CREDENTIALS)) {
            return CREDENTIALS_PATTERN_GROUP_NAME;
        }
        if (this.countryCode.equals(SpecialPatternGroupNames.GTIN)) {
            return GTIN_PATTERN_GROUP_NAME;
        }
        if (this.countryCode.equals(SpecialPatternGroupNames.ICD)) {
            return ICD_PATTERN_GROUP_NAME;
        }
        Locale loc = Locale.of("", this.countryCode);
        return loc.getDisplayCountry();
    }

    public Set<String> getDefaultContextWords() {
        return this.defaultContextWords;
    }

    public Confidence getDefaultConfidenceLevel() {
        return this.defaultConfidenceLevel;
    }

    public Confidence getMinConfidence() {
        return this.minConfidence;
    }

    public void setMinConfidence(Confidence minConfidence) {
        this.minConfidence = minConfidence;
    }

    public int getMinMatches() {
        return this.minMatches;
    }

    public void setMinMatches(int minMatches) {
        this.minMatches = minMatches;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.name);
        hash = 67 * hash + Objects.hashCode(this.displayName);
        hash = 67 * hash + Objects.hashCode(this.desc);
        hash = 67 * hash + Objects.hashCode(this.countryCode);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pattern other = (Pattern)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.displayName, other.displayName)) {
            return false;
        }
        if (!Objects.equals(this.desc, other.desc)) {
            return false;
        }
        if (!Objects.equals(this.countryCode, other.countryCode)) {
            return false;
        }
        return this.specialType == other.specialType;
    }
}

