/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.jettyssl;

import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerservice.controllers.jettyssl.CertFileMonitor;
import com.google.common.io.Closer;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.springframework.boot.web.server.Ssl;
import org.springframework.stereotype.Controller;

@Controller
public class JettySSL {
    private static final Logger LOG = Logger.getLogger(JettySSL.class.getName());
    private static final String STORENAME = "uikeystore.jks";
    private CertFileMonitor monitor;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.monitor = new CertFileMonitor(this);
    }

    public final Optional<Ssl> getSsl() {
        SettingsFile settings = SettingsFile.getInstance();
        if (!settings.getUISSL()) {
            LOG.info("UI SSL not configured");
            return Optional.empty();
        }
        this.monitor.checkForNewer();
        String keystorePath = this.getKeyfilePath();
        String keystorePwd = settings.getUISSLKeyStorePwd();
        String keyPwd = settings.getUISSLKeyPwd();
        String keyAlias = settings.getUISSLKeyStoreAlias();
        File keystoreFile = new File(keystorePath);
        if (!keystoreFile.exists()) {
            LOG.log(Level.WARNING, "UI SSL is configured, but no file {0}.  Reverting to http", keystorePath);
            settings.setUISSL(false);
            return Optional.empty();
        }
        Ssl ssl = new Ssl();
        ssl.setEnabled(true);
        ssl.setKeyStore(keystorePath);
        ssl.setKeyStorePassword(keystorePwd);
        ssl.setKeyStoreType("JKS");
        ssl.setKeyAlias(keyAlias);
        ssl.setKeyPassword(keyPwd);
        return Optional.of(ssl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromCertsPath(String pathTokeyFile, Optional<String> pathToCertsFile, Optional<String> pathToCertsFile2, int port) {
        Closer closer = Closer.create();
        try {
            boolean ret;
            File filecert;
            Path pathcert;
            Optional<Object> certStr = Optional.empty();
            Optional<Object> certStr2 = Optional.empty();
            Path pathkey = Paths.get(pathTokeyFile, new String[0]);
            File filekey = pathkey.toFile();
            if (!filekey.exists()) {
                LOG.log(Level.WARNING, "No key file found at {0}", pathTokeyFile);
                boolean bl = false;
                return bl;
            }
            FileInputStream keyStr = (FileInputStream)closer.register((Closeable)new FileInputStream(filekey));
            if (pathToCertsFile.isPresent()) {
                pathcert = Paths.get(pathToCertsFile.get(), new String[0]);
                filecert = pathcert.toFile();
                if (!filecert.exists()) {
                    LOG.log(Level.WARNING, "No certificate file found at {0}", pathToCertsFile.get());
                    boolean bl = false;
                    return bl;
                }
                certStr = Optional.of((InputStream)closer.register((Closeable)new FileInputStream(filecert)));
            }
            if (pathToCertsFile2.isPresent()) {
                pathcert = Paths.get(pathToCertsFile2.get(), new String[0]);
                filecert = pathcert.toFile();
                if (!filecert.exists()) {
                    LOG.log(Level.WARNING, "No certificate file found at {0}", pathToCertsFile2.get());
                    boolean bl = false;
                    return bl;
                }
                certStr2 = Optional.of((InputStream)closer.register((Closeable)new FileInputStream(filecert)));
            }
            if (ret = this.fromCerts((InputStream)keyStr, certStr, certStr2, port)) {
                this.monitor.setCertFilesToMonitor(pathTokeyFile, pathToCertsFile, pathToCertsFile2);
            }
            boolean bl = ret;
            return bl;
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(JettySSL.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException ex) {
                Logger.getLogger(JettySSL.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean fromCerts(InputStream keyStr, Optional<InputStream> certStr, Optional<InputStream> certStr2, int port) {
        LOG.log(Level.INFO, "configure from private key and trust chain");
        if (keyStr != null) {
            try {
                String alias = "alias";
                String keystorepwd = UUID.randomUUID().toString();
                String keyPwd = UUID.randomUUID().toString();
                Optional opt = this.createFromCertAndPem(certStr, certStr2, keyStr, keyPwd, alias);
                if (opt.isPresent()) {
                    SettingsFile settings = SettingsFile.getInstance();
                    settings.setUISSLKeyStorePwd(keystorepwd);
                    settings.setUISSLPort(port);
                    settings.setUISSL(true);
                    this.monitor.clearAll();
                    return this.saveKeyStore((KeyStore)opt.get(), keystorepwd);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(JettySSL.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean fromKeyStorePath(String keystorePath, String keystorePwd, String keyPwd, String alias, int port) {
        boolean bl;
        Path path = Paths.get(keystorePath, new String[0]);
        File file = path.toFile();
        if (!file.exists()) {
            LOG.log(Level.WARNING, "No keystore file found at {0}", keystorePath);
            return false;
        }
        FileInputStream instr = new FileInputStream(keystorePath);
        try {
            boolean ret = this.fromKeyStore(IOUtils.toByteArray((InputStream)instr), keystorePath, keystorePwd, keyPwd, alias, port);
            if (ret) {
                this.monitor.setKeyStoreToMonitor(keystorePath);
            }
            bl = ret;
        }
        catch (Throwable throwable) {
            try {
                try {
                    instr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                Logger.getLogger(JettySSL.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        instr.close();
        return bl;
    }

    public boolean fromKeyStore(byte[] keystoreStr, String filename, String keystorePwd, String keyPwd, String alias, int port) {
        if (keystoreStr == null) {
            LOG.log(Level.WARNING, "no keystore sent");
            return false;
        }
        try {
            KeyStore ret = KeyStore.getInstance("jks");
            try (ByteArrayInputStream str = new ByteArrayInputStream(keystoreStr);){
                ret.load(str, keystorePwd.toCharArray());
            }
            Key key = ret.getKey(alias, keyPwd.toCharArray());
            if (key == null) {
                LOG.log(Level.INFO, "Unable to extract key with given alias {0}", alias);
                return false;
            }
            this.saveKeyStore(ret, keystorePwd);
            SettingsFile settings = SettingsFile.getInstance();
            settings.setUISSLKeyPwd(keyPwd);
            settings.setUISSLKeyStorePwd(keystorePwd);
            settings.setUISSLKeyStoreAlias(alias);
            settings.setUISSLPort(port);
            settings.setUISSL(true);
            LOG.log(Level.INFO, "configured from keyfile {0}", filename);
            this.monitor.clearAll();
            return true;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            Logger.getLogger(JettySSL.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Optional<KeyStore> createFromCertAndPem(Optional<InputStream> fullchainPemStream, Optional<InputStream> fullchainPemStream2, InputStream privKeyStream, String keyPassword, String alias) throws Exception {
        SettingsFile settings = SettingsFile.getInstance();
        PrivateKey key = null;
        LinkedList<X509Certificate> allCerts = new LinkedList<X509Certificate>();
        try (InputStreamReader reader = new InputStreamReader(privKeyStream);
             PEMParser pem = new PEMParser((Reader)reader);){
            Object parsedObject = pem.readObject();
            while (parsedObject != null) {
                if (parsedObject instanceof X509CertificateHolder) {
                    X509CertificateHolder certHolder = (X509CertificateHolder)parsedObject;
                    X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
                    allCerts.add(x509Certificate);
                } else {
                    PrivateKeyInfo privateKeyInfo;
                    PrivateKeyInfo privateKeyInfo2 = privateKeyInfo = parsedObject instanceof PEMKeyPair ? ((PEMKeyPair)parsedObject).getPrivateKeyInfo() : (PrivateKeyInfo)parsedObject;
                    if (privateKeyInfo == null) {
                        LOG.warning("Failed to load PrivateKeyInfo from file");
                        Optional<KeyStore> optional = Optional.empty();
                        return optional;
                    }
                    PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
                    KeyFactory factory = KeyFactory.getInstance("RSA");
                    key = factory.generatePrivate(pKCS8EncodedKeySpec);
                }
                parsedObject = pem.readObject();
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception loading private keyfile {0}", e.getMessage());
            return Optional.empty();
        }
        if (fullchainPemStream.isPresent()) {
            allCerts.addAll(this.extractX509(fullchainPemStream.get()));
        }
        if (fullchainPemStream2.isPresent()) {
            allCerts.addAll(this.extractX509(fullchainPemStream2.get()));
        }
        if (key == null) {
            LOG.warning("Failed to parse private key");
            return Optional.empty();
        }
        int size = allCerts.size();
        int i = 0;
        Certificate[] chain = new Certificate[size];
        KeyStore ret = KeyStore.getInstance("jks");
        ret.load(null);
        Iterator iterator = allCerts.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                ret.setKeyEntry(alias, key, keyPassword.toCharArray(), chain);
                settings.setUISSLKeyPwd(keyPassword);
                settings.setUISSLKeyStoreAlias(alias);
                return Optional.of(ret);
            }
            Certificate certificate = (Certificate)iterator.next();
            ret.setCertificateEntry("chain" + i, certificate);
            chain[i] = ret.getCertificate("chain" + i);
            ++i;
        }
    }

    private List<Certificate> extractX509(InputStream inStr) {
        byte[] bytes;
        try {
            bytes = IOUtils.toByteArray((InputStream)inStr);
        }
        catch (IOException ex) {
            Logger.getLogger(JettySSL.class.getName()).log(Level.SEVERE, null, ex);
            return Collections.emptyList();
        }
        LinkedList<Certificate> allCerts = new LinkedList<Certificate>();
        boolean isPem = false;
        try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(bytes));
             PEMParser pem = new PEMParser((Reader)reader);){
            Object parsedObject = pem.readObject();
            if (parsedObject != null) {
                isPem = true;
                do {
                    if (!(parsedObject instanceof X509CertificateHolder)) continue;
                    X509CertificateHolder certHolder = (X509CertificateHolder)parsedObject;
                    X509Certificate X509Certificate2 = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
                    allCerts.add(X509Certificate2);
                } while ((parsedObject = pem.readObject()) != null);
            }
        }
        catch (IOException | CertificateException ex) {
            Logger.getLogger(JettySSL.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!isPem) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                while (is.available() > 0) {
                    Certificate cert = cf.generateCertificate(is);
                    allCerts.add(cert);
                }
            }
            catch (IOException | CertificateException ex) {
                Logger.getLogger(JettySSL.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return allCerts;
    }

    private boolean saveKeyStore(KeyStore store, String keyStorePassword) {
        block8: {
            boolean bl;
            String keystorePath = this.getKeyfilePath();
            File outFile = new File(keystorePath);
            FileOutputStream out = new FileOutputStream(outFile, false);
            try {
                store.store(out, keyStorePassword.toCharArray());
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                    Logger.getLogger(JettySSL.class.getName()).log(Level.SEVERE, null, ex);
                    break block8;
                }
                catch (IOException ex) {
                    Logger.getLogger(JettySSL.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            out.close();
            return bl;
        }
        return false;
    }

    void dumpKeyStore(KeyStore keyStore) {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                boolean a = keyStore.isKeyEntry(alias);
                boolean b = keyStore.isCertificateEntry(alias);
                LOG.log(Level.INFO, "{0} {1} {2}", new Object[]{alias, a, b});
            }
        }
        catch (KeyStoreException e) {
            LOG.severe(e.getLocalizedMessage());
        }
    }

    private String getKeyfilePath() {
        return WorkingFolder.getWorkingFolder() + File.separator + STORENAME;
    }
}

