/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.jettyssl;

import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerservice.controllers.jettyssl.JettySSL;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class CertFileMonitor {
    private static final Logger LOG = Logger.getLogger(CertFileMonitor.class.getName());
    private static final int WATCHING_NONE = 0;
    private static final int WATCHING_KEYSTORE = 1;
    private static final int WATCHING_CERTS = 2;
    private final JettySSL ssl;
    private final String propertiesFilePath;
    private Properties props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertFileMonitor(JettySSL ssl) {
        this.ssl = ssl;
        String workingFolder = WorkingFolder.getWorkingFolder();
        this.propertiesFilePath = workingFolder + File.separator + "certspaths.txt";
        this.props = new Properties();
        InputStream fis = null;
        try {
            File f = new File(this.propertiesFilePath);
            f.createNewFile();
            fis = Files.newInputStream(f.toPath(), new OpenOption[0]);
            this.props.load(fis);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    void setCertFilesToMonitor(String pathTokeyFile, Optional<String> pathToCertsFile, Optional<String> pathToCertsFile2) {
        long lastModifiedcf;
        this.clearAll();
        this.setWatching(2);
        File keyFile = new File(pathTokeyFile);
        long lastModified = keyFile.lastModified();
        this.setCertKey(pathTokeyFile);
        this.setCertKeyLM(lastModified);
        if (pathToCertsFile.isPresent()) {
            File certFile = new File(pathToCertsFile.get());
            lastModifiedcf = certFile.lastModified();
            this.setCert1(pathToCertsFile.get());
            this.setCert1LM(lastModifiedcf);
        }
        if (pathToCertsFile2.isPresent()) {
            File certFile2 = new File(pathToCertsFile2.get());
            lastModifiedcf = certFile2.lastModified();
            this.setCert2(pathToCertsFile2.get());
            this.setCert2LM(lastModifiedcf);
        }
    }

    void setKeyStoreToMonitor(String keystorePath) {
        this.clearAll();
        this.setWatching(1);
        File keyFile = new File(keystorePath);
        long lastModified = keyFile.lastModified();
        this.setCertKey(keystorePath);
        this.setCertKeyLM(lastModified);
    }

    void checkForNewer() {
        int watching = this.getWatching();
        if (watching == 0) {
            return;
        }
        SettingsFile settings = SettingsFile.getInstance();
        if (watching == 1) {
            String path = this.getKeyStore();
            long lastmodifiedStored = this.getKeyStoreLM();
            File f = new File(path);
            if (!f.exists()) {
                LOG.log(Level.WARNING, "Watching keystore but file is gone {0}", path);
                return;
            }
            long lastmodified = f.lastModified();
            if (lastmodified > lastmodifiedStored) {
                LOG.info("keystore file has been updated, reloading ");
                String keystorePwd = settings.getUISSLKeyStorePwd();
                String keyPwd = settings.getUISSLKeyPwd();
                String keyAlias = settings.getUISSLKeyStoreAlias();
                int port = settings.getUISSLPort();
                this.ssl.fromKeyStorePath(keystorePwd, keystorePwd, keyPwd, keyAlias, port);
                return;
            }
        }
        if (watching == 2) {
            String keyPath = this.getCertKey();
            long lmKeyPatg = this.getCertKeyLM();
            String cert1Path = this.getCert1();
            long lmCert1 = this.getCert1LM();
            String cert2Path = this.getCert2();
            long lmCert2 = this.getCert2LM();
            File f = new File(keyPath);
            if (!f.exists()) {
                LOG.log(Level.WARNING, "Watching key file but file is gone {0}", keyPath);
                return;
            }
            boolean renew = false;
            long lastmodified = f.lastModified();
            if (lastmodified > lmKeyPatg) {
                renew = true;
            } else {
                long lastmodifiedc1;
                File cf;
                if (!cert1Path.isEmpty()) {
                    cf = new File(cert1Path);
                    if (!cf.exists()) {
                        LOG.log(Level.WARNING, "Watching cert file but file is gone {0}", cert1Path);
                        return;
                    }
                    lastmodifiedc1 = cf.lastModified();
                    if (lastmodifiedc1 > lmCert1) {
                        renew = true;
                    }
                }
                if (!cert2Path.isEmpty()) {
                    cf = new File(cert2Path);
                    if (!cf.exists()) {
                        LOG.log(Level.WARNING, "Watching cert file but file is gone {0}", cert2Path);
                        return;
                    }
                    lastmodifiedc1 = cf.lastModified();
                    if (lastmodifiedc1 > lmCert2) {
                        renew = true;
                    }
                }
            }
            if (renew) {
                Optional<Object> cert1Opt = Optional.empty();
                Optional<Object> cert2Opt = Optional.empty();
                if (!cert1Path.isEmpty()) {
                    cert1Opt = Optional.of(cert1Path);
                }
                if (!cert2Path.isEmpty()) {
                    cert2Opt = Optional.of(cert2Path);
                }
                this.ssl.fromCertsPath(keyPath, cert1Opt, cert2Opt, settings.getUISSLPort());
            }
        }
    }

    void clearAll() {
        this.setKeyStore("");
        this.setKeyStoreLM(0L);
        this.setCertKey("");
        this.setCertKeyLM(0L);
        this.setCert1("");
        this.setCert1LM(0L);
        this.setCert2("");
        this.setCert2LM(0L);
        this.setWatching(0);
    }

    public int getWatching() {
        try {
            return Integer.parseInt(this.get("watching"));
        }
        catch (SettingsFile.SettingNotFoundException ex) {
            return 0;
        }
    }

    public void setWatching(int s) {
        this.put("watching", Integer.toString(s));
    }

    private String getKeyStore() {
        try {
            return this.get("keystore");
        }
        catch (SettingsFile.SettingNotFoundException ex) {
            return "";
        }
    }

    private void setKeyStore(String s) {
        this.put("keystore", s);
    }

    private String getCertKey() {
        try {
            return this.get("certkey");
        }
        catch (SettingsFile.SettingNotFoundException ex) {
            return "";
        }
    }

    private void setCertKey(String s) {
        this.put("certkey", s);
    }

    private String getCert1() {
        try {
            return this.get("cert1");
        }
        catch (SettingsFile.SettingNotFoundException ex) {
            return "";
        }
    }

    private void setCert1(String s) {
        this.put("cert1", s);
    }

    private String getCert2() {
        try {
            return this.get("cert2");
        }
        catch (SettingsFile.SettingNotFoundException ex) {
            return "";
        }
    }

    private void setCert2(String s) {
        this.put("cert2", s);
    }

    private long getKeyStoreLM() {
        try {
            return Long.parseLong(this.get("keystorelm"));
        }
        catch (SettingsFile.SettingNotFoundException ex) {
            return 0L;
        }
    }

    private void setKeyStoreLM(long s) {
        this.put("keystorelm", Long.toString(s));
    }

    private long getCertKeyLM() {
        try {
            return Long.parseLong(this.get("certkeylm"));
        }
        catch (SettingsFile.SettingNotFoundException ex) {
            return 0L;
        }
    }

    private void setCertKeyLM(long s) {
        this.put("certkeylm", Long.toString(s));
    }

    private long getCert1LM() {
        try {
            return Long.parseLong(this.get("cert1lm"));
        }
        catch (SettingsFile.SettingNotFoundException ex) {
            return 0L;
        }
    }

    private void setCert1LM(long s) {
        this.put("cert1lm", Long.toString(s));
    }

    private long getCert2LM() {
        try {
            return Long.parseLong(this.get("cert2lm"));
        }
        catch (SettingsFile.SettingNotFoundException ex) {
            return 0L;
        }
    }

    private void setCert2LM(long s) {
        this.put("cert2lm", Long.toString(s));
    }

    private String get(String key) throws SettingsFile.SettingNotFoundException {
        String ret = this.props.getProperty(key);
        if (ret != null) {
            return ret;
        }
        throw new SettingsFile.SettingNotFoundException("no setting for " + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(String key, String value) {
        this.props.put(key, value);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.propertiesFilePath);
            this.props.store(fos, null);
        }
        catch (FileNotFoundException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

