/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.devices;

import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.domain.Notification;
import com.geolang.ascema.managerdomain.domain.NotificationType;
import com.geolang.ascema.managerevents.NotificationEvent;
import com.geolang.ascema.managerevents.SessionChangeEvent;
import com.geolang.ascema.managerservice.controllers.devices.Session;
import com.geolang.ascema.managerservice.controllers.devices.SessionManager;
import com.geolang.ascema.managerservice.license.LicenseManager;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SessionManager
implements DisposableBean {
    private static final Logger LOG = Logger.getLogger(SessionManager.class.getName());
    @Autowired
    private LicenseManager licManager;
    private final ConcurrentMap<String, Session> sessions = new ConcurrentHashMap();
    private final ConcurrentMap<DeviceType, Integer> deviceTypeCounts = new ConcurrentHashMap();
    private final ConcurrentMap<String, Session> disabledSessions = new ConcurrentHashMap();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, r -> {
        Thread t = new Thread(r);
        t.setName("sessmgr");
        t.setDaemon(true);
        return t;
    });

    public SessionManager() {
        this.scheduler.scheduleAtFixedRate(() -> this.trimExpiredSessions(), 20L, 60L, TimeUnit.SECONDS);
    }

    public void destroy() throws Exception {
        this.scheduler.shutdownNow();
    }

    Optional<Session> getSession(String deviceId) {
        if (!this.sessions.containsKey(deviceId)) {
            return Optional.empty();
        }
        return Optional.of((Session)this.sessions.get(deviceId));
    }

    Set<String> getAllDeviceIds() {
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(this.sessions.keySet());
        return ret;
    }

    boolean updateDeviceTypeInSession(String deviceId, DeviceType newType) {
        if (!this.canSetSessionDeviceType(newType)) {
            LOG.log(Level.WARNING, "License does not allow us to change device type to {0}", newType);
            return false;
        }
        Optional sesOpt = this.getSession(deviceId);
        if (sesOpt.isPresent()) {
            Session sess = (Session)sesOpt.get();
            DeviceType oldType = sess.getType();
            sess.setType(newType);
            this.decrementDeviceTypes(oldType);
            this.incrementDeviceTypes(newType);
            return true;
        }
        LOG.log(Level.WARNING, "No session for device {0} can't update device type", deviceId);
        return false;
    }

    boolean canEnable(String deviceId, DeviceType type, boolean validated) {
        Optional sesOpt = this.getSession(deviceId);
        if (!sesOpt.isPresent()) {
            LOG.log(Level.WARNING, "No session to validate {0}", deviceId);
            return false;
        }
        Session ses = (Session)sesOpt.get();
        boolean ret = this.canSetSessionDeviceType(type);
        ses.setEnabled(ret && validated);
        return ret;
    }

    boolean canSetSessionDeviceType(DeviceType type) {
        Integer count = (Integer)this.deviceTypeCounts.get(type);
        if (count == null) {
            count = 0;
        }
        switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$DeviceType[type.ordinal()]) {
            case 1: {
                if (count > this.licManager.getMaxAlfrescoAgents()) {
                    LOG.log(Level.WARNING, "Number of alfresco agents {0} is at licensed maximum of {1}", new Object[]{count, this.licManager.getMaxAlfrescoAgents()});
                    MessageBus.getBus().post((Object)NotificationEvent.createForAdmins((Notification)this.getLicenceLimitNotification(type, count.intValue(), this.licManager.getMaxAlfrescoAgents())));
                    return false;
                }
                return true;
            }
            case 2: {
                if (count > this.licManager.getMaxEndpointAgents()) {
                    LOG.log(Level.WARNING, "Number of endpoints {0} is at licensed maximum of {1}", new Object[]{count, this.licManager.getMaxEndpointAgents()});
                    MessageBus.getBus().post((Object)NotificationEvent.createForAdmins((Notification)this.getLicenceLimitNotification(type, count.intValue(), this.licManager.getMaxEndpointAgents())));
                    return false;
                }
                return true;
            }
            case 3: {
                if (count > this.licManager.getMaxFileservers()) {
                    LOG.log(Level.WARNING, "Number of fileservers {0} is at licensed maximum of {1}", new Object[]{count, this.licManager.getMaxFileservers()});
                    MessageBus.getBus().post((Object)NotificationEvent.createForAdmins((Notification)this.getLicenceLimitNotification(type, count.intValue(), this.licManager.getMaxFileservers())));
                    return false;
                }
                return true;
            }
            case 4: {
                if (count > this.licManager.getMaxO365Agents()) {
                    LOG.log(Level.WARNING, "Number of O365 {0} is at licensed maximum of {1}", new Object[]{count, this.licManager.getMaxO365Agents()});
                    MessageBus.getBus().post((Object)NotificationEvent.createForAdmins((Notification)this.getLicenceLimitNotification(type, count.intValue(), this.licManager.getMaxO365Agents())));
                    return false;
                }
                return true;
            }
            case 5: {
                if (count > this.licManager.getMaxGoogleAgents()) {
                    LOG.log(Level.WARNING, "Number of google {0} is at licensed maximum of {1}", new Object[]{count, this.licManager.getMaxGoogleAgents()});
                    MessageBus.getBus().post((Object)NotificationEvent.createForAdmins((Notification)this.getLicenceLimitNotification(type, count.intValue(), this.licManager.getMaxGoogleAgents().intValue())));
                    return false;
                }
                return true;
            }
            case 6: {
                if (count > this.licManager.getMaxAtlassianAgents()) {
                    LOG.log(Level.WARNING, "Number of Atlassian {0} is at licensed maximum of {1}", new Object[]{count, this.licManager.getMaxAtlassianAgents()});
                    MessageBus.getBus().post((Object)NotificationEvent.createForAdmins((Notification)this.getLicenceLimitNotification(type, count.intValue(), this.licManager.getMaxAtlassianAgents())));
                    return false;
                }
                return true;
            }
        }
        LOG.log(Level.SEVERE, "Unknown device type in canSetSessionDeviceType {0}", type);
        return false;
    }

    Session createNewSession(String deviceId, DeviceType type) {
        Session ses = new Session(type);
        if (this.sessions.containsKey(deviceId)) {
            this.sessions.put(deviceId, ses);
            LOG.log(Level.INFO, "Replace session {0}", deviceId);
            return ses;
        }
        if (this.disabledSessions.containsKey(deviceId)) {
            this.disabledSessions.put(deviceId, ses);
            LOG.log(Level.INFO, "Replace disabled session {0}", deviceId);
            return ses;
        }
        this.addSession(deviceId, ses);
        return ses;
    }

    boolean disableSession(String deviceId) {
        if (this.sessions.containsKey(deviceId)) {
            this.disabledSessions.put(deviceId, (Session)this.sessions.get(deviceId));
            this.removeSession(deviceId);
            return true;
        }
        return false;
    }

    boolean allowAccess(String deviceId) {
        if (this.sessions.containsKey(deviceId)) {
            return true;
        }
        if (this.disabledSessions.containsKey(deviceId)) {
            Session ses = (Session)this.disabledSessions.get(deviceId);
            ses.setEnabled(true);
            this.addSession(deviceId, ses);
            this.disabledSessions.remove(deviceId);
            return true;
        }
        return false;
    }

    boolean markSessionAsSeen(String deviceId) {
        if (!this.sessions.containsKey(deviceId) && !this.disabledSessions.containsKey(deviceId)) {
            return false;
        }
        Session ses = (Session)this.sessions.get(deviceId);
        if (ses != null) {
            ses.seen();
        } else {
            ses = (Session)this.disabledSessions.get(deviceId);
            if (ses != null) {
                ses.seen();
            }
        }
        return true;
    }

    boolean sessionIsConnected(String deviceId) {
        boolean connected = false;
        if (this.sessions.containsKey(deviceId)) {
            Session ses = (Session)this.sessions.get(deviceId);
            boolean bl = connected = !ses.isExpired();
            if (!connected) {
                LOG.log(Level.WARNING, "{0} has expired session ({1}s)", new Object[]{deviceId, ses.expiredBy()});
            }
        }
        return connected;
    }

    private void trimExpiredSessions() {
        this.sessions.forEach((key, value) -> {
            if (value.isExpired()) {
                LOG.log(Level.INFO, "Remove expired session");
                this.removeSession(key);
            }
        });
        this.disabledSessions.forEach((key, value) -> {
            if (value.isExpired()) {
                MessageBus.getBus().post((Object)new SessionChangeEvent(key, SessionChangeEvent.Reason.NOT_CONNECTED));
                this.disabledSessions.remove(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(String deviceId, Session s) {
        ConcurrentMap concurrentMap = this.sessions;
        synchronized (concurrentMap) {
            this.sessions.put(deviceId, s);
        }
        DeviceType type = s.getType();
        this.incrementDeviceTypes(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(String deviceId) {
        LOG.log(Level.INFO, "Remove session {0}", deviceId);
        ConcurrentMap concurrentMap = this.sessions;
        synchronized (concurrentMap) {
            Session sess = (Session)this.sessions.get(deviceId);
            if (sess != null) {
                DeviceType type = sess.getType();
                this.decrementDeviceTypes(type);
                this.sessions.remove(deviceId);
            }
        }
        MessageBus.getBus().post((Object)new SessionChangeEvent(deviceId, SessionChangeEvent.Reason.NOT_CONNECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementDeviceTypes(DeviceType type) {
        ConcurrentMap concurrentMap = this.deviceTypeCounts;
        synchronized (concurrentMap) {
            if (this.deviceTypeCounts.containsKey(type)) {
                this.deviceTypeCounts.put(type, (Integer)this.deviceTypeCounts.get(type) - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementDeviceTypes(DeviceType type) {
        ConcurrentMap concurrentMap = this.deviceTypeCounts;
        synchronized (concurrentMap) {
            if (!this.deviceTypeCounts.containsKey(type)) {
                this.deviceTypeCounts.put(type, 0);
            }
            this.deviceTypeCounts.put(type, (Integer)this.deviceTypeCounts.get(type) + 1);
        }
    }

    private Notification getLicenceLimitNotification(DeviceType type, int actual, int allowed) {
        StringBuilder sb = new StringBuilder();
        sb.append("Licence limit reached. You have ");
        sb.append(actual).append(" ").append(type.toString()).append(" ").append("agents ");
        sb.append("trying to connect to your manager but your licence allows only ");
        sb.append(allowed).append(" ").append(type.getDisplayName()).append(" agents. ");
        sb.append("You can view details of your licence and connected devices under Administration Menu. Contact sales to increase your licence quota.");
        return new Notification(sb.toString(), NotificationType.WARNING);
    }
}

