/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.devices;

import com.geolang.ascema.endpointcommon.domain.DeviceType;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

public class Session {
    private static final int EXPIRE_AFTER_SECONDS = 120;
    private DeviceType type;
    private LocalDateTime lastSeen;
    private boolean enabled;

    public Session(DeviceType type) {
        this.type = type;
        this.lastSeen = LocalDateTime.now();
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.seen();
    }

    public DeviceType getType() {
        return this.type;
    }

    public void setType(DeviceType type) {
        this.type = type;
    }

    public LocalDateTime getLastSeen() {
        return this.lastSeen;
    }

    public void seen() {
        this.lastSeen = LocalDateTime.now();
    }

    public boolean isExpired() {
        return this.lastSeen.plus(120L, ChronoUnit.SECONDS).isBefore(LocalDateTime.now());
    }

    public long expiredBy() {
        return ChronoUnit.SECONDS.between(this.lastSeen.plus(120L, ChronoUnit.SECONDS), LocalDateTime.now());
    }
}

