/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.devices;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.geolang.ascema.endpointcommon.database.DatabaseCredentials;
import com.geolang.ascema.endpointcommon.domain.AgentDiagnosticsLiveData;
import com.geolang.ascema.endpointcommon.domain.DeviceDetails;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.Job;
import com.geolang.ascema.endpointcommon.domain.SyncFolder;
import com.geolang.ascema.endpointcommon.domain.searchconfig.DBQuery;
import com.geolang.ascema.endpointcommon.jms.MessageEncryptor;
import com.geolang.ascema.endpointcommon.messages.servernotification.ClassificationModelServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.EmailChangeServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.GetCloudUsersServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.JobsAvailableServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.SendMeYourLogServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerNotificationBase;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerUIDetails;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerUIUrlServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.SetCloudCredentialsServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.SetFollowNetworkSharesServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.TestCloudCredentialsServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.TestDatabaseCredentialsServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.TestDatabaseQueryServerMessage;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.CloudCredentials;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.ConnectionStatus;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managercore.domain.ManagerRole;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerdomain.domain.CloudCredentialStored;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.QuietTimeConfiguration;
import com.geolang.ascema.managerdomain.web.WebAgentDiagnosticData;
import com.geolang.ascema.managerevents.CloudCredentialsChangeEvent;
import com.geolang.ascema.managerevents.ConnectionStatusEvent;
import com.geolang.ascema.managerevents.ServerNameChangeEvent;
import com.geolang.ascema.managerevents.SessionChangeEvent;
import com.geolang.ascema.managerpersistence.CloudCredentialsStore;
import com.geolang.ascema.managerpersistence.EndpointStore;
import com.geolang.ascema.managerpersistence.serviceinterfaces.IDeviceService;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.AlfrescoEndpointService;
import com.geolang.ascema.managerservice.controllers.AtlassianEndpointService;
import com.geolang.ascema.managerservice.controllers.ProxySettings;
import com.geolang.ascema.managerservice.controllers.ServerMessagesOutQueue;
import com.geolang.ascema.managerservice.controllers.ServerOutToDeviceListener;
import com.geolang.ascema.managerservice.controllers.devices.AgentDiagnosticsManager;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.devices.Session;
import com.geolang.ascema.managerservice.controllers.devices.SessionManager;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.messaging.serverserver.BaseServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.MasterEnd;
import com.geolang.ascema.managerservice.messaging.serverserver.SessionChangeServerServerMessage;
import com.geolang.ascema.managerservice.persist.keys.KeyPairStore;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.security.Key;
import java.security.KeyPair;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class DeviceService
implements IDeviceService {
    private static final Logger LOG = Logger.getLogger(DeviceService.class.getName());
    @Lazy
    @Autowired
    private TaskManager taskManager;
    @Lazy
    @Autowired
    private ServerMessagesOutQueue outQueue;
    @Lazy
    @Autowired
    private EndpointStore endpointStore;
    @Autowired
    private MasterEnd master;
    @Autowired
    private AuditLogService auditLog;
    @Autowired
    private KeyPairStore kpStore;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private AlfrescoEndpointService alfrescoHelper;
    @Autowired
    private AtlassianEndpointService atlassianHelper;
    @Autowired
    private CloudCredentialsStore credentialsStore;
    private final SettingsFile settings;
    private final MessageEncryptor messageEncryptor = new MessageEncryptor();
    private final AgentDiagnosticsManager diagnosticsManager = new AgentDiagnosticsManager();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, r -> {
        Thread t = new Thread(r);
        t.setName("DevSSched");
        t.setDaemon(true);
        return t;
    });

    public DeviceService() {
        this.settings = SettingsFile.getInstance();
        this.scheduler.scheduleAtFixedRate(() -> this.updateLastSeenTimes(), 1L, 1L, TimeUnit.HOURS);
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
        this.outQueue.stop();
        this.scheduler.shutdownNow();
    }

    public ServerMessagesOutQueue getOutQueue() {
        return this.outQueue;
    }

    @Subscribe
    public void onServerNameChange(ServerNameChangeEvent ev) {
        List all = this.endpointStore.getAll(false, false);
        for (DeviceRegistration d : all) {
            if (!d.getManagerName().equals(ev.getOldName())) continue;
            d.setManagerName(ev.getNewName());
            this.endpointStore.save(d);
        }
    }

    @Subscribe
    public void onPlatformConnectionStatusChange(ConnectionStatusEvent ev) {
        DeviceRegistration reg;
        String deviceId = ev.getDeviceId();
        ConnectionStatus status = ev.getStatus();
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, true, true);
        if (opt.isPresent() && (reg = (DeviceRegistration)opt.get()).getDeviceType().equals((Object)DeviceType.O365) && !ev.getStatus().isIsDatabase() && status.getConnectedHostName() != null && !status.getConnectedHostName().isEmpty()) {
            reg.setTenantName(status.getConnectedHostName());
            this.endpointStore.save(reg);
        }
    }

    public void updateAgentSyncFolders(String deviceId, List<SyncFolder> folders) {
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
        if (opt.isPresent()) {
            DeviceRegistration reg = (DeviceRegistration)opt.get();
            reg.setSyncFolders(folders);
            this.endpointStore.save(reg);
            SessionChangeEvent evt = new SessionChangeEvent(deviceId, SessionChangeEvent.Reason.UPDATED);
            MessageBus.getBus().post((Object)evt);
        }
    }

    public void updateAgentDatabaseDrivers(String deviceId, String dbDrivers) {
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
        if (opt.isPresent()) {
            DeviceRegistration reg = (DeviceRegistration)opt.get();
            reg.setDbDrivers(dbDrivers);
            this.endpointStore.save(reg);
            SessionChangeEvent evt = new SessionChangeEvent(deviceId, SessionChangeEvent.Reason.UPDATED);
            MessageBus.getBus().post((Object)evt);
        }
    }

    public void updateAgentDiagnostics(String deviceId, AgentDiagnosticsLiveData data) {
        this.diagnosticsManager.saveLiveData(deviceId, data);
    }

    public WebAgentDiagnosticData getAgentDiagnosticData(String deviceId) {
        return this.diagnosticsManager.getData(deviceId);
    }

    public void setEmailOnDevice(String deviceId, String email) {
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
        if (!opt.isPresent()) {
            return;
        }
        DeviceRegistration reg = (DeviceRegistration)opt.get();
        reg.setUserEmail(email);
        this.endpointStore.save(reg);
        SessionChangeEvent evt = new SessionChangeEvent(deviceId, SessionChangeEvent.Reason.UPDATED);
        MessageBus.getBus().post((Object)evt);
        this.outQueue.sendMessage(deviceId, (ServerNotificationBase)new EmailChangeServerMessage(email), true);
    }

    public void setFollowNetworkShares(String user, String deviceId, boolean follow) {
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
        if (!opt.isPresent()) {
            return;
        }
        DeviceRegistration reg = (DeviceRegistration)opt.get();
        reg.setFollowNetworkShares(follow);
        this.endpointStore.save(reg);
        this.auditLog.followNetworkChange(user, reg, follow);
        SessionChangeEvent evt = new SessionChangeEvent(deviceId, SessionChangeEvent.Reason.UPDATED);
        MessageBus.getBus().post((Object)evt);
        this.outQueue.sendMessage(deviceId, (ServerNotificationBase)new SetFollowNetworkSharesServerMessage(follow, user), true);
    }

    public Optional<String> preRegister(String deviceId) {
        KeyPair kp;
        Optional kpOpt = this.kpStore.getKeyPairForDevice(deviceId);
        if (kpOpt.isPresent()) {
            LOG.log(Level.INFO, "Device already has kp {0}", deviceId);
            kp = (KeyPair)kpOpt.get();
        } else {
            kp = this.messageEncryptor.createKeys();
            this.kpStore.saveKeyPairForDevice(deviceId, kp);
        }
        return Optional.of(MessageEncryptor.KeytoString((Key)kp.getPublic()));
    }

    public Optional<String> register(DeviceDetails dd) {
        try {
            DeviceRegistration existing;
            Session ses = this.sessionManager.createNewSession(dd.getDeviceId(), dd.getDeviceType());
            String thisManagerUUID = this.settings.getUUID();
            String managerName = this.settings.getManagerName();
            DeviceRegistration regFromAgent = new DeviceRegistration(dd, thisManagerUUID, managerName);
            LOG.log(Level.INFO, "Register {0}", regFromAgent);
            Optional opt = this.endpointStore.getDeviceRegFromId(dd.getDeviceId(), false, false);
            if (opt.isPresent()) {
                LOG.log(Level.INFO, "Device already registered {0}", dd.getDeviceDescription());
                existing = (DeviceRegistration)opt.get();
                this.updateAgentWithOfflineChanges(existing, regFromAgent);
                existing.updateFromAgent(dd);
            } else {
                LOG.log(Level.INFO, "New Device {0}", regFromAgent.getDeviceDescription());
                regFromAgent.setValidated(this.settings.getAllowConnectionsByDefault(true));
                existing = regFromAgent;
            }
            ses.seen();
            existing.setLastSeen(LocalDate.now());
            this.migrateCloudCredentials(dd, existing);
            this.endpointStore.save(existing);
            this.diagnosticsManager.saveStaticData(dd.getDeviceId(), dd.getStaticData());
            boolean canenable = this.sessionManager.canEnable(dd.getDeviceId(), dd.getDeviceType(), existing.isValidated());
            if (!canenable) {
                LOG.log(Level.INFO, "Agent will not get any jobs! {0}", dd.getDeviceDescription());
            }
            return Optional.of("OK");
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Failed to register {0}", t.getMessage());
            return Optional.empty();
        }
    }

    public void informAgentOfAllJobs(String deviceId) {
        Optional sesOpt = this.sessionManager.getSession(deviceId);
        if (!sesOpt.isPresent()) {
            LOG.warning("no session in inform agent of jobs");
            return;
        }
        Session ses = (Session)sesOpt.get();
        if (ses.isEnabled()) {
            this.informJobAvailable(deviceId, (List)this.taskManager.getJobsForDevice(deviceId), ProxySettings.getUIDetails((String)deviceId));
        }
    }

    public boolean informJobAvailable(String deviceId, List<Job> jobs, ServerUIDetails uidetails) {
        LOG.log(Level.INFO, "Send {0} jobs to {1}", new Object[]{jobs.size(), deviceId});
        boolean enabled = this.isEnabled(deviceId);
        if (enabled) {
            this.getOutQueue().sendMessage(deviceId, (ServerNotificationBase)new JobsAvailableServerMessage(jobs, uidetails), false);
        } else {
            LOG.log(Level.INFO, "Not sending job to device {0} - it's offline or not enabled", deviceId);
        }
        return enabled;
    }

    private void updateAgentWithOfflineChanges(DeviceRegistration existing, DeviceRegistration fromClient) {
        if (!fromClient.getUserEmail().equals(existing.getUserEmail()) && fromClient.getUserEmail().isEmpty()) {
            this.outQueue.sendMessage(fromClient.getDeviceId(), (ServerNotificationBase)new EmailChangeServerMessage(existing.getUserEmail()), true);
            fromClient.setUserEmail(existing.getUserEmail());
        }
    }

    public void bye(String deviceId) {
        LOG.log(Level.INFO, "Bye {0}", deviceId);
        this.sessionManager.removeSession(deviceId);
        this.deRegisterCallback(deviceId);
    }

    public void updateDevice(DeviceRegistration deviceReg) {
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceReg.getDeviceId(), false, true);
        if (!opt.isPresent()) {
            return;
        }
        DeviceRegistration existing = (DeviceRegistration)opt.get();
        existing.updateFromMaster(deviceReg);
        if (existing.isIsManagedOnThisNode()) {
            existing.setTags(deviceReg.getTags());
            this.endpointStore.save(existing);
        }
    }

    public boolean setTags(String deviceId, String[] tags) {
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
        if (!opt.isPresent()) {
            return false;
        }
        DeviceRegistration existing = (DeviceRegistration)opt.get();
        existing.setTags(tags);
        if (existing.isIsManagedOnThisNode()) {
            this.endpointStore.save(existing);
            return true;
        }
        if (this.master.isRunning()) {
            SessionChangeServerServerMessage msg = new SessionChangeServerServerMessage(this.settings.getUUID(), deviceId, SessionChangeEvent.Reason.UPDATED, existing, "");
            this.outQueue.sendServerServerMessage(deviceId, (BaseServerServerMessage)msg, true);
            return true;
        }
        return false;
    }

    public boolean denyAccess(String user, String deviceId) {
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
        if (!opt.isPresent()) {
            return false;
        }
        DeviceRegistration existing = (DeviceRegistration)opt.get();
        this.auditLog.deviceBlocked(user, existing);
        existing.setValidated(false);
        if (existing.isIsManagedOnThisNode()) {
            this.endpointStore.save(existing);
            this.sessionManager.disableSession(deviceId);
            return true;
        }
        if (this.master.isRunning()) {
            SessionChangeServerServerMessage msg = new SessionChangeServerServerMessage(this.settings.getUUID(), deviceId, SessionChangeEvent.Reason.DENY, existing, user);
            this.outQueue.sendServerServerMessage(deviceId, (BaseServerServerMessage)msg, true);
            return true;
        }
        return false;
    }

    public boolean allowAccess(String user, String deviceId) {
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
        if (!opt.isPresent()) {
            return false;
        }
        DeviceRegistration existing = (DeviceRegistration)opt.get();
        this.auditLog.deviceAllowed(user, existing);
        existing.setValidated(true);
        if (existing.isIsManagedOnThisNode()) {
            this.endpointStore.save(existing);
            this.sessionManager.allowAccess(deviceId);
            return this.sessionManager.canSetSessionDeviceType(existing.getDeviceType());
        }
        if (this.master.isRunning()) {
            SessionChangeServerServerMessage msg = new SessionChangeServerServerMessage(this.settings.getUUID(), deviceId, SessionChangeEvent.Reason.ALLOW, existing, user);
            this.outQueue.sendServerServerMessage(deviceId, (BaseServerServerMessage)msg, true);
            return true;
        }
        return false;
    }

    public boolean isEnabled(String deviceId) {
        Optional devopt = this.getDeviceFromId(deviceId, false);
        if (!devopt.isPresent()) {
            return false;
        }
        DeviceRegistration dev = (DeviceRegistration)devopt.get();
        if (dev.isIsManagedOnThisNode()) {
            Optional opt = this.sessionManager.getSession(deviceId);
            if (!opt.isPresent()) {
                return false;
            }
            boolean ret = ((Session)opt.get()).isEnabled();
            if (!ret) {
                ret = this.sessionManager.canEnable(deviceId, dev.getDeviceType(), dev.isValidated());
            }
            return ret;
        }
        return true;
    }

    public boolean deleteDevice(String user, String deviceId) {
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
        if (!opt.isPresent()) {
            return false;
        }
        DeviceRegistration reg = (DeviceRegistration)opt.get();
        this.auditLog.deviceDelete(user, reg);
        LOG.log(Level.INFO, "{0} Deleting device {1}", new Object[]{user, deviceId});
        boolean isSecondary = SettingsFile.getInstance().getManagerRole().equals((Object)ManagerRole.SECONDARY);
        if (reg.isIsManagedOnThisNode() || !isSecondary) {
            boolean ret = this.endpointStore.delete(reg);
            this.taskManager.markUnfinishedJobsAsCancelled(deviceId);
            if (ret) {
                this.sessionManager.removeSession(deviceId);
            }
            return ret;
        }
        if (this.master.isRunning()) {
            SessionChangeServerServerMessage msg = new SessionChangeServerServerMessage(this.settings.getUUID(), deviceId, SessionChangeEvent.Reason.REMOVED, reg, user);
            this.outQueue.sendServerServerMessage(deviceId, (BaseServerServerMessage)msg, true);
            return true;
        }
        return false;
    }

    public List<DeviceRegistration> getAllDevices(boolean includeDeleted) {
        List all = this.endpointStore.getAll(true, includeDeleted);
        all.forEach(d -> {
            if (d.isIsManagedOnThisNode()) {
                boolean connected = this.sessionManager.sessionIsConnected(d.getDeviceId());
                d.setConnected(connected);
            } else if (this.master.isRunning()) {
                boolean connected = this.master.isConnected(d);
                d.setConnected(connected);
            }
        });
        return all;
    }

    public boolean deviceIsUsingCredentails(String encJson) {
        try {
            CloudCredentials cc = CloudCredentials.fromJSON((String)encJson);
            for (DeviceRegistration dr : this.getAllDevices(false)) {
                Optional opt = dr.getExpandedCredentials();
                if (!opt.isPresent() || !((CloudCredentials)opt.get()).equals((Object)cc)) continue;
                return true;
            }
            return false;
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(DeviceService.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public List<DeviceRegistration> getDevicesOfType(DeviceType type) {
        return this.getDevicesOfTypes(Collections.singletonList(type));
    }

    public List<DeviceRegistration> getDevicesOfTypes(List<DeviceType> types) {
        List all = this.endpointStore.getDevicesOfTypes(types, true);
        all.forEach(d -> {
            if (d.isIsManagedOnThisNode()) {
                boolean connected = this.sessionManager.sessionIsConnected(d.getDeviceId());
                d.setConnected(connected);
            } else if (this.master.isRunning()) {
                boolean connected = this.master.isConnected(d);
                d.setConnected(connected);
            }
        });
        return all;
    }

    public Optional<DeviceRegistration> getDeviceFromId(String id, boolean includeDeleted) {
        Optional ret = this.endpointStore.getDeviceRegFromId(id, includeDeleted, true);
        if (ret.isPresent() && ((DeviceRegistration)ret.get()).isIsManagedOnThisNode()) {
            ((DeviceRegistration)ret.get()).setConnected(this.sessionManager.sessionIsConnected(id));
        } else if (this.master.isRunning() && ret.isPresent()) {
            boolean connected = this.master.isConnected((DeviceRegistration)ret.get());
            ((DeviceRegistration)ret.get()).setConnected(connected);
        }
        return ret;
    }

    public boolean checkAlfrescoPath(String path) {
        return this.alfrescoHelper.checkAlfrescoPath(path);
    }

    public void getAspects() {
        this.alfrescoHelper.getAspects();
    }

    public void getLog(String deviceId) {
        this.outQueue.sendMessage(deviceId, (ServerNotificationBase)new SendMeYourLogServerMessage(), false);
    }

    public String getEmail(String deviceId) {
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
        if (!opt.isPresent()) {
            return "";
        }
        return ((DeviceRegistration)opt.get()).getUserEmail();
    }

    public boolean setDisplayName(String deviceId, String displayname) {
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
        if (opt.isEmpty()) {
            return false;
        }
        DeviceRegistration dr = (DeviceRegistration)opt.get();
        dr.setDisplayName(displayname);
        this.endpointStore.save(dr);
        return true;
    }

    public void registerCallback(ServerOutToDeviceListener cb, String deviceId) {
        this.outQueue.registerCallback(cb, deviceId);
    }

    public void deRegisterCallback(String deviceId) {
        this.outQueue.deRegisterCallback(deviceId);
    }

    public void markAsSeen(String deviceId, boolean recreateIfNeeded) {
        if (this.sessionManager == null) {
            return;
        }
        boolean found = this.sessionManager.markSessionAsSeen(deviceId);
        if (!found && recreateIfNeeded) {
            LOG.log(Level.WARNING, "Seem to have lost session for {0}", deviceId);
            Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, false);
            if (opt.isPresent()) {
                Session ses = this.sessionManager.createNewSession(deviceId, ((DeviceRegistration)opt.get()).getDeviceType());
                ses.seen();
                ((DeviceRegistration)opt.get()).setLastSeen(LocalDate.now());
                this.endpointStore.save((DeviceRegistration)opt.get());
                LOG.info("Recreated session");
            } else {
                LOG.warning("Failed to recreate session, agent thinks it is connected");
            }
        }
    }

    public void useLocallySetUI() {
        ManagerRole role = this.settings.getManagerRole();
        if (!this.settings.getPrimaryIsMainUI() && role.equals((Object)ManagerRole.SECONDARY) || role.equals((Object)ManagerRole.PRIMARY) || role.equals((Object)ManagerRole.STANDALONE)) {
            for (String devId : this.sessionManager.getAllDeviceIds()) {
                ServerUIDetails ui = ProxySettings.getUIDetails((String)devId);
                this.tellDeviceWhereUIIs(devId, ui);
            }
        }
    }

    public void setPrimaryUIDetails(boolean use, ServerUIDetails details) {
        this.settings.setPrimaryIsMainUI(use);
        for (String devId : this.sessionManager.getAllDeviceIds()) {
            ServerUIDetails ui = use ? new ServerUIDetails(details, devId, null) : ProxySettings.getUIDetails((String)devId);
            this.tellDeviceWhereUIIs(devId, ui);
        }
    }

    public void tellDeviceWhereUIIs(String deviceId, ServerUIDetails details) {
        this.outQueue.sendMessage(deviceId, (ServerNotificationBase)new ServerUIUrlServerMessage(deviceId, details), false);
    }

    public void sendClassificationModel(String deviceId, byte[] model) {
        this.outQueue.sendMessageByte(deviceId, (ServerNotificationBase)new ClassificationModelServerMessage(), model);
    }

    public void getCloudUsers(DeviceType type) {
        for (DeviceRegistration reg : this.endpointStore.getAll(true, false)) {
            if (!reg.getDeviceType().equals((Object)type)) continue;
            this.outQueue.sendMessage(reg.getDeviceId(), (ServerNotificationBase)new GetCloudUsersServerMessage(type), false);
        }
    }

    public boolean setQuietTimes(String deviceId, QuietTimeConfiguration config) {
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
        if (opt.isEmpty()) {
            LOG.log(Level.WARNING, "no device to set quiet times {0}", deviceId);
            return false;
        }
        LOG.log(Level.INFO, "set quiet times for {0} to {1}", new Object[]{((DeviceRegistration)opt.get()).hostNameOrCloudHost(), config});
        return this.endpointStore.setQuietTimes((DeviceRegistration)opt.get(), config);
    }

    public boolean unSetQuietTimes(String deviceId) {
        LOG.log(Level.INFO, "unset quiet times");
        return this.setQuietTimes(deviceId, QuietTimeConfiguration.getAllUnsetConfiguration());
    }

    public boolean checkDeviceQuietNow(boolean all, List<String> deviceIds) {
        List<DeviceRegistration> toCheck = new ArrayList();
        if (all) {
            toCheck = this.endpointStore.getAll(false, false);
        } else {
            for (String dev : deviceIds) {
                Optional reg = this.endpointStore.getDeviceRegFromId(dev, false, false);
                if (!reg.isPresent()) continue;
                toCheck.add((DeviceRegistration)reg.get());
            }
        }
        for (DeviceRegistration reg : toCheck) {
            if (!reg.getExpandedQuietTime().isInQuietTimeNow()) continue;
            return true;
        }
        return false;
    }

    private void setDeviceType(String user, String deviceId, DeviceType type) {
        boolean ok;
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
        if (!opt.isPresent()) {
            return;
        }
        DeviceRegistration reg = (DeviceRegistration)opt.get();
        if (reg.isIsManagedOnThisNode() && !(ok = this.sessionManager.updateDeviceTypeInSession(deviceId, type))) {
            LOG.info("Failed to update session");
        }
        DeviceType from = reg.getDeviceType();
        reg.setDeviceType(type);
        this.endpointStore.save(reg);
        this.auditLog.deviceRoleChange(user, reg, from);
        SessionChangeEvent evt = new SessionChangeEvent(deviceId, SessionChangeEvent.Reason.UPDATED);
        MessageBus.getBus().post((Object)evt);
    }

    public boolean setCloudCredentialsAndDeviceType(String user, String deviceId, String ccJSON, DeviceType deviceType) throws JsonProcessingException {
        ServerMessagesOutQueue.Status status;
        Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
        if (!opt.isPresent()) {
            return false;
        }
        DeviceRegistration reg = (DeviceRegistration)opt.get();
        if (!reg.getDeviceType().equals((Object)deviceType)) {
            this.setDeviceType(user, deviceId, deviceType);
        }
        CloudCredentials cc = switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$DeviceType[deviceType.ordinal()]) {
            case 1 -> CloudCredentials.createForEndpoint();
            case 2 -> CloudCredentials.createForFileServer();
            default -> CloudCredentials.fromJSON((String)ccJSON);
        };
        Optional oldCreds = reg.getExpandedCredentials();
        this.endpointStore.setCloudCredentials(reg, cc);
        LOG.log(Level.INFO, "update agent {0} to be {1}", new Object[]{reg.getDeviceDescription(), cc.getType().getDisplayName()});
        Future statusFut = this.outQueue.sendMessage(deviceId, (ServerNotificationBase)new SetCloudCredentialsServerMessage(cc), false);
        try {
            status = (ServerMessagesOutQueue.Status)statusFut.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return false;
        }
        MessageBus.getBus().post((Object)new CloudCredentialsChangeEvent(reg, oldCreds));
        return status.equals((Object)ServerMessagesOutQueue.Status.SENT);
    }

    public boolean testCloudCredentials(String deviceId, CloudCredentials cc) {
        ServerMessagesOutQueue.Status status;
        Future statusFut = this.outQueue.sendMessage(deviceId, (ServerNotificationBase)new TestCloudCredentialsServerMessage(cc), false);
        try {
            status = (ServerMessagesOutQueue.Status)statusFut.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return false;
        }
        return status.equals((Object)ServerMessagesOutQueue.Status.SENT);
    }

    public boolean testDatabaseCredentials(String deviceId, DatabaseCredentials cc) {
        ServerMessagesOutQueue.Status status;
        Future statusFut = this.outQueue.sendMessage(deviceId, (ServerNotificationBase)new TestDatabaseCredentialsServerMessage(cc), false);
        try {
            status = (ServerMessagesOutQueue.Status)statusFut.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return false;
        }
        return status.equals((Object)ServerMessagesOutQueue.Status.SENT);
    }

    public boolean testDatabaseQuery(String deviceId, DatabaseCredentials creds, DBQuery query, int rows) {
        ServerMessagesOutQueue.Status status;
        TestDatabaseQueryServerMessage msg = new TestDatabaseQueryServerMessage(creds, query, rows);
        Future statusFut = this.outQueue.sendMessage(deviceId, (ServerNotificationBase)msg, false);
        try {
            status = (ServerMessagesOutQueue.Status)statusFut.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return false;
        }
        return status.equals((Object)ServerMessagesOutQueue.Status.SENT);
    }

    public boolean checkCloudConnection(String deviceId, DeviceType type) {
        ServerMessagesOutQueue.Status status;
        CloudCredentials creds = CloudCredentials.createEmptyCredentials((DeviceType)type);
        Future statusFut = this.outQueue.sendMessage(deviceId, (ServerNotificationBase)new TestCloudCredentialsServerMessage(creds), false);
        try {
            status = (ServerMessagesOutQueue.Status)statusFut.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return false;
        }
        return status.equals((Object)ServerMessagesOutQueue.Status.SENT);
    }

    public boolean checkAtlassianPath(String path) {
        return this.atlassianHelper.checkAtlassianPath(path);
    }

    public void getAtlassianSpaces() {
        this.atlassianHelper.getSpaces();
    }

    public void getJiraProjects() {
        this.atlassianHelper.getProjects();
    }

    public void getJiraSecuritySchemes() {
        this.atlassianHelper.getJiraSecuritySchemes();
    }

    public void getBitbucketRepos() {
        this.atlassianHelper.getBitbucketRepos();
    }

    private void updateLastSeenTimes() {
        LocalDate now = LocalDate.now();
        for (String devId : this.sessionManager.getAllDeviceIds()) {
            Optional regOpt = this.endpointStore.getDeviceRegFromId(devId, false, true);
            if (!regOpt.isPresent()) continue;
            DeviceRegistration reg = (DeviceRegistration)regOpt.get();
            reg.setLastSeen(now);
            this.endpointStore.save(reg);
        }
    }

    private void migrateCloudCredentials(DeviceDetails dd, DeviceRegistration existReg) {
        List ccs = this.credentialsStore.getAll();
        if (ccs != null) {
            try {
                String ccenc = dd.getCloudCredentails();
                if (ccenc != null && !ccenc.isEmpty()) {
                    CloudCredentials creds = CloudCredentials.fromJSON((String)ccenc);
                    for (CloudCredentialStored existing : ccs) {
                        Optional opt = existing.getCredentials();
                        if (!opt.isPresent() || !((CloudCredentials)opt.get()).equalsApartFromDisplayName(creds)) continue;
                        return;
                    }
                    LOG.info("we don't have the agent cloud credentials in the db - creating");
                    String displayname = "For " + dd.getHostname();
                    creds.setDisplayName(displayname);
                    CloudCredentialStored stored = new CloudCredentialStored(displayname, creds, "migrated");
                    this.credentialsStore.addOrReplace(stored);
                    existReg.setCloudCredentials(creds.toJSON());
                }
            }
            catch (JsonProcessingException ex) {
                Logger.getLogger(DeviceService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

