/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.devices;

import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.web.WebSecondaryConfig;
import com.geolang.ascema.managerservice.controllers.devices.DeviceCounts;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.license.LicenseManager;
import com.geolang.ascema.managerservice.messaging.serverserver.MasterEnd;
import java.io.Serializable;
import java.util.List;

public class DeviceCounts
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int allocatedEndpoints = 0;
    private int maxEndpoints = 0;
    private int maxFileServers = 0;
    private int maxSecondaryManagers = 0;
    private int allocatedSecondaryManagers = 0;
    private int connectedSecondaryManagers = 0;
    private int maxAlfresco = 0;
    private int maxO365 = 0;
    private int maxGoogle = 0;
    private int maxAtlassian = 0;
    private int connectedEndpoints = 0;
    private int connectedFileserver = 0;
    private int connectedAlfresco = 0;
    private int connectedO365 = 0;
    private int connectedGoogle = 0;
    private int connectedAtlassian = 0;
    private int connectedTotal = 0;

    public DeviceCounts(DeviceService controller, LicenseManager lic, MasterEnd master) {
        List devs = controller.getAllDevices(false);
        this.allocatedEndpoints = devs.size();
        for (DeviceRegistration reg : devs) {
            if (!reg.isConnected()) continue;
            ++this.connectedTotal;
            switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$DeviceType[reg.getDeviceType().ordinal()]) {
                case 1: {
                    ++this.connectedAlfresco;
                    break;
                }
                case 2: {
                    ++this.connectedEndpoints;
                    break;
                }
                case 3: {
                    ++this.connectedFileserver;
                    break;
                }
                case 4: {
                    ++this.connectedAtlassian;
                    break;
                }
                case 5: {
                    ++this.connectedO365;
                    break;
                }
                case 6: {
                    ++this.connectedGoogle;
                }
            }
        }
        this.maxEndpoints = lic.getMaxEndpointAgents();
        this.maxAlfresco = lic.getMaxAlfrescoAgents();
        this.maxFileServers = lic.getMaxFileservers();
        this.maxO365 = lic.getMaxO365Agents();
        this.maxGoogle = lic.getMaxGoogleAgents();
        this.maxAtlassian = lic.getMaxAtlassianAgents();
        this.maxSecondaryManagers = lic.getMaxSecondaryManagers();
        if (master.isRunning()) {
            for (WebSecondaryConfig config : master.getAttachedSlaves()) {
                ++this.allocatedSecondaryManagers;
                if (!config.isConnected()) continue;
                ++this.connectedSecondaryManagers;
            }
        }
    }

    public int getAllocatedEndpoints() {
        return this.allocatedEndpoints;
    }

    public int getMaxEndpoints() {
        return this.maxEndpoints;
    }

    public int getMaxFileServers() {
        return this.maxFileServers;
    }

    public int getMaxAlfresco() {
        return this.maxAlfresco;
    }

    public int getMaxAtlassian() {
        return this.maxAtlassian;
    }

    public int getMaxGoogle() {
        return this.maxGoogle;
    }

    public int getConnectedEndpoints() {
        return this.connectedEndpoints;
    }

    public int getConnectedFileserver() {
        return this.connectedFileserver;
    }

    public int getConnectedAlfresco() {
        return this.connectedAlfresco;
    }

    public int getConnectedAtlassian() {
        return this.connectedAtlassian;
    }

    public int getConnectedGoogle() {
        return this.connectedGoogle;
    }

    public int getConnectedTotal() {
        return this.connectedTotal;
    }

    public int getMaxSecondaryManagers() {
        return this.maxSecondaryManagers;
    }

    public int getAllocatedSecondaryManagers() {
        return this.allocatedSecondaryManagers;
    }

    public int getConnectedSecondaryManagers() {
        return this.connectedSecondaryManagers;
    }

    public int getMaxO365() {
        return this.maxO365;
    }

    public int getConnectedO365() {
        return this.connectedO365;
    }
}

