/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.devices;

import com.geolang.ascema.endpointcommon.domain.AgentDiagnosticsLiveData;
import com.geolang.ascema.endpointcommon.domain.AgentDiagnosticsStaticData;
import com.geolang.ascema.endpointcommon.util.UnitFormatter;
import com.geolang.ascema.managerdomain.web.AgentDiagnosticLevel;
import com.geolang.ascema.managerdomain.web.WebAgentDiagnosticData;
import com.geolang.ascema.managerservice.controllers.devices.DiagnosticData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class AgentDiagnosticsManager {
    Map<String, DiagnosticData> map = new HashMap();

    void saveStaticData(String deviceId, AgentDiagnosticsStaticData staticData) {
        this.map.put(deviceId, new DiagnosticData(staticData));
    }

    void saveLiveData(String deviceId, AgentDiagnosticsLiveData data) {
        DiagnosticData dd = (DiagnosticData)this.map.get(deviceId);
        if (dd != null) {
            dd.addLiveData(data);
        }
    }

    public WebAgentDiagnosticData getData(String deviceId) {
        WebAgentDiagnosticData ret = new WebAgentDiagnosticData();
        DiagnosticData dd = (DiagnosticData)this.map.get(deviceId);
        if (dd == null) {
            return ret;
        }
        AgentDiagnosticsStaticData stat = dd.getStaticdata();
        ret.setAgentMaxMemory(UnitFormatter.toHumanReadableBinaryPrefixes((long)stat.getAgentMaxMemoryBytes()));
        ret.setAgentVersion(stat.getAgentVersion());
        ret.setArch(stat.getArch());
        ret.setNumProcessors(stat.getNumProcessors());
        ret.setOsName(stat.getOsName());
        ret.setOsVersion(stat.getOsVersion());
        ret.setSystemMemory(UnitFormatter.toHumanReadableBinaryPrefixes((long)stat.getSystemMemoryBytes()));
        Optional current = dd.getCurrentLiveData();
        if (current.isPresent()) {
            ret.setAgentFreeMemory(UnitFormatter.toHumanReadableBinaryPrefixes((long)((AgentDiagnosticsLiveData)current.get()).getAgentFreeMemoryBytes()));
            String comma = "";
            StringBuilder sb = new StringBuilder();
            double[] arr = ((AgentDiagnosticsLiveData)current.get()).getLoadAverages();
            for (int i = 0; i < arr.length; ++i) {
                sb.append(comma).append(String.format("%.2f", arr[i]));
                comma = ", ";
            }
            ret.setLoadAverages(sb.toString());
            String durationUptime = DurationFormatUtils.formatDurationWords((long)((AgentDiagnosticsLiveData)current.get()).getAgentUptimeMs(), (boolean)true, (boolean)true);
            ret.setAgentUptime(durationUptime);
            ret.setSystemFreeMemory(UnitFormatter.toHumanReadableBinaryPrefixes((long)((AgentDiagnosticsLiveData)current.get()).getSystemFreeMemoryBytes()));
            this.setLevels(dd, ret);
        }
        return ret;
    }

    private void setLevels(DiagnosticData dd, WebAgentDiagnosticData ret) {
        double[] arr;
        if (dd.getCurrentLiveData().isEmpty()) {
            return;
        }
        double systemTotalMemory = dd.getStaticdata().getSystemMemoryBytes();
        double agentTotalMemory = dd.getStaticdata().getAgentMaxMemoryBytes();
        double availableSystemMemory = ((AgentDiagnosticsLiveData)dd.getCurrentLiveData().get()).getSystemFreeMemoryBytes();
        double availableAgentMemory = ((AgentDiagnosticsLiveData)dd.getCurrentLiveData().get()).getAgentFreeMemoryBytes();
        double agentPercentage = 100.0 * ((agentTotalMemory - availableAgentMemory) / agentTotalMemory);
        double systemPercentage = 100.0 * ((systemTotalMemory - availableSystemMemory) / systemTotalMemory);
        if (agentPercentage > 90.0 || availableAgentMemory < 1.048576E8) {
            ret.setAgentMemoryDiagnosticLevel(AgentDiagnosticLevel.CRITICAL.ordinal());
        }
        if (agentPercentage > 75.0 || availableAgentMemory < 5.24288E8) {
            ret.setAgentMemoryDiagnosticLevel(AgentDiagnosticLevel.WARNING.ordinal());
        }
        if (systemPercentage > 90.0 || availableSystemMemory < 1.048576E8) {
            ret.setSystemMemoryDiagnosticLevel(AgentDiagnosticLevel.CRITICAL.ordinal());
        }
        if (systemPercentage > 75.0 || availableSystemMemory < 7.340032E8) {
            ret.setSystemMemoryDiagnosticLevel(AgentDiagnosticLevel.WARNING.ordinal());
        }
        if ((arr = ((AgentDiagnosticsLiveData)dd.getCurrentLiveData().get()).getLoadAverages()).length > 1) {
            double oneMin = arr[1];
            if (oneMin > 90.0) {
                ret.setLoadDiagnosticLevel(AgentDiagnosticLevel.CRITICAL.ordinal());
            }
            if (oneMin > 65.0) {
                ret.setLoadDiagnosticLevel(AgentDiagnosticLevel.WARNING.ordinal());
            }
        }
    }
}

