/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.dashboard;

import com.geolang.ascema.domainmodelpublic.ResultStatus;
import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.dashboard.StatusTotalAndTopDevice;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.web.DashboardNumbers;
import com.geolang.ascema.managerdomain.web.TaskSummary;
import com.geolang.ascema.managerdomain.web.TaskTotals;
import com.geolang.ascema.managerdomain.web.TopDevice;
import com.geolang.ascema.managerevents.ResultsStateChangeEvent;
import com.geolang.ascema.managerpersistence.IDataPointRepo;
import com.geolang.ascema.managerservice.controllers.DatabaseSearchController;
import com.geolang.ascema.managerservice.controllers.dashboard.StatusTotalAndTopDeviceCache;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.results.ResultsManager;
import com.geolang.ascema.managerservice.controllers.retrieval.RetrievalResultsManager;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class DashboardManager {
    @Autowired
    private DeviceService endpointService;
    @Autowired
    private ResultsManager resultsManager;
    @Autowired
    private RetrievalResultsManager retrievalResultsManager;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private DatabaseSearchController dbManager;
    @Autowired
    private IDataPointRepo dpRepo;
    @Autowired
    @Qualifier(value="transactionManager")
    protected PlatformTransactionManager txManager;
    private ExecutorService startupExecutor = Executors.newSingleThreadExecutor();
    private StatusTotalAndTopDeviceCache dashboardNumCache = new StatusTotalAndTopDeviceCache();
    private final LoadingCache<String, TaskTotals> taskTotalCache = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(300L, TimeUnit.SECONDS).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.startupExecutor.submit(() -> this.init());
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.startupExecutor.shutdownNow();
        MessageBus.getBus().unregister((Object)this);
    }

    private void init() {
        TransactionTemplate tmpl = new TransactionTemplate(this.txManager);
        tmpl.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Subscribe
    public void onStatusChange(ResultsStateChangeEvent ev) {
        this.dashboardNumCache.clearForDevice(ev.getDeviceId());
    }

    public synchronized TaskTotals getTaskTotals() {
        try {
            return (TaskTotals)this.taskTotalCache.get((Object)"bob");
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DashboardManager.class.getName()).log(Level.SEVERE, null, ex);
            return new TaskTotals();
        }
    }

    private TaskTotals getTaskTotalsPrivate() {
        int size;
        int size2;
        TaskInstance ti;
        Optional opt;
        TaskTotals ret = new TaskTotals();
        for (TaskTemplate tt : this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.UNIFIED_SEARCH)) {
            ret.setSearchTotal(tt.getDisplayName(), Integer.valueOf(tt.getInstanceIds().size()));
            opt = this.taskManager.getLatestInstanceForTemplateWhereOneCompleted(tt);
            if (opt.isPresent()) {
                ti = (TaskInstance)opt.get();
                long numResults = this.resultsManager.getResultsCountForTaskInstance(ti.getUid());
                size2 = ti.getNumDevices();
                ret.addSearchLatest(new TaskSummary(ti.getUid(), tt.getDisplayName(), ti.getCreated(), size2, Math.toIntExact(numResults)));
                continue;
            }
            ret.addSearchLatest(new TaskSummary(tt.getUid(), tt.getDisplayName(), null, 0, 0));
        }
        for (TaskTemplate tt : this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.RETRIEVAL)) {
            ret.setRetrievalTotal(tt.getDisplayName(), Integer.valueOf(tt.getInstanceIds().size()));
            opt = this.taskManager.getLatestInstanceForTemplateWhereOneCompleted(tt);
            if (opt.isPresent()) {
                ti = (TaskInstance)opt.get();
                int numResults = this.retrievalResultsManager.getResultsCountForTaskInstance(ti.getUid()).intValue();
                size = ti.getNumberOfJobs();
                ret.addRetrievalLatest(new TaskSummary(ti.getUid(), tt.getDisplayName(), ti.getCreated(), size, numResults));
                continue;
            }
            ret.addRetrievalLatest(new TaskSummary(tt.getUid(), tt.getDisplayName(), null, 0, 0));
        }
        List tis = this.taskManager.getAllRTInstances();
        for (TaskInstance ti2 : tis) {
            ret.setrtpTotal(ti2.getDisplayName(), Integer.valueOf(1));
            long numResults = this.resultsManager.getResultsCountForTaskInstance(ti2.getUid());
            size = ti2.getNumDevices();
            ret.addRtpLatest(new TaskSummary(ti2.getUid(), ti2.getDisplayName(), ti2.getCreated(), size, Math.toIntExact(numResults)));
        }
        for (TaskTemplate tt : this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.DATABASE_SEARCH)) {
            ret.setDbTotal(tt.getDisplayName(), Integer.valueOf(tt.getInstanceIds().size()));
            Optional opt2 = this.taskManager.getLatestInstanceForTemplateWhereOneCompleted(tt);
            if (opt2.isPresent()) {
                TaskInstance ti3 = (TaskInstance)opt2.get();
                int numResults = this.dbManager.getResultsCountForTaskInstance(ti3.getUid()).intValue();
                size2 = ti3.getNumberOfJobs();
                ret.addDbLatest(new TaskSummary(ti3.getUid(), tt.getDisplayName(), ti3.getCreated(), size2, numResults));
                continue;
            }
            ret.addDbLatest(new TaskSummary(tt.getUid(), tt.getDisplayName(), null, 0, 0));
        }
        return ret;
    }

    @Transactional(readOnly=true)
    public synchronized DashboardNumbers getDashboardNumbers(int numTopDevices) {
        DashboardNumbers ret = new DashboardNumbers();
        ArrayList<TopDevice> topDevices = new ArrayList<TopDevice>();
        List devices = this.endpointService.getAllDevices(true);
        for (DeviceRegistration dr : devices) {
            StatusTotalAndTopDevice totals;
            List taskIds = this.resultsManager.getLatestInstancesForDeviceWhereJobIsFinished(dr.getDeviceId());
            if (taskIds.isEmpty()) continue;
            Optional opt = this.dashboardNumCache.get(taskIds, dr.getDeviceId());
            if (opt.isEmpty()) {
                totals = this.calculateRecord(taskIds, dr);
                if (totals.isIsEmpty()) continue;
                ret.increment(totals.getStatusTotals());
                topDevices.add(totals.getTopDevice());
                this.dashboardNumCache.put(taskIds, dr.getDeviceId(), totals);
                continue;
            }
            totals = (StatusTotalAndTopDevice)opt.get();
            ret.increment(totals.getStatusTotals());
            topDevices.add(totals.getTopDevice());
        }
        Collections.sort(topDevices);
        ret.setTopDevices(topDevices.subList(0, Math.min(numTopDevices, topDevices.size())));
        return ret;
    }

    private StatusTotalAndTopDevice calculateRecord(List<String> taskIds, DeviceRegistration dr) {
        AtomicLong totalMatches = new AtomicLong();
        HashSet filesWithMatches = new HashSet();
        StatusTotalAndTopDevice ret = new StatusTotalAndTopDevice();
        try (Stream statusStream = this.dpRepo.getStatusAndResultIdFromTaskIdsAndDeviceId(taskIds, dr.getDeviceId());){
            statusStream.forEach(sr -> {
                filesWithMatches.add(sr.getId());
                ret.getStatusTotals().increment(ResultStatus.valueOf((String)sr.getDisplayStatus()), 1L);
                totalMatches.incrementAndGet();
            });
        }
        if (totalMatches.get() > 0L) {
            ret.setIsEmpty(false);
            TopDevice td = ret.getTopDevice();
            td.setDeviceId(dr.getDeviceId());
            td.setDeviceType(dr.getDeviceType());
            td.setDeviceName(dr.hostNameOrCloudHost());
            td.setUsername(dr.getDeviceUserName());
            td.setManagerName(dr.getManagerName());
            td.setTotalFilesWithMatches((long)filesWithMatches.size());
            td.setTotalMatches(totalMatches.get());
        }
        return ret;
    }
}

