/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.classification;

import com.geolang.ascema.endpointclassification.classification.ClassificationStore;
import com.geolang.ascema.endpointclassification.classification.StoreManager;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerevents.ClassificationModelChangedEvent;
import com.geolang.ascema.managerevents.RequestClassificationModelEvent;
import com.geolang.ascema.managerservice.controllers.classification.StoreManagerInstance;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.time.Instant;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClassificationModelSender {
    private static final Logger LOG = Logger.getLogger(ClassificationModelSender.class.getName());
    private final StoreManager mgr = StoreManagerInstance.getInstance().getMgr();
    @Autowired
    private DeviceService deviceService;

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
    }

    @Subscribe
    void onModelChanged(ClassificationModelChangedEvent ev) {
        try {
            byte[] model = this.mgr.getMasterStore().classification().convertToBytesForTransmission();
            for (DeviceRegistration reg : this.deviceService.getAllDevices(false)) {
                if (!reg.isConnected() || !reg.isIsManagedOnThisNode()) continue;
                this.deviceService.sendClassificationModel(reg.getDeviceId(), model);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ClassificationModelSender.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Subscribe
    void onAgentRequestForModel(RequestClassificationModelEvent ev) {
        ClassificationStore cl = this.mgr.getMasterStore().classification();
        Instant ours = Instant.ofEpochSecond(cl.getTimestamp());
        Instant theirs = Instant.ofEpochSecond(ev.getTimestamp());
        Optional opt = this.deviceService.getDeviceFromId(ev.getDeviceId(), true);
        String device = ev.getDeviceId();
        if (opt.isPresent()) {
            device = ((DeviceRegistration)opt.get()).getDeviceDescription();
        }
        if (ours.isBefore(theirs)) {
            LOG.log(Level.WARNING, "Agent {0} has a later version of the model? we have {1} they have {2}", new Object[]{device, ours.toString(), theirs.toString()});
            LOG.log(Level.WARNING, "Doing nothing - delete WORKING_FOLDER/classification folder on the agent if you want to reset this");
        } else if (ours.isAfter(theirs)) {
            LOG.log(Level.INFO, "Sending agent {0} new model, we have {1} they have {2}", new Object[]{device, ours.toString(), theirs.toString()});
            try {
                byte[] model = this.mgr.getMasterStore().classification().convertToBytesForTransmission();
                this.deviceService.sendClassificationModel(ev.getDeviceId(), model);
            }
            catch (IOException ex) {
                Logger.getLogger(ClassificationModelSender.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            LOG.log(Level.INFO, "Device at current model version {0}", device);
        }
    }
}

