/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.classification;

import com.geolang.ascema.endpointclassification.ClassificationLookupInterface;
import com.geolang.ascema.endpointclassification.ClassificationLookupWrapper;
import com.geolang.ascema.endpointclassification.types.TemplateDetails;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerevents.ClassificationModelChangedEvent;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.classification.StoreManagerInstance;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClassificationLookupController {
    private static final System.Logger LOG = System.getLogger(ClassificationLookupController.class.getName());
    private final ClassificationLookupInterface lookup = new ClassificationLookupWrapper(StoreManagerInstance.getInstance().getMgr());
    @Autowired
    private AuditLogService auditLog;

    public List<TemplateDetails> getAllTemplatesExceptUnknown() {
        return this.lookup.getAllTemplatesExceptUnknown();
    }

    public List<String> getTemplateNames() {
        return this.lookup.getTemplateNames();
    }

    public Optional<TemplateDetails> getTrainingData(String classname) {
        return this.lookup.getTrainingData(classname);
    }

    public boolean deleteClassification(String classname, String user) {
        boolean ret = this.lookup.deleteClassification(classname);
        if (ret) {
            MessageBus.getBus().post((Object)new ClassificationModelChangedEvent());
            this.auditLog.logClassificationDeleted(classname, user);
            LOG.log(System.Logger.Level.INFO, "Deleted classification {0}", classname);
        } else {
            LOG.log(System.Logger.Level.WARNING, "Failed to delete classification {0}", classname);
        }
        return ret;
    }
}

