/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers.classification;

import com.geolang.ascema.endpointclassification.ModelCreationInterface;
import com.geolang.ascema.endpointclassification.ModelCreationWrapper;
import com.geolang.ascema.endpointclassification.classification.StoreManager;
import com.geolang.ascema.endpointclassification.types.FileHolder;
import com.geolang.ascema.endpointclassification.types.TrainingResult;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.web.WebFileHolder;
import com.geolang.ascema.managerevents.ClassificationModelChangedEvent;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.classification.StoreManagerInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.SessionScope;

@Component
@SessionScope
public class ClassificationCreationSession {
    private static final Logger LOG = Logger.getLogger(ClassificationCreationSession.class.getName());
    private final StoreManager mgr;
    private final ModelCreationInterface model;
    private final Map<String, FileHolder> holdersCache = new HashMap();
    private String user = "";
    private String className = "";
    @Autowired
    private AuditLogService auditLog;

    public ClassificationCreationSession() {
        this.mgr = StoreManagerInstance.getInstance().getMgr();
        this.model = new ModelCreationWrapper(this.mgr);
    }

    public TrainingResult addTemplate(String name, List<FileHolder> examples, String owner) {
        this.user = owner;
        this.className = name;
        TrainingResult ret = this.model.addTemplate(name, examples, owner);
        if (!ret.isIsSuccess()) {
            LOG.log(Level.WARNING, "Failed to add template {0}", name);
            this.discardChanges();
        } else {
            LOG.log(Level.INFO, "Added template {0}", name);
        }
        return ret;
    }

    public TrainingResult checkTraining(String name, List<FileHolder> candidates) {
        for (FileHolder fh : candidates) {
            this.holdersCache.put(fh.getFileName(), fh);
        }
        return this.model.checkTraining(name, candidates);
    }

    public TrainingResult reTrain(String templateName, List<WebFileHolder> oldFiles, List<WebFileHolder> newFiles) {
        FileHolder fh;
        ArrayList<FileHolder> oldfh = new ArrayList<FileHolder>();
        ArrayList<FileHolder> newfh = new ArrayList<FileHolder>();
        for (WebFileHolder wfh : oldFiles) {
            fh = (FileHolder)this.holdersCache.get(wfh.getName());
            if (fh == null) continue;
            oldfh.add(fh);
        }
        for (WebFileHolder wfh : newFiles) {
            fh = (FileHolder)this.holdersCache.get(wfh.getName());
            if (fh == null) continue;
            newfh.add(fh);
        }
        return this.model.reTrain(templateName, oldfh, newfh);
    }

    public void save() {
        LOG.info("Model saved");
        this.model.save();
        this.holdersCache.clear();
        this.auditLog.logClassificationCreated(this.className, this.user);
        MessageBus.getBus().post((Object)new ClassificationModelChangedEvent());
    }

    public void discardChanges() {
        LOG.info("Model changes discarded");
        this.model.discardChanges();
        this.holdersCache.clear();
    }
}

