/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.endpointcommon.messages.servernotification.ServerNotificationBase;
import com.geolang.ascema.managerservice.controllers.ServerMessagesOutQueue;
import com.geolang.ascema.managerservice.controllers.ServerOutToDeviceListener;
import com.geolang.ascema.managerservice.messaging.serverserver.BaseServerServerMessage;
import com.geolang.ascema.managerservice.messaging.serverserver.MasterEnd;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Service;

@Service
public class ServerMessagesOutQueue {
    private static final Logger LOG = Logger.getLogger(ServerMessagesOutQueue.class.getName());
    @Autowired
    private MasterEnd master;
    private final Map<String, ServerOutToDeviceListener> listeners = new HashMap();
    private final Map<String, List<ServerNotificationBase>> pendingToDevices = new HashMap();
    private final Map<String, List<BaseServerServerMessage>> pendingToServer = new HashMap();
    private final ExecutorService executor = Executors.newFixedThreadPool(4, (ThreadFactory)new CustomizableThreadFactory("ServerMessagesOutQueue-"));

    public void registerCallback(ServerOutToDeviceListener cb, String deviceId) {
        List msgs2;
        this.listeners.put(deviceId, cb);
        List msgs = (List)this.pendingToDevices.get(deviceId);
        if (msgs != null) {
            for (ServerNotificationBase n : msgs) {
                cb.notify(n);
                LOG.log(Level.INFO, "send deferred message {1} to {0}", new Object[]{deviceId, n.getType()});
            }
            this.pendingToDevices.remove(deviceId);
        }
        if (this.master.isRunning() && (msgs2 = (List)this.pendingToServer.get(deviceId)) != null) {
            for (BaseServerServerMessage n : msgs2) {
                this.master.routeMessage(deviceId, n);
                LOG.log(Level.INFO, "send deferred server server message {1} to {0}", new Object[]{deviceId, n.getType()});
            }
            this.pendingToServer.remove(deviceId);
        }
    }

    public void deRegisterCallback(String deviceId) {
        this.listeners.remove(deviceId);
    }

    public void stop() {
        this.executor.shutdown();
    }

    public synchronized Future<Status> sendMessageByte(String deviceId, ServerNotificationBase message, byte[] bytes) {
        return this.executor.submit(() -> {
            ServerOutToDeviceListener listener = (ServerOutToDeviceListener)this.listeners.get(deviceId);
            if (listener != null) {
                listener.notifyByte(message, bytes);
                return Status.SENT;
            }
            return Status.NOT_SENT;
        });
    }

    public synchronized Future<Status> sendMessage(String deviceId, ServerNotificationBase message, boolean saveForLater) {
        return this.executor.submit(() -> {
            boolean sent;
            ServerOutToDeviceListener listener = (ServerOutToDeviceListener)this.listeners.get(deviceId);
            if (listener != null) {
                listener.notify(message);
                return Status.SENT;
            }
            if (this.master.isRunning() && (sent = this.master.routeMessage(deviceId, message))) {
                return Status.SENT;
            }
            if (saveForLater) {
                List list = this.pendingToDevices.getOrDefault(deviceId, new ArrayList());
                list.add(message);
                this.pendingToDevices.put(deviceId, list);
                return Status.PENDING;
            }
            return Status.NOT_SENT;
        });
    }

    public synchronized Future<Status> sendServerServerMessage(String deviceId, BaseServerServerMessage message, boolean saveForLater) {
        return this.executor.submit(() -> {
            boolean sent;
            if (this.master.isRunning() && (sent = this.master.routeMessage(deviceId, message))) {
                return Status.SENT;
            }
            if (saveForLater) {
                List list = this.pendingToServer.getOrDefault(deviceId, new ArrayList());
                list.add(message);
                this.pendingToServer.put(deviceId, list);
                return Status.PENDING;
            }
            return Status.NOT_SENT;
        });
    }
}

