/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.SearchCommand;
import com.geolang.ascema.endpointcommon.domain.searchconfig.UnifiedSearchConfiguration;
import com.geolang.ascema.managerdomain.domain.Schedule;
import com.geolang.ascema.managerdomain.domain.ScheduleType;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerpersistence.ScheduleStore;
import com.geolang.ascema.managerservice.controllers.tasks.JobRunner;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class SchedulingServiceExecutor
implements Job {
    private static final String SCHED_KEY = "sched";
    private static final Logger LOG = Logger.getLogger(SchedulingServiceExecutor.class.getName());
    @Autowired
    @Lazy
    private TaskManager taskManager;
    @Autowired
    private ScheduleStore store;
    @Autowired
    private JobRunner jobRunner;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap datamap = context.getMergedJobDataMap();
        Schedule sched = (Schedule)datamap.get((Object)SCHED_KEY);
        TaskTemplate template = this.taskManager.getTemplateFromId(sched.getTemplateId());
        if (template == null) {
            LOG.log(Level.WARNING, "No template found for scheduled task {0}", sched.getName());
            return;
        }
        boolean resultsWillBePartial = false;
        if (sched.isOnlySinceLastRun() && sched.hasRun()) {
            resultsWillBePartial = true;
            BaseCommand command = template.getBaseCommand();
            if (BaseCommand.getSearchAndKnowledgeBaseCommandTypes().contains(command.getCommandType()) && command instanceof SearchCommand) {
                SearchCommand unif = (SearchCommand)command;
                UnifiedSearchConfiguration config = unif.getConfig();
                config.setNotChangedBefore(sched.getLastRun());
                if (config.getAtlassian() != null && config.getAtlassian().isSearchBitbucket()) {
                    config.getAtlassian().setHistoryFromDateTime(sched.getLastRun().atStartOfDay());
                    config.getAtlassian().setHistoryToDateTime(LocalDateTime.now());
                }
            }
        }
        String instanceName = sched.getName() + "@" + LocalDate.now().toString();
        if (sched.getType().equals((Object)ScheduleType.HOURLY)) {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm");
            instanceName = instanceName + ":" + LocalTime.now().format(dtf);
        }
        if (sched.isRunOnAllDevices()) {
            this.jobRunner.runCommandOnAllDevices(sched.getCreatedBy(), template, instanceName, sched.getPriority(), sched.isAlertAutomatically(), resultsWillBePartial, sched.isOverrideQuietTime());
            LOG.log(Level.INFO, "Scheduled task - run on all devices {0}", sched.getName());
        } else {
            this.jobRunner.runCommandOnDevices(sched.getCreatedBy(), template, instanceName, sched.getPriority(), sched.getDeviceIds(), sched.isAlertAutomatically(), resultsWillBePartial, sched.isOverrideQuietTime());
            LOG.log(Level.INFO, "Scheduled task - run on selected devices {0}", sched.getName());
        }
        sched.setLastRun(LocalDate.now());
        this.store.addOrUpdate(sched);
    }

    public static JobDataMap scheduleToJobDataMap(Schedule sched) {
        JobDataMap data = new JobDataMap();
        data.put(SCHED_KEY, (Object)sched);
        return data;
    }
}

