/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.managerdomain.domain.Schedule;
import com.geolang.ascema.managerpersistence.ScheduleStore;
import com.geolang.ascema.managerservice.controllers.SchedulingService;
import com.geolang.ascema.managerservice.controllers.SchedulingServiceExecutor;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SchedulingService {
    private static final Logger LOG = Logger.getLogger(SchedulingService.class.getName());
    private static final String GROUP = "scheduled tasks";
    private static final String JOBNAME = "jobname";
    @Autowired
    private ScheduleStore store;
    @Autowired
    private Scheduler scheduler;
    private final JobKey jobKey;
    private final Map<Schedule, Set<CronTrigger>> scheduledTasks = new HashMap();

    public SchedulingService() {
        this.jobKey = new JobKey(JOBNAME, GROUP);
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.close();
    }

    private void init() {
        LOG.info("Schedule Jobs");
        try {
            this.scheduler.clear();
        }
        catch (SchedulerException ex) {
            Logger.getLogger(SchedulingService.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (Schedule s : this.store.getAll()) {
            this.scheduleJob(s);
        }
        LOG.log(Level.INFO, "Scheduled {0}", this.scheduledTasks.size());
        this.listjobs();
    }

    private void close() {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException ex) {
            Logger.getLogger(SchedulingService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean addSchedule(Schedule schedule) {
        Optional existedForThisTask = this.cancelJob(schedule.getTemplateId());
        if (existedForThisTask.isPresent() && ((Schedule)existedForThisTask.get()).hasRun()) {
            schedule.setLastRun(((Schedule)existedForThisTask.get()).getLastRun());
            LOG.log(Level.INFO, "{0} is a modification to an existing schedule last run at {1}, not doing a full scan again ", new Object[]{schedule.getName(), ((Schedule)existedForThisTask.get()).getLastRun()});
        }
        this.store.addOrUpdate(schedule);
        this.scheduleJob(schedule);
        if (schedule.isRunNow()) {
            JobDataMap data = SchedulingServiceExecutor.scheduleToJobDataMap((Schedule)schedule);
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(schedule.getName() + "now", GROUP).usingJobData(data).withDescription(schedule.getName() + "now").forJob(this.jobKey).startNow().build();
            try {
                this.scheduleTrigger(trigger);
            }
            catch (SchedulerException ex) {
                Logger.getLogger(SchedulingService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.listjobs();
        return true;
    }

    public boolean removeSchedule(String searchJobTemplateId) {
        this.cancelJob(searchJobTemplateId);
        this.listjobs();
        return this.store.delete(searchJobTemplateId);
    }

    public Optional<Schedule> getScheduleForTemplate(String searchJobTemplateId) {
        for (Schedule s : this.scheduledTasks.keySet()) {
            if (!s.getTemplateId().equals(searchJobTemplateId)) continue;
            return Optional.of(s);
        }
        return Optional.empty();
    }

    public Optional<Schedule> getScheduleForTemplateFromStore(String searchJobTemplateId) {
        return this.store.getScheduleFromTemplateId(searchJobTemplateId);
    }

    private void listjobs() {
        try {
            for (Trigger t : this.scheduler.getTriggersOfJob(this.jobKey)) {
                LOG.log(Level.INFO, "{0}. Next run @ {1}", new Object[]{t.getDescription(), t.getNextFireTime()});
            }
        }
        catch (SchedulerException ex) {
            Logger.getLogger(SchedulingService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String secMinHour(int min, int hour) {
        return "0 " + min + " " + hour;
    }

    private Set<String> cronsByDay(int day, int hour, int min) {
        if (day < 1 || day > 31) {
            LOG.log(Level.WARNING, "Day out of range {0}", day);
            return Collections.emptySet();
        }
        if (day <= 28) {
            return Collections.singleton(this.secMinHour(min, hour) + " " + day + " JAN-DEC ?");
        }
        if (day == 29 || day == 30) {
            HashSet<CallSite> expressions = new HashSet<CallSite>();
            expressions.add((CallSite)((Object)(this.secMinHour(min, hour) + " L FEB ?")));
            expressions.add((CallSite)((Object)(this.secMinHour(min, hour) + " " + day + " JAN,MAR,APR,MAY,JUN,JUL,AUG,SEP,OCT,NOV,DEC ?")));
            return Collections.unmodifiableSet(expressions);
        }
        return Collections.singleton(this.secMinHour(min, hour) + " L * ?");
    }

    private void scheduleJob(Schedule sched) {
        HashSet<Pair> crons = new HashSet<Pair>();
        switch (1.$SwitchMap$com$geolang$ascema$managerdomain$domain$ScheduleType[sched.getType().ordinal()]) {
            case 1: {
                String c = "0 " + sched.getTminute() + " * * * ?";
                crons.add(Pair.of((Object)CronScheduleBuilder.cronSchedule((String)c), (Object)"Hourly"));
                break;
            }
            case 2: {
                String s = "Weekdays";
                crons.add(Pair.of((Object)CronScheduleBuilder.atHourAndMinuteOnGivenDaysOfWeek((int)sched.getThour(), (int)sched.getTminute(), (Integer[])new Integer[]{2, 3, 4, 5, 6}), (Object)s));
                break;
            }
            case 3: {
                String s = "Daily ";
                crons.add(Pair.of((Object)CronScheduleBuilder.dailyAtHourAndMinute((int)sched.getThour(), (int)sched.getTminute()), (Object)s));
                break;
            }
            case 4: {
                for (Object s : this.cronsByDay(sched.getAtday(), sched.getThour(), sched.getTminute())) {
                    crons.add(Pair.of((Object)CronScheduleBuilder.cronSchedule((String)s), (Object)s));
                }
                break;
            }
            case 5: {
                Object s;
                int month = sched.getAtmonth() + 1;
                s = this.secMinHour(sched.getTminute(), sched.getThour()) + " " + sched.getAtday() + " " + month + " ?";
                crons.add(Pair.of((Object)CronScheduleBuilder.cronSchedule((String)s), (Object)s));
                break;
            }
            case 6: {
                int dayOfWeek = sched.getAtdayOfWeek() + 1;
                Integer[] arr = new Integer[]{dayOfWeek};
                String s = "Weekly " + sched.getThour() + ":" + sched.getTminute() + " on day " + dayOfWeek;
                crons.add(Pair.of((Object)CronScheduleBuilder.atHourAndMinuteOnGivenDaysOfWeek((int)sched.getThour(), (int)sched.getTminute(), (Integer[])arr), (Object)s));
            }
        }
        TimeZone tz = sched.getZoneId() != null && !sched.getZoneId().isEmpty() ? TimeZone.getTimeZone(sched.getZoneId()) : TimeZone.getDefault();
        JobDataMap data = SchedulingServiceExecutor.scheduleToJobDataMap((Schedule)sched);
        HashSet<CronTrigger> triggers = new HashSet<CronTrigger>();
        for (Pair pair : crons) {
            CronScheduleBuilder builder = (CronScheduleBuilder)pair.getKey();
            String description = sched.getName() + " " + (String)pair.getRight();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(description, GROUP).withDescription(description).usingJobData(data).forJob(this.jobKey).withSchedule((ScheduleBuilder)builder.inTimeZone(tz).withMisfireHandlingInstructionFireAndProceed()).build();
            triggers.add(trigger);
            try {
                this.scheduleTrigger((Trigger)trigger);
            }
            catch (SchedulerException ex) {
                Logger.getLogger(SchedulingService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        LOG.log(Level.INFO, "Added {0} job {1}", new Object[]{sched.getType(), sched.getName()});
        this.scheduledTasks.put(sched, triggers);
    }

    private synchronized void scheduleTrigger(Trigger trigger) throws SchedulerException {
        JobDetail job = this.scheduler.getJobDetail(this.jobKey);
        if (job == null) {
            job = JobBuilder.newJob(SchedulingServiceExecutor.class).withIdentity(JOBNAME, GROUP).build();
            this.scheduler.scheduleJob(job, trigger);
        } else {
            this.scheduler.scheduleJob(trigger);
        }
    }

    private Optional<Schedule> cancelJob(String templateId) {
        Optional opt = this.store.getScheduleFromTemplateId(templateId);
        if (opt.isPresent()) {
            LOG.info("Cancel scheduled job");
            Set triggers = (Set)this.scheduledTasks.get(opt.get());
            if (triggers != null) {
                for (Trigger t : triggers) {
                    try {
                        this.scheduler.unscheduleJob(t.getKey());
                    }
                    catch (SchedulerException ex) {
                        Logger.getLogger(SchedulingService.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.scheduledTasks.remove(opt.get());
                return opt;
            }
        } else {
            LOG.info("No existing schedule found to delete");
        }
        return Optional.empty();
    }
}

