/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.Job;
import com.geolang.ascema.endpointcommon.domain.JobPriority;
import com.geolang.ascema.endpointcommon.domain.JobState;
import com.geolang.ascema.endpointcommon.domain.RTCommand;
import com.geolang.ascema.endpointcommon.domain.actions.ActionIgnorePaths;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionResult;
import com.geolang.ascema.endpointcommon.domain.searchconfig.rt.RTSearchConfiguration;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.PathCollection;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerservice.controllers.PathCollectionController;
import com.geolang.ascema.managerservice.controllers.ProxySettings;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.tasks.JobRunner;
import com.geolang.ascema.managerservice.controllers.tasks.JobStateUpdater;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.rest.requests.tasks.RTTaskInstance;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class RealTimeProtectionManager {
    private static final Logger LOG = Logger.getLogger(RealTimeProtectionManager.class.getName());
    @Autowired
    @Lazy
    private TaskManager taskManager;
    @Autowired
    @Lazy
    JobStateUpdater jobStateUpdater;
    @Autowired
    @Lazy
    private DeviceService deviceService;
    @Autowired
    private JobRunner jobRunner;
    @Autowired
    private PathCollectionController pathCollectionController;

    public TaskInstance runProtectCommand(String createdBy, String instanceName, RTSearchConfiguration config, List<String> deviceIds, boolean autoAlert, String actionIgnorePathsName) {
        RTCommand com = new RTCommand(config);
        TaskTemplate templ = this.taskManager.getRealTimeProtectTemplate();
        Optional opt = this.pathCollectionController.getByName(actionIgnorePathsName);
        ActionIgnorePaths ignorePaths = null;
        if (opt.isPresent()) {
            ignorePaths = ((PathCollection)opt.get()).toActionIgnorePaths();
        }
        TaskInstance plan = TaskInstance.create((ActionIgnorePaths)ignorePaths, (String)createdBy, (BaseCommand)com, (String)instanceName, (JobPriority)JobPriority.HIGH, (boolean)false, (TaskTemplate)templ, (boolean)autoAlert, (boolean)true);
        plan.setActionIgnorePathsName(actionIgnorePathsName);
        for (String deviceId : deviceIds) {
            Optional reg = this.deviceService.getDeviceFromId(deviceId, false);
            if (reg.isPresent()) {
                this.jobRunner.createJobForDevice(plan, (DeviceRegistration)reg.get());
                continue;
            }
            LOG.log(Level.WARNING, "no device to run protect command {0}", deviceId);
        }
        this.jobRunner.run(templ, plan, true);
        return plan;
    }

    public TaskInstance runProtectCommandOnAllDevices(String createdBy, String instanceName, RTSearchConfiguration config, boolean autoAlert, String actionIgnorePathsName) {
        RTCommand com = new RTCommand(config);
        TaskTemplate templ = this.taskManager.getRealTimeProtectTemplate();
        Optional opt = this.pathCollectionController.getByName(actionIgnorePathsName);
        ActionIgnorePaths ignorePaths = null;
        if (opt.isPresent()) {
            ignorePaths = ((PathCollection)opt.get()).toActionIgnorePaths();
        }
        TaskInstance plan = TaskInstance.create((ActionIgnorePaths)ignorePaths, (String)createdBy, (BaseCommand)com, (String)instanceName, (JobPriority)JobPriority.HIGH, (boolean)true, (TaskTemplate)templ, (boolean)autoAlert, (boolean)true);
        plan.setActionIgnorePathsName(actionIgnorePathsName);
        for (DeviceRegistration reg : this.deviceService.getAllDevices(false)) {
            Set subs;
            DeviceType type = reg.getDeviceType();
            if (!config.jobIsForDeviceType(type, subs = reg.getDeviceSubTypesCollection())) continue;
            this.jobRunner.createJobForDevice(plan, reg);
        }
        this.jobRunner.run(templ, plan, true);
        return plan;
    }

    public boolean deleteTask(String userName, String instanceId) {
        Optional opt = this.taskManager.getTaskInstanceFromId(instanceId);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "Failed to find instance to delete {0}", instanceId);
            return false;
        }
        for (String devId : ((TaskInstance)opt.get()).getDeviceIds()) {
            this.taskManager.cancelJob(instanceId, devId);
        }
        this.taskManager.deleteTaskInstance(userName, instanceId);
        return true;
    }

    public Optional<TaskInstance> startDevice(String instanceId, String deviceId) {
        this.jobStateUpdater.updateJobState(instanceId, deviceId, JobState.NOT_STARTED, Optional.empty(), "", ActionResult.createEmptyResult());
        return this.addDeviceToTask(instanceId, deviceId);
    }

    public TaskInstance stopDevice(String instanceId, String deviceId) {
        Optional opt = this.taskManager.getTaskInstanceFromId(instanceId);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "Failed to find instance from id {0}", instanceId);
            return null;
        }
        TaskInstance instance = (TaskInstance)opt.get();
        this.taskManager.pauseJob(instanceId, deviceId, false);
        return instance;
    }

    public TaskInstance updateDevices(RTTaskInstance com) {
        Optional opt = this.taskManager.getTaskInstanceFromId(com.getId());
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "Failed to find instance from id {0}", com);
            return null;
        }
        TaskInstance instance = (TaskInstance)opt.get();
        RTCommand command = (RTCommand)instance.getCommand();
        if (com.isRunOnAllDevices()) {
            for (DeviceRegistration reg : this.deviceService.getAllDevices(false)) {
                DeviceType type = reg.getDeviceType();
                Set subs = reg.getDeviceSubTypesCollection();
                if (!command.getConfig().jobIsForDeviceType(type, subs) || instance.hasExistingJobForDevice(reg.getDeviceId())) continue;
                Job j = this.jobRunner.createJobForDevice(instance, reg);
                this.deviceService.informJobAvailable(reg.getDeviceId(), Collections.singletonList(j), ProxySettings.getUIDetails((String)reg.getDeviceId()));
            }
        } else {
            if (com.getDeviceIds() == null) {
                com.setDeviceIds(Collections.emptyList());
            }
            for (String newDevId : com.getDeviceIds()) {
                Optional reg = this.deviceService.getDeviceFromId(newDevId, false);
                if (instance.hasExistingJobForDevice(newDevId) || !reg.isPresent()) continue;
                Job j = this.jobRunner.createJobForDevice(instance, (DeviceRegistration)reg.get());
                this.deviceService.informJobAvailable(newDevId, Collections.singletonList(j), ProxySettings.getUIDetails((String)newDevId));
            }
            for (String deviceId : instance.getDeviceIds()) {
                if (com.getDeviceIds().contains(deviceId)) continue;
                this.taskManager.cancelJob(com.getId(), deviceId);
            }
        }
        instance.setRunOnallDevices(com.isRunOnAllDevices());
        this.taskManager.updateInstance(instance);
        return instance;
    }

    public Optional<TaskInstance> addDeviceToTask(String instanceId, String deviceId) {
        Job j;
        Optional opt = this.taskManager.getTaskInstanceFromId(instanceId);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "Failed to find instance from id {0}", instanceId);
            return null;
        }
        TaskInstance instance = (TaskInstance)opt.get();
        Optional tiOpt = instance.getExistingJob(deviceId);
        if (tiOpt.isPresent()) {
            j = (Job)tiOpt.get();
            LOG.log(Level.WARNING, "Adding device to task but already has that device {0}", deviceId);
        } else {
            Optional reg = this.deviceService.getDeviceFromId(deviceId, false);
            if (reg.isEmpty()) {
                LOG.log(Level.WARNING, "no device to add device to task {0}", deviceId);
                return Optional.empty();
            }
            j = this.jobRunner.createJobForDevice(instance, (DeviceRegistration)reg.get());
        }
        this.deviceService.informJobAvailable(deviceId, Collections.singletonList(j), ProxySettings.getUIDetails((String)deviceId));
        this.taskManager.updateInstance(instance);
        return Optional.of(instance);
    }

    public TaskInstance removeDeviceFromTask(String instanceId, String deviceId) {
        Optional opt = this.taskManager.getTaskInstanceFromId(instanceId);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "Failed to find instance from id {0}", instanceId);
            return null;
        }
        TaskInstance instance = (TaskInstance)opt.get();
        if (!instance.hasExistingJobForDevice(deviceId)) {
            LOG.log(Level.WARNING, "device not on task {0} can't remove", deviceId);
        }
        this.taskManager.cancelJob(instanceId, deviceId);
        this.taskManager.updateInstance(instance);
        return instance;
    }

    public Optional<TaskInstance> renameTask(String instanceId, String newName) {
        Optional opt = this.taskManager.getTaskInstanceFromId(instanceId);
        if (!opt.isPresent()) {
            LOG.log(Level.WARNING, "Failed to find instance to rename {0}", instanceId);
            return Optional.empty();
        }
        TaskTemplate templ = this.taskManager.getRealTimeProtectTemplate();
        for (TaskInstance ti : this.taskManager.getAllInstancesForTemplate(templ.getUid())) {
            if (!ti.getDisplayName().equals(newName)) continue;
            LOG.log(Level.WARNING, "can''t rename - name already exists {0}", newName);
            return Optional.empty();
        }
        TaskInstance ret = (TaskInstance)opt.get();
        ret.setDisplayName(newName);
        this.taskManager.updateInstance(ret);
        return Optional.of(ret);
    }
}

