/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.endpointcommon.messages.servernotification.ServerUIDetails;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.messaging.JMSManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ProxySettings {
    private static final Logger LOG = Logger.getLogger(ProxySettings.class.getName());
    private static final SettingsFile settings = SettingsFile.getInstance();
    @Lazy
    @Autowired
    private JMSManager jmsManager;
    @Lazy
    @Autowired
    private DeviceService endpointService;

    public static ServerUIDetails getUIDetails(String deviceId) {
        return new ServerUIDetails(ProxySettings.getProtocol(), ProxySettings.getHost(), Integer.toString(ProxySettings.getPort()), settings.getIndividualReportsUrl(), settings.getO365ReportsUrl(), settings.getAtlassianReportsUrl(), settings.getGoogleReportsUrl(), deviceId);
    }

    public static int getPort() {
        if (settings.getUISSL() && !settings.getProxyChanged()) {
            settings.setProxyUIPort(settings.getUISSLPort());
            settings.getUISSLPort();
        }
        if (!settings.getUISSL() && !settings.getProxyChanged()) {
            settings.getUIPort();
        }
        return settings.getProxyUIPort();
    }

    public void setPort(int port) {
        LOG.log(Level.INFO, "Set Proxy UI Port {0}", port);
        settings.setProxyUIPort(port);
        this.updateToUI();
    }

    public static String getProtocol() {
        if (settings.getUISSL() && !settings.getProxyChanged()) {
            return "https://";
        }
        if (!settings.getUISSL() && !settings.getProxyChanged()) {
            return "http://";
        }
        return settings.getUIProtocol();
    }

    public void setProtocol(String protocol) {
        LOG.log(Level.INFO, "Set UI Protocol {0}", protocol);
        settings.setUIProtocol(protocol);
        this.updateToUI();
    }

    public static String getHost() {
        return settings.getUIHost();
    }

    public void setHost(String host) {
        LOG.log(Level.INFO, "Set UI Host {0}", host);
        settings.setUIHost(host);
        this.updateToUI();
    }

    public static boolean getPrimaryIsMainUI() {
        return settings.getPrimaryIsMainUI();
    }

    public boolean setPrimaryIsMainUI(@RequestParam(value="main") boolean main) {
        settings.setPrimaryIsMainUI(main);
        this.updateToUI();
        return true;
    }

    private void updateToUI() {
        this.jmsManager.updateToUI();
        this.endpointService.useLocallySetUI();
        settings.setProxyChanged(true);
    }
}

