/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.endpointcommon.domain.actions.ActionIgnorePaths;
import com.geolang.ascema.endpointcommon.domain.actions.HostAndPath;
import com.geolang.ascema.managerdomain.domain.PathCollection;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.web.importexport.PathCollectionExport;
import com.geolang.ascema.managerpersistence.PathCollectionStore;
import com.geolang.ascema.managerpersistence.TaskStore;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PathCollectionController {
    private static final Logger LOG = Logger.getLogger(PathCollectionController.class.getName());
    @Autowired
    private PathCollectionStore pathStore;
    @Autowired
    private TaskStore taskStore;
    private final ExecutorService startupExecutor = Executors.newSingleThreadExecutor();

    @PostConstruct
    public void init() {
        this.startupExecutor.submit(() -> this.initInstances());
    }

    @PreDestroy
    public void destroy() {
        this.startupExecutor.shutdownNow();
    }

    private void initInstances() {
        for (TaskTemplate tt : this.taskStore.getAllNonEphemeralTemplates()) {
            if (tt.getActionIgnorePathsName() == null || tt.getActionIgnorePathsName().isEmpty()) continue;
            this.setActionIgnorePathsOntoAllInstances(tt);
        }
        this.setActionIgnorePathsForRT();
    }

    public Iterable<PathCollection> getAllLists() {
        return this.pathStore.getAllLists();
    }

    public Optional<PathCollection> getByName(String name) {
        return this.pathStore.getByName(name);
    }

    public boolean existsByName(String name) {
        return this.getByName(name).isPresent();
    }

    public void deleteByName(String name) {
        this.pathStore.deleteByName(name);
    }

    public PathCollection createOrUpdate(String name, String createdBy, SortedSet<HostAndPath> paths) {
        boolean isUpdate = this.existsByName(name);
        PathCollection ret = this.pathStore.createOrUpdate(name, createdBy, paths);
        if (isUpdate) {
            ActionIgnorePaths aip = ret.toActionIgnorePaths();
            for (TaskTemplate tt : this.taskStore.getAllNonEphemeralTemplates()) {
                if (tt.getActionIgnorePathsName() == null || !tt.getActionIgnorePathsName().equals(name)) continue;
                LOG.log(Level.INFO, "Update ignore paths for instances of template {0}", tt.getDisplayName());
                for (TaskInstance ti : this.taskStore.getAllInstancesForTemplate(tt.getUid())) {
                    ti.setIgnorePaths(aip);
                }
            }
            for (TaskInstance ti : this.taskStore.getAllRTInstances()) {
                if (ti.getActionIgnorePathsName() == null || !ti.getActionIgnorePathsName().equals(name)) continue;
                LOG.log(Level.INFO, "Update ignore paths for rt task {0}", ti.getDisplayName());
                ti.setIgnorePaths(aip);
            }
        }
        return ret;
    }

    public Optional<PathCollection> getIgnorePathsForTemplate(TaskTemplate t) {
        return this.pathStore.getIgnorePathsCollectionFromIgnorePathName(t.getActionIgnorePathsName());
    }

    public List<PathCollectionExport> getAllForExport() {
        return this.pathStore.getAllForExport();
    }

    public Optional<TaskTemplate> setTemplateActionIgnorePathsName(String templateId, String pathCollectionName) {
        TaskTemplate existing = this.taskStore.getTemplateFromId(templateId);
        if (existing == null) {
            LOG.log(Level.WARNING, "template not found to associate {0}", templateId);
            return Optional.empty();
        }
        this.updateActionIgnorePathName(existing, pathCollectionName);
        if (pathCollectionName == null || pathCollectionName.isEmpty()) {
            LOG.log(Level.INFO, "clear ignore path {0} on search template {1}", new Object[]{pathCollectionName, existing.getDisplayName()});
        } else {
            LOG.log(Level.INFO, "set ignore path {0} on search template {1}", new Object[]{pathCollectionName, existing.getDisplayName()});
        }
        return Optional.of(existing);
    }

    public Optional<TaskInstance> setInstanceActionIgnorePathsName(String inst, String pathCollectionName) {
        Optional existing = this.taskStore.getTaskInstanceFromId(inst);
        if (existing.isEmpty()) {
            LOG.log(Level.WARNING, "instance not found to associate {0}", inst);
            return Optional.empty();
        }
        this.updateActionIgnorePathName((TaskInstance)existing.get(), pathCollectionName);
        if (pathCollectionName == null || pathCollectionName.isEmpty()) {
            LOG.log(Level.INFO, "clear ignore path {0} on rt instance {1}", new Object[]{pathCollectionName, ((TaskInstance)existing.get()).getDisplayName()});
        } else {
            LOG.log(Level.INFO, "set ignore path {0} on rt instance {1}", new Object[]{pathCollectionName, ((TaskInstance)existing.get()).getDisplayName()});
        }
        return existing;
    }

    public void updateActionIgnorePathName(TaskTemplate existing, String pathCollectionName) {
        existing.setActionIgnorePathsName(pathCollectionName);
        this.setActionIgnorePathsOntoAllInstances(existing);
        this.taskStore.update(existing);
    }

    public void updateActionIgnorePathName(TaskInstance existing, String pathCollectionName) {
        existing.setActionIgnorePathsName(pathCollectionName);
        Optional opt = this.pathStore.getIgnorePathsCollectionFromIgnorePathName(pathCollectionName);
        if (opt.isPresent()) {
            existing.setIgnorePaths(((PathCollection)opt.get()).toActionIgnorePaths());
        } else {
            existing.setIgnorePaths(new ActionIgnorePaths());
        }
        this.taskStore.update(existing);
    }

    private void setActionIgnorePathsOntoAllInstances(TaskTemplate templ) {
        Optional opt = this.pathStore.getIgnorePathsCollectionFromIgnorePathName(templ.getActionIgnorePathsName());
        if (opt.isPresent()) {
            ActionIgnorePaths ip = ((PathCollection)opt.get()).toActionIgnorePaths();
            for (TaskInstance inst : this.taskStore.getAllInstancesForTemplate(templ.getUid())) {
                inst.setIgnorePaths(ip);
            }
        } else {
            for (TaskInstance inst : this.taskStore.getAllInstancesForTemplate(templ.getUid())) {
                inst.setIgnorePaths(new ActionIgnorePaths());
            }
        }
    }

    private void setActionIgnorePathsForRT() {
        for (TaskInstance inst : this.taskStore.getAllRTInstances()) {
            Optional opt = this.pathStore.getIgnorePathsCollectionFromIgnorePathName(inst.getActionIgnorePathsName());
            if (opt.isPresent()) {
                inst.setIgnorePaths(((PathCollection)opt.get()).toActionIgnorePaths());
                continue;
            }
            inst.setIgnorePaths(new ActionIgnorePaths());
        }
    }
}

