/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerdomain.web.SMTPSettings;
import com.sun.mail.util.MailSSLSocketFactory;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class MailSender {
    private static final Logger LOG = Logger.getLogger(MailSender.class.getName());
    private static String lastErrorMessage;

    public static boolean send(SMTPSettings settings, String recipientEmail, String title, String message) {
        return MailSender.send((SMTPSettings)settings, (String)recipientEmail, (String)title, (String)message, (String)"");
    }

    public static boolean send(SMTPSettings settings, String recipientEmail, String title, String message, String htmlmessage) {
        try {
            String smtpHost = settings.getHost();
            int smtpPort = settings.getPort();
            String user = settings.getUser();
            String from = settings.getFromEmail();
            if (!SettingsFile.getInstance().getSMTPAlertFromOverride().isEmpty()) {
                from = SettingsFile.getInstance().getSMTPAlertFromOverride();
            }
            String pwd = settings.getPwd();
            Boolean useSSL = settings.isUseSSL();
            Boolean useStartSSL = settings.isUseStartSSL();
            Boolean authenticate = !user.isBlank() && !pwd.isBlank();
            String protocol = settings.getProtocol();
            String ccEmail = settings.getCcEmail();
            boolean isSmtps = protocol.equals("smtps");
            if (smtpHost.isEmpty()) {
                lastErrorMessage = "No host set";
                LOG.warning("Can't send mail message - no smpt host");
                return false;
            }
            if (smtpPort == 0) {
                lastErrorMessage = "No port set";
                LOG.warning("Can't send mail message - no port");
                return false;
            }
            Properties props = System.getProperties();
            MailSSLSocketFactory sslSocketFactory = new MailSSLSocketFactory("TLSv1.2");
            sslSocketFactory.setTrustAllHosts(true);
            props.put("mail." + protocol + ".ssl.socketFactory", sslSocketFactory);
            props.put("mail.transport.protocol", protocol);
            props.setProperty("mail." + protocol + ".host", smtpHost);
            props.setProperty("mail." + protocol + ".port", Integer.toString(smtpPort));
            props.setProperty("mail." + protocol + ".ssl.enable", useSSL.toString());
            props.setProperty("mail." + protocol + ".starttls.enable", useStartSSL.toString());
            if (authenticate.booleanValue()) {
                props.setProperty("mail." + protocol + ".auth", Boolean.toString(useSSL != false || useStartSSL != false || isSmtps));
            } else {
                props.setProperty("mail." + protocol + ".auth", "false");
            }
            if (useSSL.booleanValue() || useStartSSL.booleanValue() || isSmtps) {
                props.setProperty("mail." + protocol + ".ssl.trust", smtpHost);
            }
            Session session = Session.getInstance((Properties)props);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipientEmail, (boolean)false));
            if (ccEmail.length() > 0) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)ccEmail, (boolean)false));
            }
            msg.setSubject(title);
            if (htmlmessage != null && !htmlmessage.isEmpty()) {
                msg.setContent((Object)htmlmessage, "text/html");
            } else {
                msg.setText(message, "utf-8");
            }
            msg.setSentDate(new Date());
            try (Transport t = session.getTransport();){
                if (authenticate.booleanValue()) {
                    t.connect(smtpHost, user, pwd);
                } else {
                    t.connect();
                }
                t.sendMessage((Message)msg, msg.getAllRecipients());
            }
            return true;
        }
        catch (AddressException ex) {
            lastErrorMessage = ex.toString();
            LOG.log(Level.WARNING, "Failed to send message - adressing error {0}", lastErrorMessage);
        }
        catch (MessagingException ex) {
            lastErrorMessage = ex.toString();
            LOG.log(Level.WARNING, "Failed to send message - messaging error {0}", lastErrorMessage);
        }
        catch (GeneralSecurityException ex) {
            lastErrorMessage = ex.toString();
            LOG.log(Level.WARNING, "Failed to send message - ssl error {0}", lastErrorMessage);
        }
        return false;
    }

    public static SMTPSettings getStoredSettings() {
        SettingsFile settings = SettingsFile.getInstance();
        SMTPSettings ret = new SMTPSettings();
        ret.setCcEmail(settings.getSMTPAlertCC());
        ret.setFromEmail(settings.getSMTPAlertFrom());
        ret.setHost(settings.getSMTPHost());
        ret.setPort(settings.getSMTPPort());
        ret.setProtocol(settings.getSMTPProt());
        ret.setPwd(settings.getSMTPPwd());
        ret.setUseSSL(settings.getUseSMTPSSL());
        ret.setUseStartSSL(settings.getUseSMTPStartSSL());
        ret.setUser(settings.getSMTPUser());
        return ret;
    }

    public static String getLastErrorMessage() {
        return lastErrorMessage;
    }
}

