/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.EmbeddingResult;
import com.geolang.ascema.endpointcommon.domain.KnowledgeBaseSearchCommand;
import com.geolang.ascema.knowledgebase.controllers.EmbeddingStoreManager;
import com.geolang.ascema.knowledgebase.controllers.KnowledgeBaseResponse;
import com.geolang.ascema.knowledgebase.filters.DateFilter;
import com.geolang.ascema.knowledgebase.filters.FilterParser;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerevents.JobStateChangeEvent;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.SchedulingService;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.rest.requests.tasks.KnowledgeBaseSearchJobTemplate;
import com.geolang.ascema.managerservice.rest.security.UserStore;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeBaseController
implements InitializingBean {
    private static final System.Logger LOG = System.getLogger(KnowledgeBaseController.class.getName());
    @Autowired
    private SchedulingService scheduler;
    @Autowired
    private PatternService patternService;
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private AuditLogService auditLog;
    private EmbeddingStoreManager embeddings = null;

    private synchronized EmbeddingStoreManager getEmbeddingsManager() {
        if (this.embeddings == null) {
            this.embeddings = new EmbeddingStoreManager(WorkingFolder.getChatFolder());
        }
        return this.embeddings;
    }

    private boolean enabled() {
        return SettingsFile.getInstance().getKBaseEnabled();
    }

    public void afterPropertiesSet() throws Exception {
        MessageBus.getBus().register((Object)this);
        ArrayList all = this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.KNOWLEDGEBASE_SEARCH);
        if (!all.isEmpty()) {
            HashSet<String> tasksWithCompletedInstances = new HashSet<String>();
            block0: for (TaskTemplate t : all) {
                List instances = this.taskManager.getAllInstancesForTemplate(t.getUid());
                for (TaskInstance inst : instances) {
                    if (!inst.allDone()) continue;
                    tasksWithCompletedInstances.add(t.getUid());
                    continue block0;
                }
            }
            EmbeddingStoreManager manager = this.getEmbeddingsManager();
            manager.init(tasksWithCompletedInstances);
        }
    }

    public void addDocument(EmbeddingResult res) {
        if (!this.enabled()) {
            LOG.log(System.Logger.Level.WARNING, "Call to addDocument when KBase not enabled");
            return;
        }
        Optional opt = this.taskManager.getTaskInstanceFromId(res.getJobId());
        if (opt.isPresent()) {
            boolean partial = ((TaskInstance)opt.get()).isPartialResults();
            this.getEmbeddingsManager().addDocument(res, partial);
        }
    }

    public List<KnowledgeBaseResponse> getMatchingDocuments(Authentication auth, String taskName, String searchQuery, int numResults, DateFilter dateFilter) {
        if (!this.enabled()) {
            LOG.log(System.Logger.Level.WARNING, "Call to getMatchingDocuments when KBase not enabled");
            return Collections.emptyList();
        }
        String user = (String)auth.getPrincipal();
        if (user == null) {
            user = "Anon";
        }
        this.auditLog.logKnowledgeBaseSearch(searchQuery, user);
        for (TaskTemplate tt : this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.KNOWLEDGEBASE_SEARCH)) {
            if (!tt.getDisplayName().equals(taskName) || !this.checkSecurity(tt, auth)) continue;
            Optional expOpt = FilterParser.toExpression((DateFilter)dateFilter);
            return this.getEmbeddingsManager().getMatchingDocuments(tt.getUid(), searchQuery, numResults, expOpt);
        }
        LOG.log(System.Logger.Level.WARNING, "No knowledgebase task found called {0}", taskName);
        return Collections.emptyList();
    }

    public boolean deleteInstance(String name, String instanceId) {
        if (!this.enabled()) {
            LOG.log(System.Logger.Level.WARNING, "Call to deleteInstance when KBase not enabled");
            return false;
        }
        Optional inst = this.taskManager.getTaskInstanceFromId(instanceId);
        if (inst.isPresent()) {
            String templateId = ((TaskInstance)inst.get()).getParentTemplateId();
            boolean ret = this.taskManager.deleteTaskInstance(name, instanceId);
            if (ret) {
                TaskTemplate template = this.taskManager.getTemplateFromId(templateId);
                if (template.getInstanceIds().isEmpty()) {
                    LOG.log(System.Logger.Level.INFO, "template has no instances, delete model");
                    this.getEmbeddingsManager().deleteModel(name, templateId);
                }
                return true;
            }
        }
        return false;
    }

    public boolean deleteModel(String name, String searchJobTemplateId) {
        if (!this.enabled()) {
            LOG.log(System.Logger.Level.WARNING, "Call to deleteModel when KBase not enabled");
            return false;
        }
        this.taskManager.deleteTemplate(name, searchJobTemplateId);
        return this.getEmbeddingsManager().deleteModel(name, searchJobTemplateId);
    }

    @Subscribe
    public void handleJobChange(JobStateChangeEvent ev) {
        TaskInstance inst;
        Optional opt;
        if (!this.enabled()) {
            LOG.log(System.Logger.Level.WARNING, "Call to handleJobChange when KBase not enabled");
            return;
        }
        if (ev.getState().ranToCompletion() && (opt = this.taskManager.getTaskInstanceFromId(ev.getTaskInstanceId())).isPresent() && (inst = (TaskInstance)opt.get()).getCommandType().equals((Object)BaseCommand.CommandType.KNOWLEDGEBASE_SEARCH)) {
            this.getEmbeddingsManager().save(inst.getParentTemplateId());
        }
    }

    public List<KnowledgeBaseSearchJobTemplate> getAllTemplates(Authentication auth) {
        if (!this.enabled()) {
            LOG.log(System.Logger.Level.WARNING, "Call to getAllTemplates when KBase not enabled");
            return Collections.emptyList();
        }
        ArrayList<KnowledgeBaseSearchJobTemplate> ret = new ArrayList<KnowledgeBaseSearchJobTemplate>();
        ArrayList jps = this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.KNOWLEDGEBASE_SEARCH);
        for (TaskTemplate jp : jps) {
            if (!this.checkSecurity(jp, auth)) continue;
            Date lastRan = this.taskManager.getLastRanOrNull(jp.getUid());
            KnowledgeBaseSearchCommand com = (KnowledgeBaseSearchCommand)jp.getBaseCommand();
            KnowledgeBaseSearchJobTemplate sjt = new KnowledgeBaseSearchJobTemplate(com.isIsPublic(), jp, this.scheduler, this.patternService, lastRan);
            ret.add(sjt);
        }
        return ret;
    }

    public KnowledgeBaseSearchJobTemplate getTemplate(Authentication auth, String templateId) {
        if (!this.enabled()) {
            LOG.log(System.Logger.Level.WARNING, "Call to getTemplate when KBase not enabled");
            return null;
        }
        TaskTemplate tt = this.taskManager.getTemplateFromId(templateId);
        if (tt != null && this.checkSecurity(tt, auth)) {
            Date lastRan = this.taskManager.getLastRanOrNull(tt.getUid());
            KnowledgeBaseSearchCommand com = (KnowledgeBaseSearchCommand)tt.getBaseCommand();
            return new KnowledgeBaseSearchJobTemplate(com.isIsPublic(), tt, this.scheduler, this.patternService, lastRan);
        }
        return null;
    }

    public boolean setTemplatePublic(String templateId, boolean toset) {
        if (!this.enabled()) {
            LOG.log(System.Logger.Level.WARNING, "Call to setTemplatePublic when KBase not enabled");
            return false;
        }
        TaskTemplate tt = this.taskManager.getTemplateFromId(templateId);
        if (tt != null) {
            KnowledgeBaseSearchCommand com = (KnowledgeBaseSearchCommand)tt.getBaseCommand();
            com.setIsPublic(toset);
            tt.replaceCommand((BaseCommand)com);
            this.taskManager.updateTemplate(tt);
            return true;
        }
        return false;
    }

    private boolean checkSecurity(TaskTemplate tt, Authentication auth) {
        KnowledgeBaseSearchCommand com = (KnowledgeBaseSearchCommand)tt.getBaseCommand();
        if (com.isIsPublic()) {
            return true;
        }
        return auth != null && auth.isAuthenticated() && !auth.getPrincipal().equals("anonymousUser") && !UserStore.isAnonymousRole((Collection)auth.getAuthorities()) && UserStore.hasBasicOrAdminRole((Collection)auth.getAuthorities());
    }
}

