/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.geolang.ascema.domainmodelpublic.pattern.SpecialPatternType;
import com.geolang.ascema.endpointcommon.database.DatabaseCredentials;
import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.RTCommand;
import com.geolang.ascema.endpointcommon.domain.actions.ActionIgnorePaths;
import com.geolang.ascema.endpointcommon.domain.actions.HostAndPath;
import com.geolang.ascema.endpointcommon.domain.serialiisation.CommandSerialiser;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.CloudCredentials;
import com.geolang.ascema.managerdomain.domain.CloudCredentialStored;
import com.geolang.ascema.managerdomain.domain.DatabaseCredentialStored;
import com.geolang.ascema.managerdomain.domain.PathCollection;
import com.geolang.ascema.managerdomain.domain.SavedCompoundPattern;
import com.geolang.ascema.managerdomain.domain.SavedPath;
import com.geolang.ascema.managerdomain.domain.SavedPattern;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.web.importexport.ClassificationLabelExport;
import com.geolang.ascema.managerdomain.web.importexport.ContextWordExport;
import com.geolang.ascema.managerdomain.web.importexport.CredentialsExport;
import com.geolang.ascema.managerdomain.web.importexport.DatabaseCredentialsExport;
import com.geolang.ascema.managerdomain.web.importexport.FileExtExport;
import com.geolang.ascema.managerdomain.web.importexport.ImportExportFormat;
import com.geolang.ascema.managerdomain.web.importexport.PathCollectionExport;
import com.geolang.ascema.managerdomain.web.importexport.PatternExport;
import com.geolang.ascema.managerdomain.web.importexport.PatternIgnoreExport;
import com.geolang.ascema.managerdomain.web.importexport.RTTaskInstanceExport;
import com.geolang.ascema.managerdomain.web.importexport.TaskTemplateExport;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerpersistence.CloudCredentialsStore;
import com.geolang.ascema.managerpersistence.ContextWordStore;
import com.geolang.ascema.managerpersistence.DatabaseCredentialsStore;
import com.geolang.ascema.managerpersistence.FileExtensionExistsException;
import com.geolang.ascema.managerpersistence.FileExtensionStore;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.ImportExportService;
import com.geolang.ascema.managerservice.controllers.PathCollectionController;
import com.geolang.ascema.managerservice.controllers.RealTimeProtectionManager;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.controllers.results.ignore.PatternIgnoreController;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ImportExportService {
    private static final Logger LOG = Logger.getLogger(ImportExportService.class.getName());
    @Autowired
    @Lazy
    TaskManager taskManager;
    @Autowired
    @Lazy
    PatternService patternService;
    @Autowired
    @Lazy
    RealTimeProtectionManager rtManager;
    @Autowired
    @Lazy
    FileExtensionStore extStore;
    @Autowired
    @Lazy
    AuditLogService auditLog;
    @Autowired
    @Lazy
    CloudCredentialsStore credentialsStore;
    @Autowired
    @Lazy
    DatabaseCredentialsStore dbcredentialsStore;
    @Autowired
    @Lazy
    PathCollectionController ignorePathsController;
    @Autowired
    @Lazy
    PatternIgnoreController patternIgnoreController;
    @Autowired
    @Lazy
    ContextWordStore contextWordStore;
    @Autowired
    @Lazy
    ClassificationLabelStore classificationLabelStore;

    public ImportExportFormat getAllToExport() {
        ImportExportFormat ret = new ImportExportFormat();
        ret.setPatterns(this.patternService.getAllForExport());
        ret.setRealtime(this.taskManager.getAllRTInstances().stream().map(a -> new RTTaskInstanceExport(a)).collect(Collectors.toList()));
        ret.setRetrieval(this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.RETRIEVAL).stream().map(a -> new TaskTemplateExport(a)).collect(Collectors.toList()));
        ret.setSearch(this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.UNIFIED_SEARCH).stream().map(a -> new TaskTemplateExport(a)).collect(Collectors.toList()));
        ret.setDatabase(this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.DATABASE_SEARCH).stream().map(a -> new TaskTemplateExport(a)).collect(Collectors.toList()));
        ret.setKnowledgebase(this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.KNOWLEDGEBASE_SEARCH).stream().map(a -> new TaskTemplateExport(a)).collect(Collectors.toList()));
        ret.setExtensions(this.extStore.getAddedExtensions().stream().map(a -> new FileExtExport(a)).collect(Collectors.toList()));
        ret.setCredentials(this.credentialsStore.getAllForExport());
        ret.setDbCredentials(this.dbcredentialsStore.getAllForExport());
        ret.setIgnorePaths(this.ignorePathsController.getAllForExport());
        ret.setPatternIgnores(this.patternIgnoreController.getAllForExport());
        ret.setContextWords(this.contextWordStore.getAllForExport());
        ret.setClassificationLabels(this.classificationLabelStore.getAllForExport());
        return ret;
    }

    public String exportToString(String actor, ImportExportFormat format) {
        this.auditLog.exportDone(actor);
        try {
            ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
            return mapper.writeValueAsString((Object)format);
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(ImportExportService.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    public Optional<ImportExportFormat> fullImportFromString(String in) {
        try {
            ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
            ImportExportFormat ret = (ImportExportFormat)mapper.readValue(in, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (ret != null) {
                return Optional.of(ret);
            }
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(ImportExportService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Optional.empty();
    }

    public ImportExportFormat importSelected(String actor, ImportExportFormat in) {
        String patName;
        Object stored;
        Object name;
        TaskTemplate retT;
        BaseCommand command;
        Object name2;
        this.auditLog.importDone(actor);
        ImportExportFormat ret = new ImportExportFormat();
        for (TaskTemplateExport tt : in.getSearch()) {
            if (tt.getSerVersion().equals("1")) {
                LOG.log(Level.WARNING, "Import too old to migrate search task {0}", tt.getDisplayName());
                continue;
            }
            name2 = tt.getDisplayName();
            if (this.taskManager.templateExists(tt.getDisplayName())) {
                name2 = this.renameTask(tt.getDisplayName());
                LOG.log(Level.INFO, "Rename search task {0} to {1}", new Object[]{tt.getDisplayName(), name2});
            }
            command = CommandSerialiser.fromByteArray((byte[])tt.getCommand());
            retT = this.taskManager.addTemplate(actor, command, (String)name2, tt.getPriority(), tt.isAlertAutomatically(), tt.getIgnorePathsCollectionName());
            ret.addSearchTemplate(new TaskTemplateExport(retT));
            LOG.log(Level.INFO, "Import search task {0}", name2);
        }
        for (TaskTemplateExport tt : in.getRetrieval()) {
            if (tt.getSerVersion().equals("1")) {
                LOG.log(Level.WARNING, "Import too old to migrate search task {0}", tt.getDisplayName());
                continue;
            }
            name2 = tt.getDisplayName();
            if (this.taskManager.templateExists(tt.getDisplayName())) {
                name2 = this.renameTask(tt.getDisplayName());
                LOG.log(Level.INFO, "Rename retrieval task {0} to {1}", new Object[]{tt.getDisplayName(), name2});
            }
            command = CommandSerialiser.fromByteArray((byte[])tt.getCommand());
            retT = this.taskManager.addTemplate(actor, command, (String)name2, tt.getPriority(), tt.isAlertAutomatically(), "");
            ret.addRetrievalTemplate(new TaskTemplateExport(retT));
            LOG.log(Level.INFO, "Import retrieval task {0}", name2);
        }
        for (TaskTemplateExport tt : in.getDatabase()) {
            if (tt.getSerVersion().equals("1")) {
                LOG.log(Level.WARNING, "Import too old to migrate database task {0}", tt.getDisplayName());
                continue;
            }
            name2 = tt.getDisplayName();
            if (this.taskManager.templateExists(tt.getDisplayName())) {
                name2 = this.renameTask(tt.getDisplayName());
                LOG.log(Level.INFO, "Rename database task {0} to {1}", new Object[]{tt.getDisplayName(), name2});
            }
            command = CommandSerialiser.fromByteArray((byte[])tt.getCommand());
            retT = this.taskManager.addTemplate(actor, command, (String)name2, tt.getPriority(), tt.isAlertAutomatically(), tt.getIgnorePathsCollectionName());
            ret.addDatabaseTemplate(new TaskTemplateExport(retT));
            LOG.log(Level.INFO, "Import database task {0}", name2);
        }
        for (TaskTemplateExport tt : in.getKnowledgebase()) {
            if (tt.getSerVersion().equals("1")) {
                LOG.log(Level.WARNING, "Import too old to migrate knowledgebase task {0}", tt.getDisplayName());
                continue;
            }
            name2 = tt.getDisplayName();
            if (this.taskManager.templateExists(tt.getDisplayName())) {
                name2 = this.renameTask(tt.getDisplayName());
                LOG.log(Level.INFO, "Rename knowledgebase task {0} to {1}", new Object[]{tt.getDisplayName(), name2});
            }
            command = CommandSerialiser.fromByteArray((byte[])tt.getCommand());
            retT = this.taskManager.addTemplate(actor, command, (String)name2, tt.getPriority(), tt.isAlertAutomatically(), tt.getIgnorePathsCollectionName());
            ret.addKnowledgebaseTemplate(new TaskTemplateExport(retT));
            LOG.log(Level.INFO, "Import knowledgebase task {0}", name2);
        }
        for (RTTaskInstanceExport ti : in.getRealtime()) {
            RTCommand command2 = null;
            name = ti.getDisplayName();
            if (this.taskManager.searchOrRTNameExists(ti.getDisplayName())) {
                name = this.renameTask(ti.getDisplayName());
                LOG.log(Level.INFO, "Rename realtime task {0} to {1}", new Object[]{ti.getDisplayName(), name});
            }
            if (command2 == null) {
                command2 = (RTCommand)CommandSerialiser.fromByteArray((byte[])ti.getCommand());
            }
            TaskInstance tiRet = ti.isRunOnallDevices() ? this.rtManager.runProtectCommandOnAllDevices(actor, (String)name, command2.getConfig(), ti.isApplyActionsAutomatically(), ti.getActionIgnorePathsName()) : this.rtManager.runProtectCommand(actor, (String)name, command2.getConfig(), Collections.emptyList(), ti.isApplyActionsAutomatically(), ti.getActionIgnorePathsName());
            ret.addRealtimeInstance(new RTTaskInstanceExport(tiRet));
            LOG.log(Level.INFO, "Import realtime task {0}", name);
        }
        block14: for (PatternExport pat : in.getPatterns()) {
            SpecialPatternType spt = SpecialPatternType.values()[pat.getPatternType()];
            name = pat.getDisplayName();
            int count = 1;
            while (this.patternService.savedPatternNameExists((String)name)) {
                name = pat.getDisplayName() + "_" + ++count;
            }
            pat.setDisplayName((String)name);
            switch (2.$SwitchMap$com$geolang$ascema$domainmodelpublic$pattern$SpecialPatternType[spt.ordinal()]) {
                case 1: {
                    SavedCompoundPattern scp = new SavedCompoundPattern(pat.getLhs(), pat.getRhs(), pat.getOperator(), (String)name, pat.getDescription());
                    this.patternService.importPattern(scp, actor);
                    LOG.log(Level.INFO, "imported compound pattern {0}", name);
                    continue block14;
                }
            }
            SavedPattern sp = new SavedPattern((String)name, pat.getPatternBlob(), spt);
            this.patternService.importPattern(sp, actor);
            LOG.log(Level.INFO, "imported {0} pattern {1}", new Object[]{spt.name(), name});
        }
        ret.setPatterns(in.getPatterns());
        for (FileExtExport ext : in.getExtensions()) {
            name2 = ext.getDisplayName();
            int count = 1;
            while (this.extStore.fileExtensionNameExists((String)name2)) {
                name2 = ext.getDisplayName() + "_" + ++count;
            }
            ext.setDisplayName((String)name2);
            try {
                this.extStore.createFileExtension((String)name2, new TreeSet(ext.getExtensions()));
                LOG.log(Level.INFO, "imported file extension {0}", name2);
            }
            catch (FileExtensionExistsException ex) {
                Logger.getLogger(ImportExportService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (CredentialsExport cred : in.getCredentials()) {
            name2 = cred.getDisplayName();
            int count = 1;
            while (this.credentialsStore.existsByName((String)name2)) {
                name2 = cred.getDisplayName() + "_" + ++count;
            }
            try {
                CloudCredentials cc = CloudCredentials.importFromJson((String)cred.getJsonCredentials());
                cc.setDisplayName((String)name2);
                stored = new CloudCredentialStored((String)name2, cc, actor);
                this.credentialsStore.addOrReplace((CloudCredentialStored)stored);
                LOG.log(Level.INFO, "imported credentials {0}", name2);
                ret.addCredential(new CredentialsExport(stored.getDisplayName(), cred.getDevType(), cc.toJSON(), stored.getCreatedBy(), stored.getCreatedDate()));
            }
            catch (JsonProcessingException ex) {
                Logger.getLogger(ImportExportService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (CredentialsExport cred : in.getDbCredentials()) {
            name2 = cred.getDisplayName();
            int count = 1;
            while (this.dbcredentialsStore.existsByName((String)name2)) {
                name2 = cred.getDisplayName() + "_" + ++count;
            }
            try {
                DatabaseCredentials cc = DatabaseCredentials.fromJSON((String)cred.getJsonCredentials());
                cc.setDisplayName((String)name2);
                stored = new DatabaseCredentialStored((String)name2, cc, actor);
                Set queryies = cred.getQueries().stream().map(s -> s.toDBQuery()).collect(Collectors.toSet());
                this.dbcredentialsStore.addOrReplace((DatabaseCredentialStored)stored, queryies);
                LOG.log(Level.INFO, "imported credentials {0}", name2);
                ret.addDbCredential(new DatabaseCredentialsExport(stored.getDisplayName(), cc.toJSON(), stored.getCreatedBy(), stored.getCreatedDate(), stored.getQueries()));
            }
            catch (JsonProcessingException ex) {
                Logger.getLogger(ImportExportService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (ContextWordExport cw : in.getContextWords()) {
            patName = cw.getDisplayName();
            Set words = cw.getWords();
            this.contextWordStore.setForPattern(patName, words);
            LOG.log(Level.INFO, "Set context words for {0}", patName);
        }
        ret.setContextWords(in.getContextWords());
        for (ClassificationLabelExport cl : in.getClassificationLabels()) {
            patName = cl.getDisplayName();
            Set words = cl.getWords();
            this.classificationLabelStore.setForPattern(patName, words);
            LOG.log(Level.INFO, "Set classification labels for {0}", patName);
        }
        ret.setClassificationLabels(in.getClassificationLabels());
        for (PathCollectionExport path : in.getIgnorePaths()) {
            name2 = path.getDisplayName();
            int count = 1;
            while (this.ignorePathsController.existsByName((String)name2)) {
                name2 = path.getDisplayName() + "_" + ++count;
            }
            ActionIgnorePaths aip = new ActionIgnorePaths();
            for (SavedPath sp : path.getPaths()) {
                HostAndPath s2 = new HostAndPath(sp.getHost(), sp.getPath());
                if (aip.alreadyContained(s2)) continue;
                aip.addRemovingContainedBy(s2);
            }
            PathCollection r = this.ignorePathsController.createOrUpdate((String)name2, actor, aip.getPaths());
            ret.addIgnorePath(new PathCollectionExport(r));
        }
        ArrayList<PatternIgnoreExport> retPatIg = new ArrayList<PatternIgnoreExport>();
        for (PatternIgnoreExport patIg : in.getPatternIgnores()) {
            boolean added = this.patternIgnoreController.addIgnoresToPattern(actor, patIg.getDisplayName(), patIg.getIgnores());
            if (!added) continue;
            retPatIg.add(patIg);
        }
        ret.setPatternIgnores(retPatIg);
        ret.setExtensions(in.getExtensions());
        return ret;
    }

    private String renameTask(String name) {
        int count = 1;
        while (this.taskManager.searchOrRTNameExists(name + "_" + count)) {
            ++count;
        }
        return name + "_" + count;
    }
}

