/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.managerdomain.web.WebFile;
import com.geolang.ascema.managerdomain.web.WebFolder;
import com.geolang.ascema.managerservice.controllers.FolderBrowser;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FolderBrowser {
    private final List<String> extensions;
    private final boolean returnFiles;

    public FolderBrowser(List<String> extensionslist) {
        this.extensions = new ArrayList();
        for (String ext : extensionslist) {
            this.extensions.add(ext.replaceAll("[^a-zA-Z0-9]", "").toLowerCase());
        }
        this.returnFiles = true;
    }

    public FolderBrowser() {
        this.returnFiles = false;
        this.extensions = Collections.emptyList();
    }

    public List<WebFolder> browse(String path) {
        if (path.trim().equals("")) {
            return this.getRoots();
        }
        return this.getSubDirs(path);
    }

    private List<WebFolder> getRoots() {
        ArrayList<WebFolder> subDirs = new ArrayList<WebFolder>();
        Iterable<Path> roots = FileSystems.getDefault().getRootDirectories();
        for (Path p : roots) {
            if (Files.isReadable(p)) {
                subDirs.add(this.createFolder(p, true));
                continue;
            }
            Logger.getLogger(FolderBrowser.class.getName()).log(Level.WARNING, "Root is NOT readable: {0} ", p);
        }
        return subDirs;
    }

    private WebFolder createFolder(Path p, boolean rootfolder) {
        String absolutePath = p.toAbsolutePath().toString();
        String name = rootfolder ? absolutePath : p.getFileName().toString();
        WebFolder ret = new WebFolder(name, absolutePath);
        if (this.returnFiles) {
            this.populateFiles(p, ret);
        }
        return ret;
    }

    private List<WebFolder> getSubDirs(String pathStr) {
        Path path = FileSystems.getDefault().getPath(pathStr, new String[0]);
        ArrayList<WebFolder> subDirs = new ArrayList<WebFolder>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)new DirectoriesFilter());){
            for (Path p : ds) {
                subDirs.add(this.createFolder(p, false));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(FolderBrowser.class.getName()).log(Level.SEVERE, null, ex);
        }
        return subDirs;
    }

    private void populateFiles(Path path, WebFolder wf) {
        File[] files;
        ArrayList<WebFile> ret = new ArrayList<WebFile>();
        File f = path.toFile();
        if (!f.isDirectory()) {
            return;
        }
        for (File found : files = f.listFiles(pathname -> {
            if (pathname.isDirectory()) {
                return false;
            }
            String lcPath = pathname.getAbsolutePath().toLowerCase();
            return this.extensions.stream().anyMatch(ext -> lcPath.endsWith((String)ext));
        })) {
            Path foundpath = found.toPath();
            String name = foundpath.getFileName().toString();
            String absolutePath = foundpath.toAbsolutePath().toString();
            WebFile webfile = new WebFile(absolutePath, name);
            ret.add(webfile);
        }
        wf.setFiles(ret.toArray(new WebFile[0]));
    }
}

