/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerdomain.db.ManagerDatabaseCredentials;
import com.geolang.ascema.managerservice.controllers.BuildVersion;
import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DerbyBackup {
    private static final Logger LOG = Logger.getLogger(DerbyBackup.class.getName());
    private static final AtomicBoolean backingUp = new AtomicBoolean(false);
    @Autowired
    private DataSource ds;
    @Autowired
    BuildVersion buildVersion;

    public boolean usingDerbyDb() {
        ManagerDatabaseCredentials creds = ManagerDatabaseCredentials.getInstance();
        return !creds.allGood();
    }

    public boolean isBackingUp() {
        return backingUp.get();
    }

    public List<String> listBackups() {
        File[] directories;
        ArrayList<String> ret = new ArrayList<String>();
        for (File d : directories = new File(WorkingFolder.getDbBackupFolder()).listFiles(File::isDirectory)) {
            ret.add(d.getName());
        }
        ret.sort(Comparator.reverseOrder());
        return ret;
    }

    public boolean deleteBackup(String name) {
        String path = WorkingFolder.getDbBackupFolder() + File.separator + name;
        File f = new File(path);
        if (!f.exists() || !f.isDirectory()) {
            LOG.log(Level.WARNING, "backup folder not found {0}", path);
            return false;
        }
        try {
            FileUtils.deleteDirectory((File)f);
        }
        catch (IOException ex) {
            Logger.getLogger(DerbyBackup.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public boolean backup() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean backupAndStartRestoreLog() {
        if (!this.usingDerbyDb()) {
            LOG.warning("Not using derbydb - can't backup with restore");
            return false;
        }
        String backupdirectory = this.createFolderName();
        LOG.log(Level.INFO, "Attempt db backup to {0}. Starting restore log", backupdirectory);
        try (Connection conn = this.ds.getConnection();){
            boolean bl;
            block15: {
                CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE(?)");
                try {
                    cs.setString(1, backupdirectory);
                    cs.execute();
                    LOG.log(Level.INFO, "backed up database and started recovery log in {0}.", backupdirectory);
                    bl = true;
                    if (cs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (cs != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cs.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return false;
        }
    }

    private String createFolderName() {
        String root = WorkingFolder.getDbBackupFolder();
        SimpleDateFormat todaysDate = new SimpleDateFormat("yyyy-MM-dd@HH-mm");
        String dateStr = todaysDate.format(Calendar.getInstance().getTime());
        return root + File.separator + "Backup(V" + this.buildVersion.getBuildVersion() + ")_" + dateStr;
    }
}

