/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.managerdomain.domain.TimePeriod;
import com.geolang.ascema.managerservice.controllers.DateRangeHelper;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateRangeHelper {
    private static final Logger LOG = Logger.getLogger(DateRangeHelper.class.getName());

    static LocalDate getLastDayBeforeInFullPeriod(LocalDate yesterday, TimePeriod tp) {
        switch (1.$SwitchMap$com$geolang$ascema$managerdomain$domain$TimePeriod[tp.ordinal()]) {
            case 1: {
                return DateRangeHelper.decemberthirtyFirstBefore((LocalDate)yesterday);
            }
            case 2: {
                return yesterday;
            }
            case 3: {
                return DateRangeHelper.endMonthBefore((LocalDate)yesterday);
            }
            case 4: {
                return DateRangeHelper.endQuarterBefore((LocalDate)yesterday);
            }
            case 5: {
                return DateRangeHelper.endWeekBefore((LocalDate)yesterday);
            }
        }
        LOG.log(Level.SEVERE, "unknown TimePeriod {0}", tp);
        return null;
    }

    static LocalDate getFirstDayAfterInFullPeriod(LocalDate lowestData, TimePeriod tp) {
        switch (1.$SwitchMap$com$geolang$ascema$managerdomain$domain$TimePeriod[tp.ordinal()]) {
            case 1: {
                return DateRangeHelper.janFirstAfter((LocalDate)lowestData);
            }
            case 2: {
                return lowestData;
            }
            case 3: {
                return DateRangeHelper.firstMonthAfter((LocalDate)lowestData);
            }
            case 4: {
                return DateRangeHelper.firstQuarterAfter((LocalDate)lowestData);
            }
            case 5: {
                return DateRangeHelper.firstWeekAfter((LocalDate)lowestData);
            }
        }
        LOG.log(Level.SEVERE, "unknown TimePeriod {0}", tp);
        return null;
    }

    static long numPeriodsInRange(LocalDate start, LocalDate end, TimePeriod tp) {
        if (start.isAfter(end)) {
            return 0L;
        }
        switch (1.$SwitchMap$com$geolang$ascema$managerdomain$domain$TimePeriod[tp.ordinal()]) {
            case 1: {
                return end.getYear() - start.getYear() + 1;
            }
            case 3: {
                return ChronoUnit.MONTHS.between(start, end) + 1L;
            }
            case 2: {
                return ChronoUnit.DAYS.between(start, end) + 1L;
            }
            case 5: {
                return ChronoUnit.WEEKS.between(start, end) + 1L;
            }
            case 4: {
                return ChronoUnit.MONTHS.between(start, end) / 3L + 1L;
            }
        }
        return 0L;
    }

    static List<Pair<LocalDate, LocalDate>> getFistAndLastDaysOfPeriod(LocalDate start, LocalDate end, TimePeriod tp) {
        ArrayList<Pair<LocalDate, LocalDate>> ret = new ArrayList<Pair<LocalDate, LocalDate>>();
        if (start.isAfter(end)) {
            LOG.log(Level.WARNING, "start {0} is after end {1}", new Object[]{start, end});
            return ret;
        }
        while (true) {
            LocalDate ld = DateRangeHelper.getLastDayBeforeInFullPeriod((LocalDate)end, (TimePeriod)tp);
            LocalDate sd = tp.equals((Object)TimePeriod.DAILY) ? ld : DateRangeHelper.getFirstDayAfterInFullPeriod((LocalDate)DateRangeHelper.getPreviousLastDay((LocalDate)ld, (TimePeriod)tp), (TimePeriod)tp);
            if (sd.isBefore(start)) {
                return ret;
            }
            ret.add((Pair<LocalDate, LocalDate>)Pair.of((Object)sd, (Object)ld));
            end = ld.minus(1L, ChronoUnit.DAYS);
        }
    }

    static Optional<Pair<LocalDate, LocalDate>> getFirstAndLastDaysOfPreviousPeriod(LocalDate start, LocalDate end, TimePeriod tp) {
        if (start.isAfter(end)) {
            LOG.log(Level.WARNING, "start {0} is after end {1}", new Object[]{start, end});
            return Optional.empty();
        }
        long numofperiods = DateRangeHelper.numPeriodsInRange((LocalDate)start, (LocalDate)end, (TimePeriod)tp);
        LocalDate previousstartdate = null;
        LocalDate previousenddate = null;
        switch (1.$SwitchMap$com$geolang$ascema$managerdomain$domain$TimePeriod[tp.ordinal()]) {
            case 1: {
                previousstartdate = start.minus(numofperiods, ChronoUnit.YEARS);
                previousenddate = end.minus(numofperiods, ChronoUnit.YEARS);
                break;
            }
            case 2: {
                previousstartdate = start.minus(numofperiods, ChronoUnit.DAYS);
                previousenddate = end.minus(numofperiods, ChronoUnit.DAYS);
                break;
            }
            case 3: {
                previousstartdate = start.minus(numofperiods, ChronoUnit.MONTHS);
                previousenddate = end.minus(numofperiods, ChronoUnit.MONTHS);
                previousstartdate = previousstartdate.withDayOfMonth(1);
                previousenddate = previousenddate.withDayOfMonth(previousenddate.lengthOfMonth());
                break;
            }
            case 4: {
                previousstartdate = start.minus(numofperiods * 3L, ChronoUnit.MONTHS);
                previousenddate = end.minus(numofperiods * 3L, ChronoUnit.MONTHS);
                previousstartdate = previousstartdate.withDayOfMonth(1);
                previousenddate = previousenddate.withDayOfMonth(previousenddate.lengthOfMonth());
                break;
            }
            case 5: {
                previousstartdate = start.minus(numofperiods, ChronoUnit.WEEKS);
                previousenddate = end.minus(numofperiods, ChronoUnit.WEEKS);
            }
        }
        if (previousstartdate == null || previousenddate == null) {
            return Optional.empty();
        }
        Pair previousdatepair = Pair.of((Object)previousstartdate, previousenddate);
        return Optional.of(previousdatepair);
    }

    private static LocalDate getPreviousLastDay(LocalDate ld, TimePeriod tp) {
        switch (1.$SwitchMap$com$geolang$ascema$managerdomain$domain$TimePeriod[tp.ordinal()]) {
            case 1: {
                return ld.minus(1L, ChronoUnit.YEARS);
            }
            case 2: {
                return ld.minus(1L, ChronoUnit.DAYS);
            }
            case 3: {
                return ld.minus(1L, ChronoUnit.MONTHS);
            }
            case 4: {
                return ld.minus(3L, ChronoUnit.MONTHS);
            }
            case 5: {
                return ld.minus(1L, ChronoUnit.WEEKS);
            }
        }
        LOG.log(Level.SEVERE, "unknown TimePeriod {0}", tp);
        return null;
    }

    private static LocalDate janFirstAfter(LocalDate lowestData) {
        if (lowestData.getDayOfYear() == 1) {
            return lowestData;
        }
        int year = lowestData.getYear();
        return LocalDate.of(++year, Month.JANUARY, 1);
    }

    private static LocalDate firstMonthAfter(LocalDate lowestData) {
        if (lowestData.getDayOfMonth() == 1) {
            return lowestData;
        }
        LocalDate ret = LocalDate.of(lowestData.getYear(), lowestData.getMonth(), 1);
        return ret.plus(1L, ChronoUnit.MONTHS);
    }

    private static LocalDate firstQuarterAfter(LocalDate lowestData) {
        boolean quarterMonth;
        Month month = lowestData.getMonth();
        boolean bl = quarterMonth = month.equals(Month.JANUARY) || month.equals(Month.APRIL) || month.equals(Month.JULY) || month.equals(Month.OCTOBER);
        if (lowestData.getDayOfMonth() == 1 && quarterMonth) {
            return lowestData;
        }
        Month nextQuarter = Month.JANUARY;
        int year = lowestData.getYear();
        switch (1.$SwitchMap$java$time$Month[month.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                nextQuarter = Month.APRIL;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                nextQuarter = Month.JULY;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                nextQuarter = Month.OCTOBER;
                break;
            }
            default: {
                ++year;
            }
        }
        return LocalDate.of(year, nextQuarter, 1);
    }

    private static LocalDate firstWeekAfter(LocalDate lowestData) {
        if (lowestData.getDayOfWeek().equals(DayOfWeek.MONDAY)) {
            return lowestData;
        }
        return lowestData.with(TemporalAdjusters.next(DayOfWeek.MONDAY));
    }

    private static LocalDate decemberthirtyFirstBefore(LocalDate yesterday) {
        LocalDate lastDayOfYear = yesterday.with(TemporalAdjusters.lastDayOfYear());
        if (yesterday.equals(lastDayOfYear)) {
            return yesterday;
        }
        return lastDayOfYear.minus(1L, ChronoUnit.YEARS);
    }

    private static LocalDate endMonthBefore(LocalDate yesterday) {
        LocalDate atEndOfMonth = yesterday.with(TemporalAdjusters.lastDayOfMonth());
        if (atEndOfMonth.getDayOfMonth() == yesterday.getDayOfMonth()) {
            return yesterday;
        }
        return atEndOfMonth.minus(1L, ChronoUnit.MONTHS).with(TemporalAdjusters.lastDayOfMonth());
    }

    private static LocalDate endQuarterBefore(LocalDate yesterday) {
        Month month = yesterday.getMonth();
        boolean endQuarterMonth = month.equals(Month.DECEMBER) || month.equals(Month.MARCH) || month.equals(Month.JUNE) || month.equals(Month.SEPTEMBER);
        LocalDate atEndOfMonth = yesterday.with(TemporalAdjusters.lastDayOfMonth());
        if (endQuarterMonth && atEndOfMonth.getDayOfMonth() == yesterday.getDayOfMonth()) {
            return yesterday;
        }
        Month prevQuarterEnd = Month.DECEMBER;
        int year = yesterday.getYear();
        switch (1.$SwitchMap$java$time$Month[month.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                --year;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                prevQuarterEnd = Month.MARCH;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                prevQuarterEnd = Month.JUNE;
                break;
            }
            default: {
                prevQuarterEnd = Month.SEPTEMBER;
            }
        }
        LocalDate ret = LocalDate.of(year, prevQuarterEnd, 1);
        return ret.with(TemporalAdjusters.lastDayOfMonth());
    }

    private static LocalDate endWeekBefore(LocalDate yesterday) {
        if (yesterday.getDayOfWeek().equals(DayOfWeek.SUNDAY)) {
            return yesterday;
        }
        return yesterday.with(TemporalAdjusters.previous(DayOfWeek.SUNDAY));
    }
}

