/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.domainmodelpublic.PatternMatchResult;
import com.geolang.ascema.endpointcommon.database.DatabaseCredentials;
import com.geolang.ascema.endpointcommon.database.DatabaseSearchCommand;
import com.geolang.ascema.endpointcommon.database.DatabaseSearchResult;
import com.geolang.ascema.endpointcommon.discovery.encrypt.MatchingTextEncryptor;
import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.searchconfig.DBQuery;
import com.geolang.ascema.endpointcommon.domain.searchconfig.DatabaseSearchConfiguration;
import com.geolang.ascema.managerdomain.datapoint.DBDataSliceRequest;
import com.geolang.ascema.managerdomain.datapoint.DBTopLevel;
import com.geolang.ascema.managerdomain.domain.DatabaseCredentialStored;
import com.geolang.ascema.managerdomain.domain.DatabaseResultColumns;
import com.geolang.ascema.managerdomain.domain.DatabaseResultStored;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.domain.TaskTemplate;
import com.geolang.ascema.managerdomain.dto.DTOPatternCount;
import com.geolang.ascema.managerdomain.web.RunCommand;
import com.geolang.ascema.managerdomain.web.WebSavedDatabaseCredentials;
import com.geolang.ascema.managerpersistence.ClassificationLabelStore;
import com.geolang.ascema.managerpersistence.ContextWordStore;
import com.geolang.ascema.managerpersistence.DatabaseCredentialsStore;
import com.geolang.ascema.managerpersistence.DatabaseResultsStore;
import com.geolang.ascema.managerpersistence.FileExtensionStore;
import com.geolang.ascema.managerpersistence.exportdata.IExportData;
import com.geolang.ascema.managerpersistence.results.DBResultsPage;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.SchedulingService;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.controllers.patterns.PatternService;
import com.geolang.ascema.managerservice.controllers.results.export.DBExportData;
import com.geolang.ascema.managerservice.controllers.results.ignore.PatternIgnoreController;
import com.geolang.ascema.managerservice.controllers.tasks.JobRunner;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import com.geolang.ascema.managerservice.rest.requests.tasks.DatabaseSearchJobInstance;
import com.geolang.ascema.managerservice.rest.requests.tasks.DatabaseSearchJobTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DatabaseSearchController {
    private static final Logger LOG = Logger.getLogger(DatabaseSearchController.class.getName());
    @Autowired
    private AuditLogService auditLog;
    @Autowired
    private JobRunner jobRunner;
    @Autowired
    private DeviceService endpointController;
    @Autowired
    private SchedulingService scheduler;
    @Autowired
    private PatternService patternService;
    @Autowired
    private DatabaseCredentialsStore dbcredsStore;
    @Autowired
    private DatabaseResultsStore resultsStore;
    @Autowired
    @Lazy
    private TaskManager taskManager;
    @Autowired
    private FileExtensionStore fileExtManager;
    @Autowired
    private PatternIgnoreController ignoresHelper;
    @Autowired
    private ContextWordStore contextWords;
    @Autowired
    private ClassificationLabelStore classificationLabelsStore;

    public Stream<IExportData> getExportStream(String taskId, boolean dec, boolean showIgnore, int minConfidence) {
        Optional colsOpt = this.getColumnsForSearch(taskId);
        if (colsOpt.isEmpty()) {
            return null;
        }
        DatabaseResultColumns cols = (DatabaseResultColumns)colsOpt.get();
        List headers = cols.getColvals().stream().map(s -> s.getLabel()).collect(Collectors.toList());
        DBExportData.setHeaders(headers, (boolean)dec);
        return this.resultsStore.stream(taskId).filter(s -> this.filter(s, showIgnore, minConfidence)).map(s -> new DBExportData(s, dec, this.classificationLabelsStore));
    }

    private boolean filter(DatabaseResultStored s, boolean showIgnore, int minConfidence) {
        if (!showIgnore && s.isIgnored()) {
            return false;
        }
        return s.getConfidence() >= minConfidence;
    }

    public DBResultsPage getPageOfResults(Pageable pageable, DBDataSliceRequest req) {
        Page ret = this.resultsStore.getPageOfResults(pageable, req.getTaskInstanceId(), req.getPatternDisplayName(), req.getMinConfidence(), req.isShowIgnore());
        return new DBResultsPage(ret, this.classificationLabelsStore);
    }

    public boolean storeResult(DatabaseSearchResult res) {
        boolean ret = true;
        this.resultsStore.writeColumnsIfNeeded(res);
        for (PatternMatchResult pm : res.getResults()) {
            DatabaseResultStored toSave = new DatabaseResultStored(res, pm);
            if (this.resultsStore.hasResultAlready(toSave)) {
                LOG.log(Level.INFO, "not saving result we already have for device {0} (row {1} col {2})", new Object[]{res.getDeviceName(), res.getRowNum(), res.getColNum()});
                continue;
            }
            if (this.ignoresHelper.datapointIsIgnored(pm.getName(), pm.getDisplayName(), res.getDeviceId(), pm.getMatchingText())) {
                toSave.setIgnored(true);
            }
            this.resultsStore.save(toSave);
        }
        LOG.log(Level.INFO, "Add database result from {0}", res.getDeviceName());
        if (ret) {
            this.auditLog.resultsAdded(this.taskManager, res);
        }
        return ret;
    }

    public Long getResultsCountForTaskInstance(String jobPlanId) {
        return this.resultsStore.getResultCountsForTaskInstance(jobPlanId);
    }

    public Optional<DatabaseResultColumns> getColumnsForSearch(String taskInstanceId) {
        Optional ret = this.resultsStore.getColumnsForSearch(taskInstanceId);
        if (ret.isEmpty()) {
            LOG.log(Level.FINE, "No result columns found for {0}", taskInstanceId);
        }
        return ret;
    }

    public List<DBTopLevel> getTopLevels(String taskInstanceId, int minConfidence, boolean showIgnored) {
        return this.resultsStore.getTopLevels(taskInstanceId, minConfidence, showIgnored);
    }

    public List<DTOPatternCount> getPatternCountsForTaskId(String searchJobInstanceId) {
        return this.resultsStore.getPatternCountsForTaskId(searchJobInstanceId);
    }

    public Optional<String> unRedactMatch(Long matchId) {
        Optional storedMatchOpt = this.resultsStore.findById(matchId);
        if (storedMatchOpt.isEmpty()) {
            return Optional.empty();
        }
        DatabaseResultStored rs = (DatabaseResultStored)storedMatchOpt.get();
        MatchingTextEncryptor enc = new MatchingTextEncryptor(rs.getDeviceId());
        return Optional.of(enc.dec(rs.getMatchingText()));
    }

    public DatabaseSearchJobTemplate addTemplate(String principle, DatabaseSearchJobTemplate s) {
        DatabaseSearchConfiguration config = s.toConfig(this.fileExtManager, this.contextWords, this.classificationLabelsStore);
        DatabaseSearchCommand command = new DatabaseSearchCommand(config);
        return new DatabaseSearchJobTemplate(this.taskManager.addTemplate(principle, (BaseCommand)command, s.getName(), s.getPriority(), s.isAlertAutomatically(), ""), this.scheduler, this.patternService, this.dbcredsStore, null);
    }

    public List<DatabaseSearchJobTemplate> getAllTemplates() {
        ArrayList<DatabaseSearchJobTemplate> ret = new ArrayList<DatabaseSearchJobTemplate>();
        ArrayList jps = this.taskManager.getAllTemplatesOfType(BaseCommand.CommandType.DATABASE_SEARCH);
        for (TaskTemplate jp : jps) {
            Date lastRan = this.taskManager.getLastRanOrNull(jp.getUid());
            DatabaseSearchJobTemplate sjt = new DatabaseSearchJobTemplate(jp, this.scheduler, this.patternService, this.dbcredsStore, lastRan);
            ret.add(sjt);
        }
        return ret;
    }

    public DatabaseSearchJobTemplate getTemplate(String templateId) {
        TaskTemplate tt = this.taskManager.getTemplateFromId(templateId);
        if (tt != null) {
            Date lastRan = this.taskManager.getLastRanOrNull(tt.getUid());
            return new DatabaseSearchJobTemplate(tt, this.scheduler, this.patternService, this.dbcredsStore, lastRan);
        }
        return null;
    }

    public List<DatabaseSearchJobInstance> getAllInstancesForTemplate(String searchJobTemplateId) {
        ArrayList<DatabaseSearchJobInstance> ret = new ArrayList<DatabaseSearchJobInstance>();
        List jps = this.taskManager.getAllInstancesForTemplate(searchJobTemplateId);
        for (TaskInstance jp : jps) {
            DatabaseSearchJobInstance sjt = new DatabaseSearchJobInstance(jp, ((DatabaseSearchCommand)jp.getCommand()).getConfig(), this.endpointController, this.patternService, this.dbcredsStore);
            ret.add(sjt);
        }
        return ret;
    }

    public DatabaseSearchJobInstance getInstanceFromId(String searchJobInstanceId) {
        Optional opt = this.taskManager.getTaskInstanceFromId(searchJobInstanceId);
        if (!opt.isPresent()) {
            return null;
        }
        TaskInstance instance = (TaskInstance)opt.get();
        return new DatabaseSearchJobInstance(instance, ((DatabaseSearchCommand)instance.getCommand()).getConfig(), this.endpointController, this.patternService, this.dbcredsStore);
    }

    public DatabaseSearchJobInstance createTaskInstance(String principle, TaskTemplate template, RunCommand com) {
        TaskInstance ti = this.jobRunner.runCommandOnDevices(principle, template, com.getName(), com.getPriority(), com.getDeviceIds(), com.isAlertAutomatically(), false, com.isOverrideQuietTime());
        return new DatabaseSearchJobInstance(ti, ((DatabaseSearchCommand)ti.getCommand()).getConfig(), this.endpointController, this.patternService, this.dbcredsStore);
    }

    public boolean testCredentials(String deviceId, DatabaseCredentials creds) {
        return this.endpointController.testDatabaseCredentials(deviceId, creds);
    }

    public DatabaseCredentialStored saveCredentials(String principal, String displayName, DatabaseCredentials creds) {
        creds.setDisplayName(displayName);
        DatabaseCredentialStored stored = new DatabaseCredentialStored(displayName, creds, principal);
        return this.dbcredsStore.addOrReplace(stored, Collections.emptySet());
    }

    public DatabaseCredentialStored editCredentials(String principal, String oldisplayname, String displayname, DatabaseCredentials creds) {
        creds.setDisplayName(displayname);
        Optional exitingOpt = this.dbcredsStore.getByName(oldisplayname);
        if (exitingOpt.isEmpty()) {
            LOG.log(Level.WARNING, "Failed to find old credentials to update {0}", oldisplayname);
            return null;
        }
        DatabaseCredentialStored existing = (DatabaseCredentialStored)exitingOpt.get();
        if (oldisplayname.equals(displayname)) {
            LOG.log(Level.INFO, "edit credentials - no rename {0}", displayname);
            DatabaseCredentialStored stored = new DatabaseCredentialStored(displayname, creds, principal);
            return this.dbcredsStore.addOrReplace(stored, existing.getQueries().stream().map(s -> s.toDBQuery()).collect(Collectors.toSet()));
        }
        LOG.log(Level.INFO, "edit credentials - with rename {0}", displayname);
        this.taskManager.updateDbCredentialsOnTasks(oldisplayname, displayname, creds);
        LOG.log(Level.INFO, "delete old dbcredentials {0} and save {1}", new Object[]{oldisplayname, displayname});
        this.dbcredsStore.deleteByName(oldisplayname);
        DatabaseCredentialStored stored = new DatabaseCredentialStored(displayname, creds, principal);
        return this.dbcredsStore.addOrReplace(stored, existing.getQueries().stream().map(s -> s.toDBQuery()).collect(Collectors.toSet()));
    }

    public WebSavedDatabaseCredentials setQueriesOnCredentials(String principal, String displayname, DBQuery[] queries) {
        HashSet<DBQuery> qset = new HashSet<DBQuery>(Arrays.asList(queries));
        DatabaseCredentialStored stored = this.dbcredsStore.updateQueries(principal, displayname, qset);
        if (stored != null) {
            return this.taskManager.decorateDBCredentialsWithInUse(stored);
        }
        return null;
    }

    public boolean deleteCredentials(String name) {
        return this.dbcredsStore.deleteByName(name);
    }

    public boolean credentialsExistsByName(String name) {
        return this.dbcredsStore.existsByName(name);
    }

    public List<WebSavedDatabaseCredentials> getAllSaved() {
        ArrayList<WebSavedDatabaseCredentials> ret = new ArrayList<WebSavedDatabaseCredentials>();
        for (DatabaseCredentialStored stored : this.dbcredsStore.getAll()) {
            WebSavedDatabaseCredentials toAdd = this.taskManager.decorateDBCredentialsWithInUse(stored);
            ret.add(toAdd);
        }
        return ret;
    }

    public boolean testQuery(String deviceId, DatabaseCredentials dc, DBQuery query) {
        return this.endpointController.testDatabaseQuery(deviceId, dc, query, 3);
    }
}

