/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.managerdomain.domain.DailyRecordStored;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerdomain.domain.TimePeriod;
import com.geolang.ascema.managerdomain.dto.DTOResult;
import com.geolang.ascema.managerdomain.web.HeroHeadlineNumbers;
import com.geolang.ascema.managerdomain.web.HeroRange;
import com.geolang.ascema.managerpersistence.EndpointStore;
import com.geolang.ascema.managerpersistence.IDailyRecordRepository;
import com.geolang.ascema.managerpersistence.results.MatchesManager;
import com.geolang.ascema.managerservice.controllers.DailyRecordGaps;
import com.geolang.ascema.managerservice.controllers.DateRangeHelper;
import com.geolang.ascema.managerservice.controllers.results.ResultsManager;
import com.geolang.ascema.managerservice.domain.DailyRecord;
import jakarta.persistence.EntityManager;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Lazy
public class DailyRecordManager {
    private static final Logger LOG = Logger.getLogger(DailyRecordManager.class.getName());
    private static final int MAX_PATTERNS_TO_SHOW = 5;
    @Autowired
    private EndpointStore endpointStore;
    @Autowired
    private ResultsManager resultsManager;
    @Autowired
    private MatchesManager matchesManager;
    @Autowired
    private IDailyRecordRepository repo;
    @Autowired
    private EntityManager entityManager;
    private LocalDate lowestRecordDate = LocalDate.now();
    private LocalDate yesterday;

    public DailyRecordGaps loadFinishedDailyRecords() {
        DailyRecordGaps gaps = new DailyRecordGaps();
        int count = 0;
        ArrayList<DailyRecordStored> all = new ArrayList<DailyRecordStored>();
        for (DailyRecordStored dr : this.repo.findAll()) {
            all.add(dr);
        }
        all.sort((a, b) -> a.getRecordDate().compareTo(b.getRecordDate()));
        for (DailyRecordStored dr : all) {
            LocalDate date = dr.getRecordDate();
            if (date.isBefore(this.lowestRecordDate)) {
                this.lowestRecordDate = date;
            }
            gaps.insertRecordForDate(date);
            ++count;
        }
        LOG.log(Level.INFO, "loaded {0} records into {1} ranges", new Object[]{count, gaps.getRecordSize()});
        return gaps;
    }

    @Transactional(readOnly=false)
    public synchronized void processResults(Optional<DailyRecordGaps> gaps) {
        LocalDate today = LocalDate.now();
        LOG.log(Level.INFO, "Process daily results for yesterday. Today is {0}", today.toString());
        this.yesterday = today.minus(1L, ChronoUnit.DAYS);
        Optional opt = this.repo.findById((Object)this.yesterday);
        if (opt.isPresent()) {
            LOG.warning("Have already processed results today - not doing it again");
            return;
        }
        DailyRecord recordToFill = new DailyRecord(this.yesterday);
        if (gaps.isPresent()) {
            gaps.get().start();
        }
        for (DeviceRegistration device : this.endpointStore.getAll(true, false)) {
            for (String taskId : this.resultsManager.getLatestInstancesForDeviceWhereJobIsFinished(device.getDeviceId())) {
                try (Stream stream = this.resultsManager.getResultsForTaskInstanceAndDevice(taskId, device.getDeviceId());){
                    stream.forEach(r -> this.processResult(r, recordToFill, device, gaps));
                }
                stream = this.resultsManager.getResultsInQuarantine(device.getDeviceId());
                try {
                    stream.forEach(r -> this.processResult(r, recordToFill, device, gaps));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        this.repo.save((Object)new DailyRecordStored(this.yesterday, recordToFill));
        if (gaps.isPresent()) {
            gaps.get().save(this.repo);
        }
        LOG.log(Level.INFO, "created daily record");
    }

    private void processResult(DTOResult br, DailyRecord recordToFill, DeviceRegistration device, Optional<DailyRecordGaps> gaps) {
        Optional opt;
        LocalDate eventDate = DailyRecord.asLocalDate((Date)br.getEventDate());
        if (eventDate.isAfter(this.yesterday)) {
            return;
        }
        DeviceType dt = device.getDeviceType();
        String location = device.getManagerName();
        if (eventDate.isBefore(this.lowestRecordDate)) {
            this.lowestRecordDate = eventDate;
        }
        if ((opt = this.resultsManager.getResultById(br.getId())).isPresent()) {
            if (gaps.isPresent() && eventDate.isBefore(this.yesterday)) {
                gaps.get().check(this.matchesManager, (SearchResultStored)opt.get(), eventDate, dt, location);
            }
            List matches = this.matchesManager.getDailyRecordMatches(((SearchResultStored)opt.get()).getId());
            recordToFill.record(matches, (SearchResultStored)opt.get(), dt, location);
            this.entityManager.detach(opt.get());
        }
    }

    @Transactional(readOnly=true)
    public List<DailyRecord> getRecordsBetween(Date from, Date to, TimePeriod timeperiod) {
        ArrayList<DailyRecord> ret = new ArrayList();
        if (timeperiod.equals((Object)TimePeriod.DAILY)) {
            List stored = this.repo.findAllByRecordDateBetween(DailyRecord.asLocalDate((Date)from), DailyRecord.asLocalDate((Date)to));
            if (stored != null) {
                for (DailyRecordStored s : stored) {
                    Optional opt = s.getRecord();
                    if (!opt.isPresent()) continue;
                    DailyRecord dr = (DailyRecord)opt.get();
                    dr.setLabel(dr.getRecordDate().toString());
                    ret.add(dr);
                }
            }
        } else {
            Optional prev;
            List dList = DateRangeHelper.getFistAndLastDaysOfPeriod((LocalDate)DailyRecord.asLocalDate((Date)from), (LocalDate)DailyRecord.asLocalDate((Date)to), (TimePeriod)timeperiod);
            LinkedList<Pair> dates = new LinkedList<Pair>(dList);
            if (dates.size() == 1 && (prev = DateRangeHelper.getFirstAndLastDaysOfPreviousPeriod((LocalDate)DailyRecord.asLocalDate((Date)from), (LocalDate)DailyRecord.asLocalDate((Date)to), (TimePeriod)timeperiod)).isPresent()) {
                dates.push((Pair)prev.get());
            }
            for (Pair range : dates) {
                List drs = this.repo.findAllByRecordDateBetween((LocalDate)range.getLeft(), (LocalDate)range.getRight());
                if (drs != null && !drs.isEmpty()) {
                    ret.add(this.createAverageDataPoint(drs, range));
                    continue;
                }
                LOG.log(Level.WARNING, "No record found for {0}", range);
            }
        }
        this.truncatePatterns(ret);
        ret = this.fillEmptyValuesWithZero(ret);
        return ret;
    }

    private DailyRecord createAverageDataPoint(List<DailyRecordStored> drs, Pair<LocalDate, LocalDate> range) {
        DailyRecord ret = new DailyRecord((LocalDate)range.getLeft());
        ret.setEndDate((LocalDate)range.getRight());
        ret.setLabel(((LocalDate)range.getRight()).format(DateTimeFormatter.ISO_DATE));
        ret.setYearLabel(Integer.toString(((LocalDate)range.getLeft()).getYear()));
        for (DailyRecordStored stored : drs) {
            if (!stored.getRecord().isPresent()) continue;
            ret.merge((DailyRecord)stored.getRecord().get());
        }
        ret.averageAllCount(drs.size());
        return ret;
    }

    public HeroRange getFullRange(TimePeriod tp) {
        HeroRange ret = new HeroRange(tp, this.lowestRecordDate, this.yesterday);
        if (ret.isSelectedRangeValid()) {
            LocalDate low = DateRangeHelper.getFirstDayAfterInFullPeriod((LocalDate)this.lowestRecordDate, (TimePeriod)tp);
            LocalDate high = DateRangeHelper.getLastDayBeforeInFullPeriod((LocalDate)this.yesterday, (TimePeriod)tp);
            ret.setRange(low, high);
            if (ret.isRangeValid()) {
                ret.setNumDataPointsAvailable(DateRangeHelper.numPeriodsInRange((LocalDate)low, (LocalDate)high, (TimePeriod)tp));
            }
        }
        return ret;
    }

    public List<TimePeriod> getAvailableRanges() {
        ArrayList<TimePeriod> ret = new ArrayList<TimePeriod>();
        for (TimePeriod tp : TimePeriod.values()) {
            LocalDate end;
            LocalDate start = DateRangeHelper.getFirstDayAfterInFullPeriod((LocalDate)this.lowestRecordDate, (TimePeriod)tp);
            long numRanges = DateRangeHelper.numPeriodsInRange((LocalDate)start, (LocalDate)(end = DateRangeHelper.getLastDayBeforeInFullPeriod((LocalDate)this.yesterday, (TimePeriod)tp)), (TimePeriod)tp);
            if (numRanges <= 1L) continue;
            ret.add(tp);
        }
        return ret;
    }

    public HeroRange getRange(TimePeriod tp, Date start, Date end) {
        LocalDate lEnd;
        LocalDate lStart = DailyRecord.asLocalDate((Date)start);
        HeroRange ret = new HeroRange(tp, lStart, lEnd = DailyRecord.asLocalDate((Date)end));
        if (ret.isSelectedRangeValid()) {
            LocalDate low = DateRangeHelper.getFirstDayAfterInFullPeriod((LocalDate)lStart, (TimePeriod)tp);
            LocalDate high = DateRangeHelper.getLastDayBeforeInFullPeriod((LocalDate)lEnd, (TimePeriod)tp);
            ret.setRange(low, high);
            if (ret.isRangeValid()) {
                ret.setNumDataPointsAvailable(DateRangeHelper.numPeriodsInRange((LocalDate)low, (LocalDate)high, (TimePeriod)tp));
            }
        }
        return ret;
    }

    public Date getFirstDate(TimePeriod tp) {
        return DailyRecord.asDate((LocalDate)DateRangeHelper.getFirstDayAfterInFullPeriod((LocalDate)this.lowestRecordDate, (TimePeriod)tp));
    }

    public Date getLastDate(TimePeriod tp) {
        return DailyRecord.asDate((LocalDate)DateRangeHelper.getLastDayBeforeInFullPeriod((LocalDate)this.yesterday, (TimePeriod)tp));
    }

    private Optional<DailyRecord> getDailyRecord(Date date) {
        return this.getDailyRecord(DailyRecord.asLocalDate((Date)date));
    }

    private Optional<DailyRecord> getDailyRecord(LocalDate date) {
        Optional opt;
        DailyRecordStored drs = this.repo.findByRecordDate(date);
        if (drs != null && (opt = drs.getRecord()).isPresent()) {
            return Optional.of((DailyRecord)opt.get());
        }
        return Optional.empty();
    }

    @Transactional(readOnly=true)
    public HeroHeadlineNumbers getHeadlineNumbers(Date start, Date end, TimePeriod tp) {
        Pair previousrage;
        Optional<DailyRecord> opt1 = this.getDailyRecord(DailyRecord.asLocalDate((Date)start).minusDays(1L));
        Optional<DailyRecord> opt2 = this.getDailyRecord(end);
        if (!opt1.isPresent()) {
            opt1 = Optional.of(new DailyRecord());
        }
        if (!opt2.isPresent()) {
            LOG.log(Level.WARNING, "No daily record for emd date {0}", end);
            opt2 = Optional.of(new DailyRecord());
        }
        DailyRecord startdr = opt1.get();
        DailyRecord enddr = (DailyRecord)opt2.get();
        DailyRecord period = enddr.diff(startdr);
        int foundinperiod = period.getTotalCountsByStatusAndReason();
        int resolvedinperiod = period.getTotalResolvedByCount();
        int outstandinginperiod = enddr.getTotalOutstandingByCount();
        HeroHeadlineNumbers.ChangeDataPoint matchesfound = new HeroHeadlineNumbers.ChangeDataPoint((double)startdr.getTotalCountsByStatusAndReason(), (double)enddr.getTotalCountsByStatusAndReason());
        HeroHeadlineNumbers.ChangeDataPoint resolved = new HeroHeadlineNumbers.ChangeDataPoint((double)startdr.getTotalResolvedByCount(), (double)enddr.getTotalResolvedByCount());
        HeroHeadlineNumbers.ChangeDataPoint outstanding = new HeroHeadlineNumbers.ChangeDataPoint((double)startdr.getTotalOutstandingByCount(), (double)enddr.getTotalOutstandingByCount());
        Optional opt = DateRangeHelper.getFirstAndLastDaysOfPreviousPeriod((LocalDate)DailyRecord.asLocalDate((Date)start), (LocalDate)DailyRecord.asLocalDate((Date)end), (TimePeriod)tp);
        if (opt.isPresent() && this.repo.existsByRecordDate((LocalDate)(previousrage = (Pair)opt.get()).getLeft())) {
            Date comparableperiodstart = DailyRecord.asDate((LocalDate)((LocalDate)previousrage.getLeft()));
            Date comparableperiodend = DailyRecord.asDate((LocalDate)((LocalDate)previousrage.getRight()));
            Optional<DailyRecord> opt3 = this.getDailyRecord(DailyRecord.asLocalDate((Date)comparableperiodstart).minusDays(1L));
            Optional opt4 = this.getDailyRecord(comparableperiodend);
            if (!opt3.isPresent()) {
                opt3 = Optional.of(new DailyRecord());
            }
            DailyRecord previousstartdr = (DailyRecord)opt3.get();
            DailyRecord previousenddr = (DailyRecord)opt4.get();
            DailyRecord previousperiod = previousenddr.diff(previousstartdr);
            int foundinpreviousperiod = previousperiod.getTotalCountsByStatusAndReason();
            int resolvedinpreviousperiod = previousperiod.getTotalResolvedByCount();
            int outstandinginpreviousperiod = previousenddr.getTotalOutstandingByCount();
            HeroHeadlineNumbers.ChangeDataPoint matchesfoundagainstpast = new HeroHeadlineNumbers.ChangeDataPoint((double)foundinpreviousperiod, (double)foundinperiod);
            HeroHeadlineNumbers.ChangeDataPoint resolvedagainstpast = new HeroHeadlineNumbers.ChangeDataPoint((double)resolvedinpreviousperiod, (double)resolvedinperiod);
            HeroHeadlineNumbers.ChangeDataPoint outstandingagainstpast = new HeroHeadlineNumbers.ChangeDataPoint((double)outstandinginpreviousperiod, (double)outstandinginperiod);
            HeroHeadlineNumbers ret = new HeroHeadlineNumbers(foundinperiod, resolvedinperiod, outstandinginperiod, matchesfound, resolved, outstanding);
            ret.setComparableperiodexists(true);
            ret.setComparableperiodstart(comparableperiodstart);
            ret.setComparableperiodend(comparableperiodend);
            ret.setMatchesfoundagainstpast(matchesfoundagainstpast);
            ret.setResolvedagainstpast(resolvedagainstpast);
            ret.setOutstandingagainstpast(outstandingagainstpast);
            return ret;
        }
        return new HeroHeadlineNumbers(foundinperiod, resolvedinperiod, outstandinginperiod, matchesfound, resolved, outstanding);
    }

    private List<DailyRecord> fillEmptyValuesWithZero(List<DailyRecord> dailyrecords) {
        HashSet devicetypes = new HashSet();
        HashSet locations = new HashSet();
        HashSet patterns = new HashSet();
        HashSet namedareas = new HashSet();
        dailyrecords.stream().map(dr -> {
            devicetypes.addAll(dr.getCountByDeviceType().keySet());
            return dr;
        }).map(dr -> {
            locations.addAll(dr.getCountByLocation().keySet());
            return dr;
        }).map(dr -> {
            patterns.addAll(dr.getCountByPattern().keySet());
            return dr;
        }).forEachOrdered(dr -> namedareas.addAll(dr.getCountByNamedArea().keySet()));
        dailyrecords.stream().map(dr -> {
            devicetypes.forEach(d -> dr.getCountByDeviceType().putIfAbsent(d, 0));
            return dr;
        }).map(dr -> {
            locations.forEach(s -> dr.getCountByLocation().putIfAbsent(s, 0));
            return dr;
        }).map(dr -> {
            patterns.forEach(p -> dr.getCountByPattern().putIfAbsent(p, 0));
            return dr;
        }).forEachOrdered(dr -> namedareas.forEach(na -> dr.getCountByNamedArea().putIfAbsent(na, 0)));
        return dailyrecords;
    }

    private void truncatePatterns(List<DailyRecord> dailyrecords) {
        HashMap totals = new HashMap();
        dailyrecords.forEach(dr -> dr.getCountByPattern().entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            if (totals.containsKey(key)) {
                totals.put(key, (Integer)totals.get(key) + (Integer)entry.getValue());
            } else {
                totals.put(key, (Integer)entry.getValue());
            }
        }));
        LinkedHashMap sorted = totals.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        Set<Object> top5Patterns = new HashSet();
        if (sorted.size() <= 5) {
            top5Patterns = sorted.keySet();
        } else {
            Iterator iter = sorted.keySet().iterator();
            for (int i = 0; i < 5; ++i) {
                top5Patterns.add((String)iter.next());
            }
        }
        for (DailyRecord dr2 : dailyrecords) {
            dr2.removePatternsNotIn(top5Patterns);
        }
    }
}

