/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.managerdomain.domain.DailyRecordStored;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerpersistence.IDailyRecordRepository;
import com.geolang.ascema.managerpersistence.results.MatchesManager;
import com.geolang.ascema.managerservice.domain.DailyRecord;
import com.google.common.collect.Range;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DailyRecordGaps {
    private static final Logger LOG = Logger.getLogger(DailyRecordGaps.class.getName());
    private final List<Range<LocalDate>> finishedRecords = new ArrayList();
    private LocalDate yesterday;
    private final Map<LocalDate, DailyRecord> gaps = new HashMap();

    void insertRecordForDate(LocalDate date) {
        this.mergeRange(this.createRange(date));
    }

    void start() {
        this.yesterday = LocalDate.now().minus(1L, ChronoUnit.DAYS);
    }

    void check(MatchesManager mm, SearchResultStored sr, LocalDate eventDate, DeviceType dt, String location) {
        while (eventDate.isBefore(this.yesterday)) {
            if (!this.containsDate(eventDate)) {
                if (this.gaps.containsKey(eventDate)) {
                    List matches = mm.getDailyRecordMatches(sr.getId());
                    ((DailyRecord)this.gaps.get(eventDate)).record(matches, sr, dt, location);
                } else {
                    DailyRecord rec = new DailyRecord(eventDate);
                    List matches = mm.getDailyRecordMatches(sr.getId());
                    rec.record(matches, sr, dt, location);
                    this.gaps.put(eventDate, rec);
                }
            }
            eventDate = eventDate.plus(1L, ChronoUnit.DAYS);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=false)
    public void save(IDailyRecordRepository repo) {
        for (Map.Entry entry : this.gaps.entrySet()) {
            LOG.log(Level.INFO, "Filled gap in daily record for {0} -> {1}", new Object[]{entry.getKey(), entry.getValue()});
            DailyRecordStored stored = new DailyRecordStored((LocalDate)entry.getKey(), (DailyRecord)entry.getValue());
            repo.save((Object)stored);
            this.mergeRange(this.createRange((LocalDate)entry.getKey()));
        }
        this.gaps.clear();
    }

    boolean containsDate(LocalDate date) {
        return this.rangeContained(this.createRange(date));
    }

    private boolean rangeContained(Range<LocalDate> r) {
        for (Range interval : this.finishedRecords) {
            if (!interval.encloses(r)) continue;
            return true;
        }
        return false;
    }

    private void mergeRange(Range<LocalDate> toAdd) {
        boolean inrange = this.rangeContained(toAdd);
        if (inrange) {
            return;
        }
        ListIterator<Range> iter = this.finishedRecords.listIterator();
        while (iter.hasNext()) {
            Range r = (Range)iter.next();
            if (!r.isConnected(toAdd)) continue;
            iter.set(r.span(toAdd));
            return;
        }
        this.finishedRecords.add(toAdd);
    }

    private Range<LocalDate> createRange(LocalDate date) {
        return Range.closed((Comparable)date, (Comparable)date.plus(1L, ChronoUnit.DAYS));
    }

    int getRecordSize() {
        return this.finishedRecords.size();
    }
}

