/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.PlatformSubType;
import com.geolang.ascema.endpointcommon.domain.clouditems.AtlassianSpace;
import com.geolang.ascema.endpointcommon.domain.clouditems.BitbucketRepo;
import com.geolang.ascema.endpointcommon.domain.clouditems.CloudItemType;
import com.geolang.ascema.endpointcommon.domain.clouditems.JiraIssueSecurityLevel;
import com.geolang.ascema.endpointcommon.domain.clouditems.JiraProject;
import com.geolang.ascema.endpointcommon.domain.clouditems.MIPLabel;
import com.geolang.ascema.endpointcommon.messages.servernotification.GetAspectsServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.GetCloudItemsServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.GetCloudUsersServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerNotificationBase;
import com.geolang.ascema.indexingcommon.endpoint.alfresco.AspectTree;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.CloudCredentials;
import com.geolang.ascema.indexingcommon.endpoint.google.GoogleDriveLabel;
import com.geolang.ascema.managercore.MessageBus;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerevents.AlfrescoAspectsEvent;
import com.geolang.ascema.managerevents.AtlassianSpacesEvent;
import com.geolang.ascema.managerevents.BitBucketReposEvent;
import com.geolang.ascema.managerevents.CloudCredentialsChangeEvent;
import com.geolang.ascema.managerevents.CloudUsersAndGroupsEvent;
import com.geolang.ascema.managerevents.GoogleDriveLabelsEvent;
import com.geolang.ascema.managerevents.JiraProjectsEvent;
import com.geolang.ascema.managerevents.JiraSecuritySchemesEvent;
import com.geolang.ascema.managerevents.O365MipLabelsEvent;
import com.geolang.ascema.managerevents.SessionChangeEvent;
import com.geolang.ascema.managerservice.controllers.CloudItemsController;
import com.geolang.ascema.managerservice.controllers.devices.DeviceService;
import com.geolang.ascema.managerservice.persist.cloudcache.AlfrescoAspectCache;
import com.geolang.ascema.managerservice.persist.cloudcache.BitbucketRepoCache;
import com.geolang.ascema.managerservice.persist.cloudcache.CloudUserGroupCache;
import com.geolang.ascema.managerservice.persist.cloudcache.ConfluenceSpaceCache;
import com.geolang.ascema.managerservice.persist.cloudcache.GoogleDriveLabelsCache;
import com.geolang.ascema.managerservice.persist.cloudcache.JiraProjectCache;
import com.geolang.ascema.managerservice.persist.cloudcache.JiraSecuritySchemeCache;
import com.geolang.ascema.managerservice.persist.cloudcache.O365MipLabelsCache;
import com.geolang.ascema.managerservice.rest.requests.o365.CloudUsersAndGroups;
import com.google.common.eventbus.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CloudItemsController {
    private static final Logger LOG = Logger.getLogger(CloudItemsController.class.getName());
    @Autowired
    private DeviceService devicesService;
    @Autowired
    private AlfrescoAspectCache aspects;
    @Autowired
    private BitbucketRepoCache repos;
    @Autowired
    private CloudUserGroupCache usersAndGroups;
    @Autowired
    private ConfluenceSpaceCache spaces;
    @Autowired
    private JiraProjectCache projects;
    @Autowired
    private JiraSecuritySchemeCache securitySchemes;
    @Autowired
    private GoogleDriveLabelsCache googleLabels;
    @Autowired
    private O365MipLabelsCache mipLabels;
    private final ScheduledExecutorService schedulerExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Map<String, ScheduledFuture<?>> agentToScheduledRefresh = new HashMap();

    @PostConstruct
    public void init() throws Exception {
        MessageBus.getBus().register((Object)this);
    }

    @PreDestroy
    public void destroy() throws Exception {
        MessageBus.getBus().unregister((Object)this);
        this.schedulerExecutor.shutdownNow();
    }

    @Subscribe
    void handleAvailableUsersAndGroups(CloudUsersAndGroupsEvent ev) {
        this.usersAndGroups.add(ev);
    }

    @Subscribe
    void handleAvailableSpaces(AtlassianSpacesEvent ev) {
        this.spaces.add(ev);
    }

    @Subscribe
    void handleJiraProjectsAvailable(JiraProjectsEvent ev) {
        this.projects.add(ev);
    }

    @Subscribe
    void handleJiraSecuritySchemesAvailable(JiraSecuritySchemesEvent ev) {
        this.securitySchemes.add(ev);
    }

    @Subscribe
    void handleBitbucketReposAvailable(BitBucketReposEvent ev) {
        this.repos.add(ev);
    }

    @Subscribe
    void handleNewAspects(AlfrescoAspectsEvent ev) {
        this.aspects.add(ev);
    }

    @Subscribe
    void handleGoogleLabels(GoogleDriveLabelsEvent ev) {
        this.googleLabels.add(ev);
    }

    @Subscribe
    void handleMipLabels(O365MipLabelsEvent ev) {
        this.mipLabels.add(ev);
    }

    @Subscribe
    void handleSessionChange(SessionChangeEvent ev) {
        LOG.log(Level.INFO, "session change {0}", ev.getReason());
        switch (1.$SwitchMap$com$geolang$ascema$managerevents$SessionChangeEvent$Reason[ev.getReason().ordinal()]) {
            case 1: 
            case 2: {
                Optional opt = this.devicesService.getDeviceFromId(ev.getDeviceId(), false);
                if (!opt.isPresent()) break;
                DeviceRegistration agent = (DeviceRegistration)opt.get();
                LOG.log(Level.INFO, "session change to {0} fetch cloud items if needed", ev.getReason());
                this.scheduleRefresh(agent);
                break;
            }
            case 3: 
            case 4: {
                if (!this.agentToScheduledRefresh.containsKey(ev.getDeviceId())) break;
                ((ScheduledFuture)this.agentToScheduledRefresh.get(ev.getDeviceId())).cancel(true);
                this.agentToScheduledRefresh.remove(ev.getDeviceId());
                break;
            }
        }
    }

    @Subscribe
    void handleCloudCredentialsChange(CloudCredentialsChangeEvent ev) {
        LOG.log(Level.INFO, "credential change for {0} fetch cloud items if needed", ev.getDeviceRegistration().getDeviceId());
        if (ev.getOldCredentials().isPresent()) {
            this.clearCachesForHost(((CloudCredentials)ev.getOldCredentials().get()).getHost());
        }
        this.scheduleRefresh(ev.getDeviceRegistration());
    }

    private void sendForItems(DeviceRegistration agent) {
        LOG.log(Level.INFO, "Send for items {0} of type {1}", new Object[]{agent.getHostname(), agent.getDeviceType()});
        switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$DeviceType[agent.getDeviceType().ordinal()]) {
            case 1: {
                this.devicesService.getOutQueue().sendMessage(agent.getDeviceId(), (ServerNotificationBase)new GetAspectsServerMessage(), false);
                break;
            }
            case 2: {
                Set types = agent.getDeviceSubTypesCollection();
                for (PlatformSubType sub : types) {
                    boolean getUsers = false;
                    switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$PlatformSubType[sub.ordinal()]) {
                        case 1: {
                            this.devicesService.getOutQueue().sendMessage(agent.getDeviceId(), (ServerNotificationBase)new GetCloudItemsServerMessage(CloudItemType.BITBUCKET_REPO), false);
                            break;
                        }
                        case 2: {
                            this.devicesService.getOutQueue().sendMessage(agent.getDeviceId(), (ServerNotificationBase)new GetCloudItemsServerMessage(CloudItemType.CONFLUENCE_SPACE), false);
                            getUsers = true;
                            break;
                        }
                        case 3: {
                            this.devicesService.getOutQueue().sendMessage(agent.getDeviceId(), (ServerNotificationBase)new GetCloudItemsServerMessage(CloudItemType.JIRA_PROJECT), false);
                            this.devicesService.getOutQueue().sendMessage(agent.getDeviceId(), (ServerNotificationBase)new GetCloudItemsServerMessage(CloudItemType.JIRA_SECURITY_LEVEL), false);
                            getUsers = true;
                        }
                    }
                    if (!getUsers) continue;
                    this.usersAndGroups.loadFromStoreIfEmpty(agent);
                    this.devicesService.getOutQueue().sendMessage(agent.getDeviceId(), (ServerNotificationBase)new GetCloudUsersServerMessage(DeviceType.ATLASSIAN), false);
                }
                break;
            }
            case 3: {
                this.usersAndGroups.loadFromStoreIfEmpty(agent);
                this.devicesService.getOutQueue().sendMessage(agent.getDeviceId(), (ServerNotificationBase)new GetCloudUsersServerMessage(DeviceType.GOOGLE), false);
                this.devicesService.getOutQueue().sendMessage(agent.getDeviceId(), (ServerNotificationBase)new GetCloudItemsServerMessage(CloudItemType.GOOGLE_DRIVE_LABELS), false);
                break;
            }
            case 4: {
                this.usersAndGroups.loadFromStoreIfEmpty(agent);
                this.devicesService.getOutQueue().sendMessage(agent.getDeviceId(), (ServerNotificationBase)new GetCloudUsersServerMessage(DeviceType.O365), false);
                this.devicesService.getOutQueue().sendMessage(agent.getDeviceId(), (ServerNotificationBase)new GetCloudItemsServerMessage(CloudItemType.MIP_LABEL), false);
                break;
            }
            default: {
                LOG.log(Level.INFO, "nothing to do for {0}", agent.getDeviceType());
            }
        }
    }

    public boolean forceCacheRefreshNow(String deviceId) {
        LOG.info("Force refresh");
        Optional opt = this.devicesService.getDeviceFromId(deviceId, false);
        if (opt.isPresent()) {
            DeviceRegistration agent = (DeviceRegistration)opt.get();
            this.sendForItems(agent);
            return true;
        }
        return false;
    }

    public void clearCachesForHost(String host) {
        this.usersAndGroups.clearForHost(host);
        this.spaces.clearForHost(host);
        this.projects.clearForHost(host);
        this.securitySchemes.clearForHost(host);
        this.repos.clearForHost(host);
        this.aspects.clearForHost(host);
        this.googleLabels.clearForHost(host);
        this.mipLabels.clearForHost(host);
    }

    public CloudUsersAndGroups getUsersAndGroupsForHost(String host) {
        return this.usersAndGroups.getUsersAndGroupsForHost(host);
    }

    public List<AtlassianSpace> getSpacesForHost(String host) {
        return this.spaces.getForHost(host);
    }

    public List<JiraProject> getProjectsForHost(String host) {
        return this.projects.getForHost(host);
    }

    public List<JiraIssueSecurityLevel> getSchemesForHost(String host) {
        return this.securitySchemes.getForHost(host);
    }

    public List<BitbucketRepo> getReposForHost(String host) {
        return this.repos.getForHost(host);
    }

    public AspectTree getAspectsForHost(String host) {
        return this.aspects.getForHost(host);
    }

    public List<GoogleDriveLabel> getGoogleLabelsForHost(String host) {
        return this.googleLabels.getForHost(host);
    }

    public List<MIPLabel> getO365MipLabelsForHost(String host) {
        return this.mipLabels.getForHost(host);
    }

    public List<MIPLabel> getDefaultMipLabels() {
        return this.mipLabels.getDefault();
    }

    private void scheduleRefresh(DeviceRegistration agent) {
        if (this.agentToScheduledRefresh.containsKey(agent.getDeviceId())) {
            ((ScheduledFuture)this.agentToScheduledRefresh.get(agent.getDeviceId())).cancel(true);
            this.agentToScheduledRefresh.remove(agent.getDeviceId());
            LOG.log(Level.INFO, "Cancel old schedule for {0}", agent.getHostname());
        }
        if (agent.getDeviceType().isCloud()) {
            LOG.log(Level.INFO, "Schedule cloud items for {0}", agent.getHostname());
            this.agentToScheduledRefresh.put(agent.getDeviceId(), this.schedulerExecutor.scheduleAtFixedRate(() -> this.sendForItems(agent), 10L, 21600L, TimeUnit.SECONDS));
        }
    }
}

