/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import jakarta.annotation.PostConstruct;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.stereotype.Service;

@Service
public class BuildVersion {
    private static final Logger LOG = Logger.getLogger(BuildVersion.class.getName());
    private String buildVersion;
    private String buildVersionAtTime;
    private String isoTime;
    @Autowired
    private BuildProperties buildProps;

    @PostConstruct
    public void init() {
        String timeMillis;
        this.buildVersion = this.buildProps.getVersion();
        if (this.buildVersion == null) {
            this.buildVersion = "unknown";
        }
        if ((timeMillis = this.buildProps.get("time")) == null) {
            timeMillis = "";
        }
        this.buildVersionAtTime = this.buildVersion + "@" + timeMillis;
        try {
            Instant instant = Instant.ofEpochMilli(Long.parseLong(timeMillis));
            this.isoTime = instant.toString();
            this.buildVersionAtTime = this.buildVersion + "@" + this.isoTime;
        }
        catch (NumberFormatException | DateTimeException ex) {
            LOG.warning(ex.getMessage());
            this.isoTime = "";
        }
        LOG.log(Level.INFO, "Build Version {0}", this.buildVersionAtTime);
    }

    public String getBuildVersionAtTime() {
        return this.buildVersionAtTime;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public String getIsoTime() {
        return this.isoTime;
    }
}

