/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.PlatformSubType;
import com.geolang.ascema.endpointcommon.domain.clouditems.CloudItemType;
import com.geolang.ascema.endpointcommon.messages.servernotification.CheckAtlassianPathServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.GetCloudItemsServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerNotificationBase;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerpersistence.EndpointStore;
import com.geolang.ascema.managerservice.controllers.ServerMessagesOutQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AtlassianEndpointService {
    @Autowired
    private EndpointStore endpointStore;
    @Autowired
    private ServerMessagesOutQueue outQueue;

    public boolean checkAtlassianPath(String path) {
        boolean ret = false;
        for (DeviceRegistration reg : this.endpointStore.getAll(true, false)) {
            ServerMessagesOutQueue.Status status;
            if (!reg.getDeviceType().equals((Object)DeviceType.ATLASSIAN)) continue;
            Future statusFut = this.outQueue.sendMessage(reg.getDeviceId(), (ServerNotificationBase)new CheckAtlassianPathServerMessage(path), false);
            try {
                status = (ServerMessagesOutQueue.Status)statusFut.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                Logger.getLogger(AtlassianEndpointService.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            if (!status.equals((Object)ServerMessagesOutQueue.Status.SENT)) continue;
            ret = true;
        }
        return ret;
    }

    public void getSpaces() {
        for (DeviceRegistration reg : this.endpointStore.getAll(true, false)) {
            if (!reg.getDeviceType().equals((Object)DeviceType.ATLASSIAN) || !reg.getDeviceSubTypesCollection().contains(PlatformSubType.CONFLUENCE)) continue;
            this.outQueue.sendMessage(reg.getDeviceId(), (ServerNotificationBase)new GetCloudItemsServerMessage(CloudItemType.CONFLUENCE_SPACE), false);
        }
    }

    public void getProjects() {
        for (DeviceRegistration reg : this.endpointStore.getAll(true, false)) {
            if (!reg.getDeviceType().equals((Object)DeviceType.ATLASSIAN) || !reg.getDeviceSubTypesCollection().contains(PlatformSubType.JIRA)) continue;
            this.outQueue.sendMessage(reg.getDeviceId(), (ServerNotificationBase)new GetCloudItemsServerMessage(CloudItemType.JIRA_PROJECT), false);
        }
    }

    public void getJiraSecuritySchemes() {
        for (DeviceRegistration reg : this.endpointStore.getAll(true, false)) {
            if (!reg.getDeviceType().equals((Object)DeviceType.ATLASSIAN) || !reg.getDeviceSubTypesCollection().contains(PlatformSubType.JIRA)) continue;
            this.outQueue.sendMessage(reg.getDeviceId(), (ServerNotificationBase)new GetCloudItemsServerMessage(CloudItemType.JIRA_SECURITY_LEVEL), false);
        }
    }

    public void getBitbucketRepos() {
        for (DeviceRegistration reg : this.endpointStore.getAll(true, false)) {
            if (!reg.getDeviceType().equals((Object)DeviceType.ATLASSIAN) || !reg.getDeviceSubTypesCollection().contains(PlatformSubType.BITBUCKET)) continue;
            this.outQueue.sendMessage(reg.getDeviceId(), (ServerNotificationBase)new GetCloudItemsServerMessage(CloudItemType.BITBUCKET_REPO), false);
        }
    }
}

