/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.messages.servernotification.CheckPathServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.GetAspectsServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerNotificationBase;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerpersistence.EndpointStore;
import com.geolang.ascema.managerservice.controllers.ServerMessagesOutQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlfrescoEndpointService {
    @Autowired
    private EndpointStore endpointStore;
    @Autowired
    private ServerMessagesOutQueue outQueue;

    public boolean checkAlfrescoPath(String path) {
        boolean ret = false;
        for (DeviceRegistration reg : this.endpointStore.getAll(true, false)) {
            ServerMessagesOutQueue.Status status;
            if (!reg.getDeviceType().equals((Object)DeviceType.ALFRESCO)) continue;
            Future statusFut = this.outQueue.sendMessage(reg.getDeviceId(), (ServerNotificationBase)new CheckPathServerMessage(path), false);
            try {
                status = (ServerMessagesOutQueue.Status)statusFut.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                Logger.getLogger(AlfrescoEndpointService.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            if (!status.equals((Object)ServerMessagesOutQueue.Status.SENT)) continue;
            ret = true;
        }
        return ret;
    }

    public void getAspects() {
        for (DeviceRegistration reg : this.endpointStore.getAll(true, false)) {
            if (!reg.getDeviceType().equals((Object)DeviceType.ALFRESCO)) continue;
            Future future = this.outQueue.sendMessage(reg.getDeviceId(), (ServerNotificationBase)new GetAspectsServerMessage(), false);
        }
    }
}

