/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.controllers;

import com.geolang.ascema.endpointcommon.domain.AlertMsg;
import com.geolang.ascema.endpointcommon.domain.AlertingConfig;
import com.geolang.ascema.endpointcommon.domain.AlertingType;
import com.geolang.ascema.endpointcommon.domain.BaseCommand;
import com.geolang.ascema.endpointcommon.domain.ConfiguredAlertMethods;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.searchconfig.AtlassianSearchConfiguration;
import com.geolang.ascema.endpointcommon.domain.searchconfig.IRouteableSearchConfig;
import com.geolang.ascema.endpointcommon.emailalerts.EmailFormatter;
import com.geolang.ascema.endpointcommon.emailalerts.EmailToSend;
import com.geolang.ascema.endpointcommon.messages.servernotification.AlertServerMessage;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerNotificationBase;
import com.geolang.ascema.endpointcommon.messages.servernotification.ServerUIDetails;
import com.geolang.ascema.indexingcommon.endpoint.cloudcommon.CloudUser;
import com.geolang.ascema.indexingcommon.endpoint.o365.CloudEmailAlertConfig;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerdomain.web.SMTPSettings;
import com.geolang.ascema.managerpersistence.CloudUserMappingStore;
import com.geolang.ascema.managerpersistence.EndpointStore;
import com.geolang.ascema.managerpersistence.TaskStore;
import com.geolang.ascema.managerservice.auditlog.AuditLogService;
import com.geolang.ascema.managerservice.controllers.AlertingController;
import com.geolang.ascema.managerservice.controllers.MailSender;
import com.geolang.ascema.managerservice.controllers.ProxySettings;
import com.geolang.ascema.managerservice.controllers.ServerMessagesOutQueue;
import com.geolang.ascema.managerservice.controllers.tasks.TaskManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AlertingController {
    private static final Logger LOG = Logger.getLogger(AlertingController.class.getName());
    @Autowired
    private ServerMessagesOutQueue outQueue;
    @Autowired
    private EndpointStore endpointStore;
    @Autowired
    private TaskStore taskStore;
    @Lazy
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private AuditLogService auditLog;
    @Autowired
    private CloudUserMappingStore cloudUserMappingStore;
    private final SettingsFile settings = SettingsFile.getInstance();
    private EmailFormatter emailFormatter;

    public AlertingController() {
        try {
            this.emailFormatter = new EmailFormatter(WorkingFolder.getWorkingFolder());
        }
        catch (IOException ex) {
            Logger.getLogger(AlertingController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String getGenericTitle() {
        return this.settings.getDefaultAlertSubject();
    }

    public void sendAutomatedAlertToEndpoint(String taskId, String deviceId) {
        ServerUIDetails uidetails = ProxySettings.getUIDetails((String)deviceId);
        String body = this.getAlertBodyText(DeviceType.ENDPOINT);
        this.alertEndpoint(taskId, deviceId, new AlertMsg(this.getGenericTitle(), body), uidetails);
    }

    public boolean sendAutomatedAlertForAlfresco(String taskId, String deviceId) {
        String emailbody = this.getAlertBodyText(DeviceType.ALFRESCO);
        ConfiguredAlertMethods config = this.getConfigSettings();
        if (config.isAlertByEmail()) {
            Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
            if (!opt.isPresent()) {
                LOG.log(Level.INFO, "Not sending email to user - no registration {0}", deviceId);
                return false;
            }
            DeviceRegistration dr = (DeviceRegistration)opt.get();
            String email = dr.getUserEmail();
            if (email == null || email.isEmpty()) {
                LOG.log(Level.INFO, "Not sending email to user - no email address {0}", dr.getDeviceDescription());
                return false;
            }
            ServerUIDetails details = ProxySettings.getUIDetails((String)deviceId);
            return this.sendEmail(this.taskManager, taskId, deviceId, email, this.getGenericTitle(), emailbody, details.getUrlForAlfrescoReport());
        }
        return false;
    }

    public void alertEndpoint(String taskId, String deviceId, AlertMsg alert, ServerUIDetails uidetails) {
        ConfiguredAlertMethods config = this.getConfigSettings();
        this.alertEndpoint(taskId, deviceId, new AlertServerMessage(config, alert, uidetails));
    }

    public void alertEndpoint(String deviceId, AlertMsg alert, ServerUIDetails uidetails) {
        this.alertEndpoint(null, deviceId, alert, uidetails);
    }

    public void alertEndpoint(String deviceId, AlertServerMessage msg) {
        this.doAction(deviceId, msg);
    }

    public void alertEndpoint(String taskId, String deviceId, AlertServerMessage msg) {
        this.doAction(taskId, deviceId, msg);
    }

    public void alertMultipleEndpoint(List<String> deviceIds, AlertMsg alert) {
        this.alertMultipleEndpoint(null, deviceIds, alert);
    }

    public void alertMultipleEndpoint(String taskId, List<String> deviceIds, AlertMsg alert) {
        ConfiguredAlertMethods config = this.getConfigSettings();
        for (String deviceId : deviceIds) {
            this.doAction(taskId, deviceId, new AlertServerMessage(config, alert, ProxySettings.getUIDetails((String)deviceId)));
        }
    }

    public void alertMultipleCloudUsers(String deviceId, AlertMsg alert, List<String> userids) {
        ConfiguredAlertMethods config = this.getConfigSettings();
        if (config.isAlertByO365Email()) {
            this.alertMultipleViaAgentEmail(config, deviceId, alert, userids, DeviceType.O365);
        }
        if (config.isAlertByGmail()) {
            this.alertMultipleViaAgentEmail(config, deviceId, alert, userids, DeviceType.GOOGLE);
        }
    }

    public boolean sendAutomatedAlertForCloud(String deviceId, Set<String> userIds, DeviceType type) {
        ConfiguredAlertMethods config = this.getConfigSettings();
        if (config.isAlertByO365Email() || config.isAlertByGmail()) {
            return this.sendAutomatedAlertViaAgentEmail(config, deviceId, userIds, type);
        }
        if (config.isAlertByEmail()) {
            String emailbody = this.getAlertBodyText(type);
            Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
            if (!opt.isPresent()) {
                LOG.log(Level.INFO, "Not sending email to user - no registration {0}", deviceId);
                return false;
            }
            HashSet<CloudUser> userEmails = new HashSet<CloudUser>();
            for (String userId : userIds) {
                if (userId == null || userId.isEmpty()) continue;
                Optional email = this.cloudUserMappingStore.getEmailForUUID(userId);
                if (email.isEmpty() || !((CloudUserMappingStore.PossibleEmail)email.get()).isEmail()) {
                    LOG.log(Level.WARNING, "No email for user id {0}", userId);
                    continue;
                }
                userEmails.add(new CloudUser("", ((CloudUserMappingStore.PossibleEmail)email.get()).email(), userId, ""));
            }
            ServerUIDetails details = ProxySettings.getUIDetails((String)deviceId);
            for (CloudUser cu : userEmails) {
                String link = details.getLink(cu.getId(), type);
                this.sendEmail(this.taskManager, null, deviceId, cu.getEmail(), this.getGenericTitle(), emailbody, link);
            }
            return true;
        }
        return false;
    }

    public boolean sendAutomatedAlertForAtlassian(String taskId, String deviceId, List<SearchResultStored> stored, Optional<AtlassianSearchConfiguration> searchConfigOpt) {
        ConfiguredAlertMethods config = this.getConfigSettings();
        if (!config.isAlertByEmail()) {
            return false;
        }
        AlertingConfig alertConfig = new AlertingConfig(AlertingType.FILE_OWNER, "");
        if (searchConfigOpt.isPresent()) {
            alertConfig = searchConfigOpt.get().getAlertConfig();
        }
        ServerUIDetails uidetails = ProxySettings.getUIDetails((String)deviceId);
        HashMap emails = new HashMap();
        for (SearchResultStored sr : stored) {
            String email = null;
            if (sr.getUserId() == null || sr.getUserId().isEmpty()) continue;
            Optional emailOpt = this.cloudUserMappingStore.getEmailForUUID(sr.getUserId());
            if ((emailOpt.isEmpty() || !((CloudUserMappingStore.PossibleEmail)emailOpt.get()).isEmail()) && alertConfig.getType().equals((Object)AlertingType.FILE_OWNER)) {
                LOG.log(Level.WARNING, "No email for user {0}", sr.getUserId());
                continue;
            }
            email = ((CloudUserMappingStore.PossibleEmail)emailOpt.get()).email();
            String bodytext = this.getAtlassianBodyText(alertConfig.getType(), email, sr.getNamedArea().getDisplayName());
            String link = uidetails.getUrlForAtlassian(sr.getUserId());
            AlertingType type = alertConfig.getType();
            switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$AlertingType[type.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    email = alertConfig.getValue();
                    break;
                }
                case 3: {
                    email = sr.getTopLevelAlertingEmail();
                    break;
                }
            }
            if (email != null) {
                String[] arr;
                for (String em : arr = email.split(",")) {
                    Map byTypeMap;
                    if (!emails.containsKey(em)) {
                        emails.put(em, new HashMap());
                    }
                    if (!(byTypeMap = (Map)emails.get(em)).containsKey(type)) {
                        byTypeMap.put(type, new HashSet());
                    }
                    ((Set)byTypeMap.get(type)).add(new EmailToSend(em, link, this.getGenericTitle(), bodytext, sr.getNamedArea().getDisplayName()));
                }
                continue;
            }
            LOG.warning("No email found for search result");
        }
        this.sendMultipleEmail(taskId, deviceId, emails);
        return true;
    }

    public void alertMultipleAtlassianUsers(String deviceId, AlertMsg alert, List<SearchResultStored> results) {
        ConfiguredAlertMethods config = this.getConfigSettings();
        if (!config.isAlertByEmail()) {
            return;
        }
        AlertingConfig alertConfig = new AlertingConfig(AlertingType.FILE_OWNER, "");
        HashMap emails = new HashMap();
        Map<String, List<SearchResultStored>> byTaskId = results.stream().collect(Collectors.groupingBy(s -> s.getTaskInstanceId()));
        for (Map.Entry<String, List<SearchResultStored>> entry : byTaskId.entrySet()) {
            Optional searchConfig;
            TaskInstance ti;
            BaseCommand bc;
            String taskId = entry.getKey();
            List<SearchResultStored> srs = entry.getValue();
            Optional tiOpt = this.taskStore.getTaskInstanceFromId(taskId);
            if (tiOpt.isPresent() && (bc = (ti = (TaskInstance)tiOpt.get()).getCommand()).getRoutableConfig().isPresent() && (searchConfig = ((IRouteableSearchConfig)bc.getRoutableConfig().get()).getAtlassianConfig()).isPresent()) {
                alertConfig = ((AtlassianSearchConfiguration)searchConfig.get()).getAlertConfig();
            }
            LOG.log(Level.INFO, "{0} events alert for {1}", new Object[]{results.size(), alertConfig});
            ServerUIDetails uidetails = ProxySettings.getUIDetails((String)deviceId);
            for (SearchResultStored sr : srs) {
                String email = null;
                if (sr.getUserId() == null || sr.getUserId().isEmpty()) continue;
                Optional emailOpt = this.cloudUserMappingStore.getEmailForUUID(sr.getUserId());
                if ((emailOpt.isEmpty() || !((CloudUserMappingStore.PossibleEmail)emailOpt.get()).isEmail()) && alertConfig.getType().equals((Object)AlertingType.FILE_OWNER)) {
                    LOG.log(Level.WARNING, "No userId {0}", sr.getUserId());
                    continue;
                }
                email = ((CloudUserMappingStore.PossibleEmail)emailOpt.get()).email();
                String title = alert.getTitle();
                String bodytext = alert.getBody();
                String link = uidetails.getUrlForAtlassian(sr.getUserId());
                AlertingType type = alertConfig.getType();
                switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$AlertingType[type.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        email = alertConfig.getValue();
                        break;
                    }
                    case 3: {
                        email = sr.getTopLevelAlertingEmail();
                        break;
                    }
                }
                if (email != null) {
                    String[] arr;
                    for (String em : arr = email.split(",")) {
                        Map byTypeMap;
                        if (!emails.containsKey(em)) {
                            emails.put(em, new HashMap());
                        }
                        if (!(byTypeMap = (Map)emails.get(em)).containsKey(type)) {
                            byTypeMap.put(type, new HashSet());
                        }
                        ((Set)byTypeMap.get(type)).add(new EmailToSend(email, link, title, bodytext, sr.getNamedArea().getDisplayName()));
                    }
                    continue;
                }
                LOG.warning("No email found for search result");
            }
        }
        this.sendMultipleEmail(null, deviceId, emails);
    }

    private void sendMultipleEmail(String taskId, String deviceId, Map<String, Map<AlertingType, Set<EmailToSend>>> emailsToUsers) {
        for (String email : emailsToUsers.keySet()) {
            Map<AlertingType, Set<EmailToSend>> byTypeMap = emailsToUsers.get(email);
            block5: for (Map.Entry<AlertingType, Set<EmailToSend>> entry : byTypeMap.entrySet()) {
                AlertingType type = entry.getKey();
                Set<EmailToSend> toSend = entry.getValue();
                if (toSend.isEmpty()) continue;
                switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$AlertingType[type.ordinal()]) {
                    case 1: {
                        for (EmailToSend e : toSend) {
                            this.sendEmail(this.taskManager, taskId, deviceId, email, e.getTitle(), e.getBodytext(), e.getLink());
                        }
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        EmailToSend first = toSend.iterator().next();
                        String title = first.getTitle();
                        String bodywrap = this.getAtlassianTopLevelText(type, toSend.size(), first.getArea());
                        String body = this.emailFormatter.getPlainTextEmailBodyMultiple(bodywrap, toSend);
                        String htmlbody = this.emailFormatter.getHtmlEmailBodyMultiple(bodywrap, toSend);
                        boolean emailSendStatus = MailSender.send((SMTPSettings)MailSender.getStoredSettings(), (String)email, (String)title, (String)body, (String)htmlbody);
                        this.auditLog.logAlertNotification(this.taskManager, taskId, deviceId, email, emailSendStatus);
                    }
                }
            }
        }
    }

    private boolean sendEmail(TaskManager taskManager, String taskId, String deviceId, String email, String title, String bodytext, String link) {
        String body = this.emailFormatter.getPlainTextEmailBody(bodytext, link);
        String htmlbody = this.emailFormatter.getHtmlEmailBody(bodytext, link);
        boolean emailSendStatus = MailSender.send((SMTPSettings)MailSender.getStoredSettings(), (String)email, (String)title, (String)body, (String)htmlbody);
        this.auditLog.logAlertNotification(taskManager, taskId, deviceId, email, emailSendStatus);
        return emailSendStatus;
    }

    public void saveConfig(ConfiguredAlertMethods b) {
        this.settings.setAlertByEmail(b.isAlertByEmail());
        this.settings.setAlertByPopup(b.isAlertByPopup());
        this.settings.setAlertByO365Email(b.isAlertByO365Email());
        this.settings.setAlertByGmail(b.isAlertByGmail());
        this.settings.setContinueToAlert(b.isRepeatAlerts());
    }

    public ConfiguredAlertMethods getConfigSettings() {
        ConfiguredAlertMethods config = new ConfiguredAlertMethods();
        config.setAlertByEmail(this.settings.getAlertByEmail());
        config.setAlertByPopup(this.settings.getAlertByPopup());
        config.setAlertByO365Email(this.settings.getAlertByO365Email());
        config.setAlertByGmail(this.settings.getAlertByGmail());
        config.setRepeatAlerts(this.settings.getContinueToAlert());
        return config;
    }

    private void doAction(String taskId, String deviceId, AlertServerMessage message) {
        ConfiguredAlertMethods config = message.getAlertConfig();
        if (message.isIsO365() && message.getAlertConfig().isAlertByO365Email()) {
            this.alertViaAgent(deviceId, message);
        }
        if (message.isIsGoogle() && message.getAlertConfig().isAlertByGmail()) {
            this.alertViaAgent(deviceId, message);
        }
        if (config.isAlertByPopup()) {
            this.alertViaAgent(deviceId, message);
        }
        if (config.isAlertByEmail()) {
            Optional opt = this.endpointStore.getDeviceRegFromId(deviceId, false, true);
            if (!opt.isPresent()) {
                LOG.log(Level.INFO, "Not sending email to user - no registration {0}", deviceId);
                return;
            }
            DeviceRegistration dr = (DeviceRegistration)opt.get();
            String email = dr.getUserEmail();
            if (email == null || email.isEmpty()) {
                LOG.log(Level.INFO, "Not sending email to user - no email address {0}", dr.getDeviceDescription());
                return;
            }
            ServerUIDetails details = ProxySettings.getUIDetails((String)deviceId);
            String link = details.getUrlForDeviceReport();
            this.sendEmail(this.taskManager, taskId, deviceId, email, message.getAlertMsg().getTitle(), message.getAlertMsg().getBody(), link);
        }
    }

    private void doAction(String deviceId, AlertServerMessage message) {
        this.doAction(null, deviceId, message);
    }

    private String getAtlassianTopLevelText(AlertingType type, int count, String area) {
        switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$AlertingType[type.ordinal()]) {
            case 1: 
            case 4: {
                return "";
            }
            case 2: {
                if (count == 1) {
                    return "A user has sensitive data in their " + area + " account. Their report is linked.";
                }
                return count + " users have sensitive data in their " + area + "  account. Their reports are linked.";
            }
            case 3: {
                if (count == 1) {
                    return "A user has sensitive data in an " + area + "  account you administer. Their report is linked.";
                }
                return count + " users have sensitive data in an " + area + "  account you administer. Their reports are linked.";
            }
        }
        return "";
    }

    private String getAtlassianBodyText(AlertingType type, String email, String area) {
        if (email == null) {
            email = "";
        }
        switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$AlertingType[type.ordinal()]) {
            case 1: 
            case 4: {
                return "You have sensitive data in your " + area + "  account. Please view your report for further details.";
            }
            case 2: {
                return email;
            }
            case 3: {
                return email;
            }
        }
        return "";
    }

    private String getAlertBodyText(DeviceType type) {
        switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$DeviceType[type.ordinal()]) {
            case 1: {
                return "You have sensitive data in your O365 account. Please view your report for further details.";
            }
            case 2: {
                return "You have sensitive data in your GSuite account. Please view your report for further details.";
            }
            case 3: {
                return "You have sensitive data in Alfresco. Please view your report for further details";
            }
            case 4: 
            case 5: {
                return "You have sensitive data on your device. Please view your report for further details";
            }
            case 6: {
                return "You have sensitive data in your Atlassian account. Please view your report for further details.";
            }
        }
        return "";
    }

    private boolean sendAutomatedAlertViaAgentEmail(ConfiguredAlertMethods config, String deviceId, Set<String> userIds, DeviceType type) {
        if (config.isAlertByO365Email() || config.isAlertByGmail()) {
            ServerUIDetails uidetails = ProxySettings.getUIDetails((String)deviceId);
            HashSet<CloudUser> userEmails = new HashSet<CloudUser>();
            for (String userId : userIds) {
                if (userId == null || userId.isEmpty()) continue;
                Optional email = this.cloudUserMappingStore.getEmailForUUID(userId);
                if (email.isEmpty() || !((CloudUserMappingStore.PossibleEmail)email.get()).isEmail()) {
                    LOG.log(Level.WARNING, "No email for user id {0}", userId);
                    continue;
                }
                userEmails.add(new CloudUser("", ((CloudUserMappingStore.PossibleEmail)email.get()).email(), userId, ""));
            }
            String body = this.getAlertBodyText(type);
            CloudEmailAlertConfig cloudConfig = new CloudEmailAlertConfig();
            cloudConfig.setUsers(new ArrayList(userEmails));
            switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$DeviceType[type.ordinal()]) {
                case 1: {
                    cloudConfig.setFromEmail(this.settings.getO365AlertFrom());
                    cloudConfig.setCcEmail(this.settings.getO365AlertCC());
                    break;
                }
                case 2: {
                    cloudConfig.setFromEmail("dummy");
                    cloudConfig.setCcEmail(this.settings.getGmailAlertCC());
                    break;
                }
            }
            return this.alertViaAgent(deviceId, new AlertServerMessage(config, new AlertMsg(this.getGenericTitle(), body), uidetails, cloudConfig));
        }
        return false;
    }

    private void alertMultipleViaAgentEmail(ConfiguredAlertMethods config, String deviceId, AlertMsg alert, List<String> userids, DeviceType type) {
        if (config.isAlertByO365Email() || config.isAlertByGmail()) {
            ArrayList<CloudUser> users = new ArrayList<CloudUser>();
            for (String id : userids) {
                if (id == null || id.isEmpty()) continue;
                Optional email = this.cloudUserMappingStore.getEmailForUUID(id);
                if (email.isEmpty() || !((CloudUserMappingStore.PossibleEmail)email.get()).isEmail()) {
                    LOG.log(Level.WARNING, "No email for userId {0}", id);
                    continue;
                }
                users.add(new CloudUser("", ((CloudUserMappingStore.PossibleEmail)email.get()).email(), id, ""));
            }
            CloudEmailAlertConfig cloudConfig = new CloudEmailAlertConfig();
            cloudConfig.setUsers(users);
            switch (1.$SwitchMap$com$geolang$ascema$endpointcommon$domain$DeviceType[type.ordinal()]) {
                case 1: {
                    cloudConfig.setFromEmail(this.settings.getO365AlertFrom());
                    cloudConfig.setCcEmail(this.settings.getO365AlertCC());
                    break;
                }
                case 2: {
                    cloudConfig.setFromEmail("dummy");
                    cloudConfig.setCcEmail(this.settings.getGmailAlertCC());
                    break;
                }
            }
            this.alertViaAgent(deviceId, new AlertServerMessage(config, alert, ProxySettings.getUIDetails((String)deviceId), cloudConfig));
        }
    }

    private boolean alertViaAgent(String deviceId, AlertServerMessage msg) {
        this.outQueue.sendMessage(deviceId, (ServerNotificationBase)msg, false);
        return true;
    }
}

