/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.auditlog;

import java.util.Random;

/*
 * Exception performing whole class analysis ignored.
 */
public class ULID {
    public static final int ULID_LENGTH = 26;
    public static final int ULID_BINARY_LENGTH = 16;
    public static final int ENTROPY_LENGTH = 10;
    public static final long MIN_TIME = 0L;
    public static final long MAX_TIME = 0xFFFFFFFFFFFFL;
    private static final char[] C = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private static final byte[] V = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, -1, 18, 19, -1, 20, 21, -1, 22, 23, 24, 25, 26, -1, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, -1, 18, 19, -1, 20, 21, -1, 22, 23, 24, 25, 26, -1, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public static String random() {
        byte[] entropy = new byte[10];
        Random random = new Random();
        random.nextBytes(entropy);
        return ULID.generate((long)System.currentTimeMillis(), (byte[])entropy);
    }

    public static byte[] randomBinary() {
        byte[] entropy = new byte[10];
        Random random = new Random();
        random.nextBytes(entropy);
        return ULID.generateBinary((long)System.currentTimeMillis(), (byte[])entropy);
    }

    public static String random(Random random) {
        byte[] entropy = new byte[10];
        random.nextBytes(entropy);
        return ULID.generate((long)System.currentTimeMillis(), (byte[])entropy);
    }

    public static byte[] randomBinary(Random random) {
        byte[] entropy = new byte[10];
        random.nextBytes(entropy);
        return ULID.generateBinary((long)System.currentTimeMillis(), (byte[])entropy);
    }

    public static String generate(long time, byte[] entropy) {
        if (time < 0L || time > 0xFFFFFFFFFFFFL || entropy == null || entropy.length < 10) {
            throw new IllegalArgumentException("Time is too long, or entropy is less than 10 bytes or null");
        }
        char[] chars = new char[]{C[(byte)(time >>> 45) & 0x1F], C[(byte)(time >>> 40) & 0x1F], C[(byte)(time >>> 35) & 0x1F], C[(byte)(time >>> 30) & 0x1F], C[(byte)(time >>> 25) & 0x1F], C[(byte)(time >>> 20) & 0x1F], C[(byte)(time >>> 15) & 0x1F], C[(byte)(time >>> 10) & 0x1F], C[(byte)(time >>> 5) & 0x1F], C[(byte)time & 0x1F], C[(byte)((entropy[0] & 0xFF) >>> 3)], C[(byte)((entropy[0] << 2 | (entropy[1] & 0xFF) >>> 6) & 0x1F)], C[(byte)((entropy[1] & 0xFF) >>> 1 & 0x1F)], C[(byte)((entropy[1] << 4 | (entropy[2] & 0xFF) >>> 4) & 0x1F)], C[(byte)((entropy[2] << 1 | (entropy[3] & 0xFF) >>> 7) & 0x1F)], C[(byte)((entropy[3] & 0xFF) >>> 2 & 0x1F)], C[(byte)((entropy[3] << 3 | (entropy[4] & 0xFF) >>> 5) & 0x1F)], C[(byte)(entropy[4] & 0x1F)], C[(byte)((entropy[5] & 0xFF) >>> 3)], C[(byte)((entropy[5] << 2 | (entropy[6] & 0xFF) >>> 6) & 0x1F)], C[(byte)((entropy[6] & 0xFF) >>> 1 & 0x1F)], C[(byte)((entropy[6] << 4 | (entropy[7] & 0xFF) >>> 4) & 0x1F)], C[(byte)((entropy[7] << 1 | (entropy[8] & 0xFF) >>> 7) & 0x1F)], C[(byte)((entropy[8] & 0xFF) >>> 2 & 0x1F)], C[(byte)((entropy[8] << 3 | (entropy[9] & 0xFF) >>> 5) & 0x1F)], C[(byte)(entropy[9] & 0x1F)]};
        return new String(chars);
    }

    public static byte[] generateBinary(long time, byte[] entropy) {
        if (time < 0L || time > 0xFFFFFFFFFFFFL || entropy == null || entropy.length < 10) {
            throw new IllegalArgumentException("Time is too long, or entropy is less than 10 bytes or null");
        }
        byte[] bytes = new byte[16];
        long ts = time;
        for (int i = 5; i >= 0; --i) {
            bytes[i] = (byte)(ts & 0xFFL);
            ts >>>= 8;
        }
        System.arraycopy(entropy, 0, bytes, 6, 10);
        return bytes;
    }

    public static boolean isValid(CharSequence ulid) {
        if (ulid == null || ulid.length() != 26) {
            return false;
        }
        for (int i = 0; i < 26; ++i) {
            char c = ulid.charAt(i);
            if (c <= V.length && V[c] != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidBinary(byte[] ulid) {
        return ulid != null && ulid.length == 16;
    }

    public static long getTimestamp(CharSequence ulid) {
        return (long)V[ulid.charAt(0)] << 45 | (long)V[ulid.charAt(1)] << 40 | (long)V[ulid.charAt(2)] << 35 | (long)V[ulid.charAt(3)] << 30 | (long)V[ulid.charAt(4)] << 25 | (long)V[ulid.charAt(5)] << 20 | (long)V[ulid.charAt(6)] << 15 | (long)V[ulid.charAt(7)] << 10 | (long)V[ulid.charAt(8)] << 5 | (long)V[ulid.charAt(9)];
    }

    public static long getTimestampBinary(byte[] ulid) {
        long timestamp = ulid[0];
        timestamp = timestamp << 8 | (long)(ulid[1] & 0xFF);
        timestamp = timestamp << 8 | (long)(ulid[2] & 0xFF);
        timestamp = timestamp << 8 | (long)(ulid[3] & 0xFF);
        timestamp = timestamp << 8 | (long)(ulid[4] & 0xFF);
        timestamp = timestamp << 8 | (long)(ulid[5] & 0xFF);
        return timestamp;
    }

    public static byte[] getEntropy(CharSequence ulid) {
        byte[] bytes = new byte[]{(byte)(V[ulid.charAt(10)] << 3 | (V[ulid.charAt(11)] & 0xFF) >>> 2), (byte)(V[ulid.charAt(11)] << 6 | V[ulid.charAt(12)] << 1 | (V[ulid.charAt(13)] & 0xFF) >>> 4), (byte)(V[ulid.charAt(13)] << 4 | (V[ulid.charAt(14)] & 0xFF) >>> 1), (byte)(V[ulid.charAt(14)] << 7 | V[ulid.charAt(15)] << 2 | (V[ulid.charAt(16)] & 0xFF) >>> 3), (byte)(V[ulid.charAt(16)] << 5 | V[ulid.charAt(17)]), (byte)(V[ulid.charAt(18)] << 3 | (V[ulid.charAt(19)] & 0xFF) >>> 2), (byte)(V[ulid.charAt(19)] << 6 | V[ulid.charAt(20)] << 1 | (V[ulid.charAt(21)] & 0xFF) >>> 4), (byte)(V[ulid.charAt(21)] << 4 | (V[ulid.charAt(22)] & 0xFF) >>> 1), (byte)(V[ulid.charAt(22)] << 7 | V[ulid.charAt(23)] << 2 | (V[ulid.charAt(24)] & 0xFF) >>> 3), (byte)(V[ulid.charAt(24)] << 5 | V[ulid.charAt(25)])};
        return bytes;
    }

    public static byte[] getEntropyBinary(byte[] ulid) {
        byte[] bytes = new byte[10];
        System.arraycopy(ulid, 6, bytes, 0, 10);
        return bytes;
    }

    public static byte[] toBinary(CharSequence ulid) {
        byte[] bytes = new byte[]{(byte)(V[ulid.charAt(0)] << 5 | V[ulid.charAt(1)]), (byte)(V[ulid.charAt(2)] << 3 | (V[ulid.charAt(3)] & 0xFF) >>> 2), (byte)(V[ulid.charAt(3)] << 6 | V[ulid.charAt(4)] << 1 | (V[ulid.charAt(5)] & 0xFF) >>> 4), (byte)(V[ulid.charAt(5)] << 4 | (V[ulid.charAt(6)] & 0xFF) >>> 1), (byte)(V[ulid.charAt(6)] << 7 | V[ulid.charAt(7)] << 2 | (V[ulid.charAt(8)] & 0xFF) >>> 3), (byte)(V[ulid.charAt(8)] << 5 | V[ulid.charAt(9)]), (byte)(V[ulid.charAt(10)] << 3 | (V[ulid.charAt(11)] & 0xFF) >>> 2), (byte)(V[ulid.charAt(11)] << 6 | V[ulid.charAt(12)] << 1 | (V[ulid.charAt(13)] & 0xFF) >>> 4), (byte)(V[ulid.charAt(13)] << 4 | (V[ulid.charAt(14)] & 0xFF) >>> 1), (byte)(V[ulid.charAt(14)] << 7 | V[ulid.charAt(15)] << 2 | (V[ulid.charAt(16)] & 0xFF) >>> 3), (byte)(V[ulid.charAt(16)] << 5 | V[ulid.charAt(17)]), (byte)(V[ulid.charAt(18)] << 3 | (V[ulid.charAt(19)] & 0xFF) >>> 2), (byte)(V[ulid.charAt(19)] << 6 | V[ulid.charAt(20)] << 1 | (V[ulid.charAt(21)] & 0xFF) >>> 4), (byte)(V[ulid.charAt(21)] << 4 | (V[ulid.charAt(22)] & 0xFF) >>> 1), (byte)(V[ulid.charAt(22)] << 7 | V[ulid.charAt(23)] << 2 | (V[ulid.charAt(24)] & 0xFF) >>> 3), (byte)(V[ulid.charAt(24)] << 5 | V[ulid.charAt(25)])};
        return bytes;
    }

    public static String fromBinary(byte[] binary) {
        char[] chars = new char[]{C[(byte)((binary[0] & 0xFF) >>> 5 & 0x1F)], C[(byte)(binary[0] & 0x1F)], C[(byte)((binary[1] & 0xFF) >>> 3)], C[(byte)((binary[1] << 2 | (binary[2] & 0xFF) >>> 6) & 0x1F)], C[(byte)((binary[2] & 0xFF) >>> 1 & 0x1F)], C[(byte)((binary[2] << 4 | (binary[3] & 0xFF) >>> 4) & 0x1F)], C[(byte)((binary[3] << 1 | (binary[4] & 0xFF) >>> 7) & 0x1F)], C[(byte)((binary[4] & 0xFF) >>> 2 & 0x1F)], C[(byte)((binary[4] << 3 | (binary[5] & 0xFF) >>> 5) & 0x1F)], C[(byte)(binary[5] & 0x1F)], C[(byte)((binary[6] & 0xFF) >>> 3)], C[(byte)((binary[6] << 2 | (binary[7] & 0xFF) >>> 6) & 0x1F)], C[(byte)((binary[7] & 0xFF) >>> 1 & 0x1F)], C[(byte)((binary[7] << 4 | (binary[8] & 0xFF) >>> 4) & 0x1F)], C[(byte)((binary[8] << 1 | (binary[9] & 0xFF) >>> 7) & 0x1F)], C[(byte)((binary[9] & 0xFF) >>> 2 & 0x1F)], C[(byte)((binary[9] << 3 | (binary[10] & 0xFF) >>> 5) & 0x1F)], C[(byte)(binary[10] & 0x1F)], C[(byte)((binary[11] & 0xFF) >>> 3)], C[(byte)((binary[11] << 2 | (binary[12] & 0xFF) >>> 6) & 0x1F)], C[(byte)((binary[12] & 0xFF) >>> 1 & 0x1F)], C[(byte)((binary[12] << 4 | (binary[13] & 0xFF) >>> 4) & 0x1F)], C[(byte)((binary[13] << 1 | (binary[14] & 0xFF) >>> 7) & 0x1F)], C[(byte)((binary[14] & 0xFF) >>> 2 & 0x1F)], C[(byte)((binary[14] << 3 | (binary[15] & 0xFF) >>> 5) & 0x1F)], C[(byte)(binary[15] & 0x1F)]};
        return new String(chars);
    }
}

