/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.auditlog;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import com.geolang.ascema.managercore.settings.SettingsFile;
import com.geolang.ascema.managerservice.auditlog.ILogAppender;
import com.geolang.ascema.managerservice.auditlog.TcpAppender;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.slf4j.LoggerFactory;

public class TcpLog
implements ILogAppender {
    private static final Logger LOG = Logger.getLogger(TcpLog.class.getName());
    private final ch.qos.logback.classic.Logger auditLog;
    private final TcpAppender appender;

    public TcpLog() {
        SettingsFile settings = SettingsFile.getInstance();
        int port = settings.getSplunkPort();
        String host = settings.getSplunkHost();
        LOG.log(Level.INFO, "Launching TCP Logger to {0} : {1}", new Object[]{host, port});
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayout ple = new PatternLayout();
        ple.setPattern("%msg");
        ple.setContext((Context)lc);
        ple.start();
        this.appender = new TcpAppender();
        this.appender.setPort(port);
        this.appender.setRemoteHost(host);
        this.appender.setLayout((Layout)ple);
        this.appender.setContext((Context)lc);
        this.appender.setUseSSL(settings.getSplunkUseSSL());
        this.appender.start();
        this.auditLog = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"audit-tcp");
        this.auditLog.addAppender((Appender)this.appender);
        this.auditLog.setLevel(ch.qos.logback.classic.Level.INFO);
        this.auditLog.setAdditive(false);
    }

    public void log(String str) {
        this.auditLog.info(str);
    }

    void stop() {
        this.appender.stop();
    }
}

