/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.auditlog;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.util.CloseUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class TcpAppender
extends AppenderBase<ILoggingEvent>
implements Runnable,
SocketConnector.ExceptionHandler {
    private static final Logger LOG = Logger.getLogger(TcpAppender.class.getName());
    private static final int DEFAULT_RECONNECTION_DELAY = 30000;
    private static final int DEFAULT_QUEUE_SIZE = 0;
    private static final int DEFAULT_ACCEPT_CONNECTION_DELAY = 5000;
    private boolean useSSL;
    private String host;
    private int port;
    private InetAddress address;
    private Layout<ILoggingEvent> layout;
    private ExecutorService executor;
    private Future<Socket> connectorTask;
    private int reconnectionDelay = 30000;
    private int queueSize = 0;
    private int acceptConnectionTimeout = 5000;
    private BlockingQueue<ILoggingEvent> queue;
    private volatile Socket socket;

    public void connectionFailed(SocketConnector socketConnector, Exception e) {
        if (e instanceof InterruptedException) {
            LOG.warning("connector interrupted");
        } else if (e instanceof ConnectException) {
            LOG.log(Level.WARNING, "{0}:{1} connection refused", new Object[]{this.host, this.port});
        } else {
            LOG.log(Level.WARNING, "{0}:{1} {2}", new Object[]{this.host, this.port, e});
        }
    }

    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                DefaultSocketConnector connector = new DefaultSocketConnector(this.address, this.port, 0L, (long)this.reconnectionDelay);
                connector.setExceptionHandler((SocketConnector.ExceptionHandler)this);
                if (this.useSSL) {
                    try {
                        KeyStore keyStore = KeyStore.getInstance("JKS");
                        String ksPath = System.getProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
                        LOG.log(Level.INFO, "Audit log tcp appender keystore is {0}", ksPath);
                        keyStore.load(new FileInputStream(ksPath), "changeit".toCharArray());
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(keyStore);
                        SSLContext ctx = SSLContext.getInstance("TLS");
                        ctx.init(null, tmf.getTrustManagers(), new SecureRandom());
                        connector.setSocketFactory((SocketFactory)ctx.getSocketFactory());
                    }
                    catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                } else {
                    connector.setSocketFactory(SocketFactory.getDefault());
                }
                try {
                    Context acontext = this.getContext();
                    this.connectorTask = acontext.getScheduledExecutorService().submit(connector);
                }
                catch (RejectedExecutionException e) {
                    this.connectorTask = null;
                    break;
                }
                try {
                    this.socket = (Socket)this.connectorTask.get();
                    this.connectorTask = null;
                }
                catch (ExecutionException e) {
                    this.socket = null;
                    break;
                }
                try {
                    this.socket.setSoTimeout(this.acceptConnectionTimeout);
                    OutputStreamWriter writer = new OutputStreamWriter(this.socket.getOutputStream());
                    this.socket.setSoTimeout(0);
                    LOG.log(Level.INFO, "{0}:{1} connection established", new Object[]{this.host, this.port});
                    while (true) {
                        ILoggingEvent event = (ILoggingEvent)this.queue.take();
                        String formatted = this.layout.doLayout((Object)event);
                        writer.write(formatted);
                        writer.flush();
                    }
                }
                catch (SocketException e) {
                    LOG.log(Level.WARNING, "{0}:{1} connection failed: {2}", new Object[]{this.host, this.port, e});
                }
                catch (IOException e) {
                    CloseUtil.closeQuietly((Socket)this.socket);
                    this.socket = null;
                    LOG.log(Level.WARNING, "{0}:{1} connection closed", new Object[]{this.host, this.port});
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.info("exiting");
    }

    public void start() {
        if (this.started) {
            return;
        }
        boolean errorPresent = false;
        if (this.port <= 0) {
            errorPresent = true;
            LOG.log(Level.WARNING, "No port was configured for appender{0}", this.name);
        }
        if (this.host == null) {
            errorPresent = true;
            LOG.log(Level.WARNING, "No remote host was configured for appender{0}", this.name);
        }
        if (this.queueSize < 0) {
            errorPresent = true;
            LOG.log(Level.WARNING, "Queue size must be non-negative");
        }
        if (this.layout == null) {
            LOG.log(Level.WARNING, "No layout set for the appender named [{0}].", this.name);
            errorPresent = true;
        }
        if (!errorPresent) {
            try {
                this.address = InetAddress.getByName(this.host);
            }
            catch (UnknownHostException ex) {
                LOG.log(Level.WARNING, "unknown host: {0}", this.host);
                errorPresent = true;
            }
        }
        if (!errorPresent) {
            this.queue = this.queueSize <= 0 ? new SynchronousQueue() : new ArrayBlockingQueue(this.queueSize);
            ThreadFactory factory = r -> {
                Thread t = new Thread(r, "splunk-tcp-appender");
                t.setDaemon(true);
                return t;
            };
            this.executor = Executors.newSingleThreadExecutor(factory);
            this.executor.execute((Runnable)this);
        }
        super.start();
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        CloseUtil.closeQuietly((Socket)this.socket);
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.connectorTask != null) {
            this.connectorTask.cancel(true);
        }
        super.stop();
    }

    protected void append(ILoggingEvent event) {
        if (event == null) {
            return;
        }
        event.prepareForDeferredProcessing();
        event.getCallerData();
        if (this.started) {
            this.queue.offer(event);
        }
    }

    public void setRemoteHost(String host) {
        this.host = host;
    }

    public String getRemoteHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(int reconnectionDelay) {
        this.reconnectionDelay = reconnectionDelay;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }
}

