/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.auditlog;

import com.geolang.ascema.domainmodelpublic.PatternMatchResult;
import com.geolang.ascema.domainmodelpublic.ResultStatus;
import com.geolang.ascema.domainmodelpublic.ResultStatusReason;
import com.geolang.ascema.endpointcommon.database.DBCol;
import com.geolang.ascema.endpointcommon.database.DatabaseSearchResult;
import com.geolang.ascema.endpointcommon.domain.DeviceType;
import com.geolang.ascema.endpointcommon.domain.RetrievalResult;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionResult;
import com.geolang.ascema.managercore.BrandingStrings;
import com.geolang.ascema.managerdomain.domain.BaseMatchStored;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerservice.auditlog.AuditLogEventType;
import com.geolang.ascema.managerservice.auditlog.ILogEvent;
import com.geolang.ascema.managerservice.auditlog.MonotonicULID;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class SplunkEvent
implements ILogEvent {
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final Pattern DOUBLE_QUOTE = Pattern.compile("\"");
    private static final Pattern SINGLE_QUOTE = Pattern.compile("'");
    private static final String KVDELIM = "=";
    private static final String PAIRDELIM = " ";
    private static final char QUOTE = '\"';
    private static final List<ImmutablePair<String, String>> common;
    private static final MonotonicULID ulid;
    transient List<ImmutablePair<String, String>> strings = new ArrayList();
    private static final DateTimeFormatter dateTimeFormatter;
    private String timestamp_ = Instant.now().toString();
    private final AuditLogEventType eventType;

    public SplunkEvent(AuditLogEventType evType) {
        this.eventType = evType;
    }

    public String getEventId() {
        return ulid.generate();
    }

    public String getEventType() {
        return this.eventType.toString();
    }

    public void addDeviceParts(DeviceRegistration dd) {
        this.strings.add(ImmutablePair.of((Object)"dvc", (Object)dd.getDeviceDescription()));
        this.strings.add(ImmutablePair.of((Object)"category", (Object)dd.getDeviceType().getDisplayName()));
        this.strings.add(ImmutablePair.of((Object)"dvc_zone", (Object)dd.getManagerName()));
        if (!dd.getDeviceType().equals((Object)DeviceType.ENDPOINT) && !dd.getDeviceType().equals((Object)DeviceType.FILESERVER)) {
            this.strings.add(ImmutablePair.of((Object)"dvc_tenant", (Object)dd.getCloudHostDisplayName()));
        }
        this.strings.add(ImmutablePair.of((Object)"src_user_email", (Object)dd.getUserEmail()));
        this.strings.add(ImmutablePair.of((Object)"dvc_ip", (Object)dd.getIpaddress()));
        this.strings.add(ImmutablePair.of((Object)"dvc_type", (Object)dd.getDeviceType().getDisplayName()));
        this.strings.add(ImmutablePair.of((Object)"dvc_follow_network", (Object)Boolean.toString(dd.isFollowNetworkShares())));
    }

    public void setManagerName(String name) {
        this.strings.add(ImmutablePair.of((Object)"dvc_zone", (Object)name));
    }

    public void setDevicePrevious(String prev) {
        this.strings.add(ImmutablePair.of((Object)"previous", (Object)prev));
    }

    public void addFileParts(String path, String object, String host, String area) {
        this.strings.add(ImmutablePair.of((Object)"dvc_tenant", (Object)host));
        this.strings.add(ImmutablePair.of((Object)"object_path", (Object)path));
        this.strings.add(ImmutablePair.of((Object)"platform_name", (Object)area));
    }

    public void addFileParts(String path) {
        try {
            Path filepath = Paths.get(path, new String[0]);
            Path filename = filepath.getFileName();
            Path parent = filepath.getParent();
            if (filename != null) {
                this.strings.add(ImmutablePair.of((Object)"object", (Object)filename.toString()));
            }
            if (parent != null) {
                this.strings.add(ImmutablePair.of((Object)"object_path", (Object)parent.toString()));
            }
        }
        catch (InvalidPathException ex) {
            this.strings.add(ImmutablePair.of((Object)"object", (Object)path));
            this.strings.add(ImmutablePair.of((Object)"object_path", (Object)path));
        }
    }

    public void addEventReason(boolean ok, String reason) {
        this.strings.add(ImmutablePair.of((Object)"success", (Object)Boolean.toString(ok)));
        this.strings.add(ImmutablePair.of((Object)"fail_reason", (Object)reason));
    }

    public void setTaskName(String name) {
        this.strings.add(ImmutablePair.of((Object)"task_name", (Object)name));
    }

    public void setActionParts(ActionResult audit) {
        this.strings.add(ImmutablePair.of((Object)"action", (Object)Arrays.toString(audit.getActionDisplayStrings())));
        String verb = "UNDO";
        if (audit.isIsPerform()) {
            verb = "PERFORM";
        }
        String actionAndStatus = verb + "_" + audit.getStatus().name();
        this.strings.add(ImmutablePair.of((Object)"action_status", (Object)actionAndStatus));
        if (audit.getStatus().equals((Object)ActionResult.ActionResultType.FAILED)) {
            this.strings.add(ImmutablePair.of((Object)"fail_reason", (Object)audit.getStatusReason()));
        }
    }

    public void addTaskInstanceParts(TaskInstance inst) {
        this.strings.add(ImmutablePair.of((Object)"task_name", (Object)inst.getDisplayName()));
        this.strings.add(ImmutablePair.of((Object)"web_user", (Object)inst.getCreatedBy()));
    }

    public void addResultTopLevel(SearchResultStored sr) {
        this.strings.add(ImmutablePair.of((Object)"last_modified_by", (Object)sr.getLastModifiedBy()));
        this.strings.add(ImmutablePair.of((Object)"file_last_modified", (Object)dateTimeFormatter.format(sr.getFileDates().getModified())));
        this.strings.add(ImmutablePair.of((Object)"sub_part", (Object)sr.getSubPath()));
    }

    public void addPatternParts(String name, String type) {
        this.strings.add(ImmutablePair.of((Object)"pattern_name", (Object)name));
        this.strings.add(ImmutablePair.of((Object)"pattern_type", (Object)type));
    }

    public void addPatternIgnoreParts(String name, String ignore) {
        this.strings.add(ImmutablePair.of((Object)"pattern_name", (Object)name));
        this.strings.add(ImmutablePair.of((Object)"pattern_ignore", (Object)ignore));
    }

    public void addResultParts(PatternMatchResult pm, DatabaseSearchResult sr) {
        this.strings.add(ImmutablePair.of((Object)"pattern", (Object)pm.getDisplayName()));
        this.strings.add(ImmutablePair.of((Object)"confidence", (Object)pm.getConfidence().getDisplayName()));
        this.strings.add(ImmutablePair.of((Object)"match", (Object)pm.getSurroundingText()));
        this.strings.add(ImmutablePair.of((Object)"column", (Object)((DBCol)sr.getColumns().get(sr.getColNum())).label()));
    }

    public void addResultParts(BaseMatchStored pm, SearchResultStored sr) {
        this.strings.add(ImmutablePair.of((Object)"pattern", (Object)pm.getDisplayName()));
        this.strings.add(ImmutablePair.of((Object)"confidence", (Object)pm.getConfidence().getDisplayName()));
        this.strings.add(ImmutablePair.of((Object)"match", (Object)pm.getSurroundingText()));
        this.strings.add(ImmutablePair.of((Object)"ui_match_id", (Object)Long.toString(pm.getId())));
        this.strings.add(ImmutablePair.of((Object)"status", (Object)pm.getStatus().toString()));
        this.strings.add(ImmutablePair.of((Object)"reason", (Object)pm.getResultStatusReason().toString()));
        this.strings.add(ImmutablePair.of((Object)"customreason", (Object)pm.getCustomStatusReason()));
        this.strings.add(ImmutablePair.of((Object)"last_modified_by", (Object)sr.getLastModifiedBy()));
        this.strings.add(ImmutablePair.of((Object)"file_last_modified", (Object)dateTimeFormatter.format(sr.getFileDates().getModified())));
        this.strings.add(ImmutablePair.of((Object)"sub_part", (Object)sr.getSubPath()));
    }

    public void setAlertedEmail(String email) {
        this.strings.add(ImmutablePair.of((Object)"alerted_by_email", (Object)email));
    }

    public void addSigniture(String s) {
        this.strings.add(ImmutablePair.of((Object)"signature", (Object)s));
    }

    public void setFileCreated(String s) {
        this.strings.add(ImmutablePair.of((Object)"file_created", (Object)s));
    }

    public void setArea(String s) {
        this.strings.add(ImmutablePair.of((Object)"src_named_area", (Object)s));
    }

    public void setFileVersion(boolean b) {
        this.strings.add(ImmutablePair.of((Object)"is_current_version", (Object)Boolean.toString(b)));
    }

    public void setUsers(String webUser, String srcUser) {
        this.strings.add(ImmutablePair.of((Object)"web_user", (Object)webUser));
        this.strings.add(ImmutablePair.of((Object)"src_user", (Object)srcUser));
    }

    public void setStatusReasons(ResultStatus status, ResultStatusReason reason, String customReason) {
        this.strings.add(ImmutablePair.of((Object)"status", (Object)status.toString()));
        this.strings.add(ImmutablePair.of((Object)"reason", (Object)reason.toString()));
        this.strings.add(ImmutablePair.of((Object)"customreason", (Object)customReason));
    }

    public void setRetrievalParts(RetrievalResult sr) {
        this.strings.add(ImmutablePair.of((Object)"repo_path", (Object)sr.getStoredPath()));
        this.strings.add(ImmutablePair.of((Object)"repo_filename", (Object)sr.getStoredFilename()));
    }

    public void setClassificationName(String name) {
        this.strings.add(ImmutablePair.of((Object)"classification_name", (Object)name));
    }

    public void setQuery(String webUser, String query) {
        this.strings.add(ImmutablePair.of((Object)"query", (Object)query));
        this.strings.add(ImmutablePair.of((Object)"web_user", (Object)webUser));
    }

    public String getTimestamp_() {
        return this.timestamp_;
    }

    public String toLogString() {
        String timestamp = this.getTimestamp_();
        StringBuilder out = new StringBuilder(timestamp);
        out.append(PAIRDELIM);
        out.append('\"').append(NAME).append(KVDELIM).append(this.getEventType()).append('\"').append(PAIRDELIM);
        for (ImmutablePair p : this.strings) {
            out.append(this.toString(p)).append(PAIRDELIM);
        }
        for (ImmutablePair p : common) {
            out.append(this.toString(p)).append(PAIRDELIM);
        }
        out.append('\"').append(ID).append(KVDELIM).append(this.getEventId()).append('\"').append("\n");
        return out.toString();
    }

    private String toString(ImmutablePair<String, String> entry) {
        StringBuilder output = new StringBuilder();
        String key = (String)entry.left;
        String value = (String)entry.right;
        if (key == null) {
            return "";
        }
        if (value == null) {
            return "\"" + key + "=\"";
        }
        key = DOUBLE_QUOTE.matcher(key).replaceAll("\\\\\"");
        value = DOUBLE_QUOTE.matcher(value).replaceAll("\\\\\"");
        value = SINGLE_QUOTE.matcher(value).replaceAll("\\\\'");
        output.append('\"').append(key).append(KVDELIM).append("'").append(value).append("'").append('\"');
        return output.toString();
    }

    static {
        ulid = new MonotonicULID();
        dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.from(ZoneOffset.UTC));
        common = new ArrayList();
        common.add(ImmutablePair.of((Object)"app", (Object)BrandingStrings.PRODUCT_NAME));
        common.add(ImmutablePair.of((Object)"vendor_product", (Object)(BrandingStrings.COMPANY_NAME + PAIRDELIM + BrandingStrings.PRODUCT_NAME)));
    }
}

