/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.auditlog;

import com.geolang.ascema.managercore.settings.WorkingFolder;
import com.geolang.ascema.managerservice.auditlog.ILogAppender;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class LogFileAppender
implements ILogAppender {
    private final String FILENAME = "auditlog%g.txt";
    private final int MAX_SIZE = 0x400000;
    private final int MAX_FILES = 20;
    private static final Logger AUDIT_LOG = Logger.getLogger("audit");
    private Path logFolder;

    public LogFileAppender() {
        try {
            String folder = WorkingFolder.getWorkingFolder() + File.separator + "auditlog";
            File f = new File(folder);
            if (!f.exists()) {
                f.mkdirs();
            }
            this.logFolder = f.toPath();
            String logPath = folder + File.separator + "auditlog%g.txt";
            FileHandler handler = new FileHandler(logPath, 0x400000, 20, true);
            handler.setFormatter((Formatter)new /* Unavailable Anonymous Inner Class!! */);
            AUDIT_LOG.addHandler(handler);
            AUDIT_LOG.setUseParentHandlers(false);
        }
        catch (IOException ex) {
            Logger.getLogger(LogFileAppender.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void log(String str) {
        AUDIT_LOG.info(str);
    }

    Optional<Path> getLogFilePath() {
        Optional<Path> optional;
        block8: {
            Stream<Path> paths = Files.list(this.logFolder);
            try {
                optional = paths.filter(f -> !Files.isDirectory(f, new LinkOption[0])).max(Comparator.comparingLong(f -> f.toFile().lastModified()));
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    Logger.getLogger(LogFileAppender.class.getName()).log(Level.SEVERE, null, ex);
                    return Optional.empty();
                }
            }
            paths.close();
        }
        return optional;
    }
}

