/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.auditlog;

import com.geolang.ascema.managerservice.auditlog.ILogAppender;
import com.geolang.ascema.managerservice.auditlog.ILogEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class EmitterService {
    private final CopyOnWriteArrayList<ILogAppender> appenders = new CopyOnWriteArrayList();
    private final ExecutorService emitterService = Executors.newSingleThreadExecutor();

    void setAppenders(List<ILogAppender> logs) {
        this.appenders.clear();
        this.appenders.addAll(logs);
    }

    void destroy() throws Exception {
        this.emitterService.shutdown();
        this.emitterService.awaitTermination(10L, TimeUnit.SECONDS);
    }

    void emit(ILogEvent ev) {
        this.emitterService.submit(() -> {
            String out = ev.toLogString();
            if (!out.isEmpty()) {
                for (ILogAppender appender : this.appenders) {
                    appender.log(out);
                }
            }
        });
    }
}

