/*
 * Decompiled with CFR 0.152.
 */
package com.geolang.ascema.managerservice.auditlog;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geolang.ascema.domainmodelpublic.PatternMatchResult;
import com.geolang.ascema.domainmodelpublic.ResultStatus;
import com.geolang.ascema.domainmodelpublic.ResultStatusReason;
import com.geolang.ascema.endpointcommon.database.DBCol;
import com.geolang.ascema.endpointcommon.database.DatabaseSearchResult;
import com.geolang.ascema.endpointcommon.domain.RetrievalResult;
import com.geolang.ascema.endpointcommon.domain.actions.command.ActionResult;
import com.geolang.ascema.managercore.BrandingStrings;
import com.geolang.ascema.managerdomain.domain.BaseMatchStored;
import com.geolang.ascema.managerdomain.domain.DeviceRegistration;
import com.geolang.ascema.managerdomain.domain.SearchResultStored;
import com.geolang.ascema.managerdomain.domain.TaskInstance;
import com.geolang.ascema.managerservice.auditlog.AuditLogEventType;
import com.geolang.ascema.managerservice.auditlog.ECSLogEvent;
import com.geolang.ascema.managerservice.auditlog.ILogEvent;
import com.geolang.ascema.managerservice.auditlog.MonotonicULID;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ECSLogEvent
implements ILogEvent {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.from(ZoneOffset.UTC));
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final MonotonicULID ulid = new MonotonicULID();
    private EventParts event;
    Host host = new Host(this);
    private String timestamp_;
    private FileParts file;
    private TaskParts task;
    private ResultParts result;
    private DatabaseResultParts dbresult;
    private RetrievalParts retrievalRepo;
    private PatternPart pattern;
    private ActionParts action;
    private KnowledgeBaseParts knowledgeBase;

    public ECSLogEvent(AuditLogEventType evType) {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.event = new EventParts(this);
        this.event.action = evType.toString();
        this.event.id = ulid.generate();
        this.timestamp_ = Instant.now().toString();
        this.file = null;
        this.task = null;
        this.result = null;
        this.dbresult = null;
        this.retrievalRepo = null;
        this.pattern = null;
        this.action = null;
        this.knowledgeBase = null;
        this.populateEcsEventTypes(evType);
    }

    public String getEventId() {
        return this.event.id;
    }

    public String getEventType() {
        return this.event.action;
    }

    public void setQuery(String webUser, String query) {
        this.knowledgeBase = new KnowledgeBaseParts(this);
        this.knowledgeBase.query = query;
        this.knowledgeBase.webUser = webUser;
    }

    public void addDeviceParts(DeviceRegistration dd) {
        this.host = new Host(this, dd);
    }

    public void setManagerName(String name) {
        this.host.manager = name;
    }

    public void setDevicePrevious(String prev) {
        this.host.previous = prev;
    }

    public void addFileParts(String path, String object, String host, String area) {
        if (this.file == null) {
            this.file = new FileParts(this);
        }
        this.file.area = area;
        this.file.name = path;
        this.file.tenant = host;
    }

    public void addFileParts(String path) {
        if (this.file == null) {
            this.file = new FileParts(this);
        }
        try {
            Path filepath = Paths.get(path, new String[0]);
            Path filename = filepath.getFileName();
            Path parent = filepath.getParent();
            if (filename != null) {
                this.file.name = filename.toString();
            }
            if (parent != null) {
                this.file.directory = parent.toString();
            }
        }
        catch (InvalidPathException ex) {
            this.file.name = path;
            this.file.directory = path;
        }
    }

    public void addEventReason(boolean ok, String reason) {
        this.event.outcome = ok ? "success" : "failure";
        this.event.reason = reason;
    }

    public void setTaskName(String name) {
        if (this.task == null) {
            this.task = new TaskParts(this);
        }
        this.task.name = name;
    }

    public void setActionParts(ActionResult audit) {
        if (this.action == null) {
            this.action = new ActionParts(this);
        }
        this.action.action = "UNDO";
        if (audit.isIsPerform()) {
            this.action.action = "PERFORM";
        }
        this.action.status = audit.getStatus().toString();
        this.action.type = Arrays.toString(audit.getActionDisplayStrings());
        if (audit.getStatus().equals((Object)ActionResult.ActionResultType.FAILED)) {
            this.action.statusReason = audit.getStatusReason();
        }
    }

    public void addTaskInstanceParts(TaskInstance inst) {
        if (this.task == null) {
            this.task = new TaskParts(this);
        }
        this.task.createdBy = inst.getCreatedBy();
        this.task.name = inst.getDisplayName();
    }

    public void addResultTopLevel(SearchResultStored sr) {
        if (this.result == null) {
            this.result = new ResultParts(this);
        }
        this.result.lastModifiedBy = sr.getLastModifiedBy();
        this.result.fileLastModified = dateTimeFormatter.format(sr.getFileDates().getModified());
        this.result.subPath = sr.getSubPath();
    }

    public void addPatternParts(String name, String type) {
        if (this.pattern == null) {
            this.pattern = new PatternPart(this);
        }
        this.pattern.patternName = name;
        this.pattern.type = type;
    }

    public void addPatternIgnoreParts(String name, String ignore) {
        if (this.pattern == null) {
            this.pattern = new PatternPart(this);
        }
        this.pattern.patternName = name;
        this.pattern.ignore = ignore;
    }

    public void addResultParts(PatternMatchResult pm, DatabaseSearchResult sr) {
        if (this.dbresult == null) {
            this.dbresult = new DatabaseResultParts(this);
        }
        this.dbresult.confidence = pm.getConfidence().getDisplayName();
        this.dbresult.match = pm.getSurroundingText();
        this.dbresult.pattern = new PatternPart(this);
        this.dbresult.pattern.patternName = pm.getDisplayName();
        this.dbresult.column = ((DBCol)sr.getColumns().get(sr.getColNum())).label();
    }

    public void addResultParts(BaseMatchStored pm, SearchResultStored sr) {
        if (this.result == null) {
            this.result = new ResultParts(this);
        }
        this.result.confidence = pm.getConfidence().getDisplayName();
        this.result.customReason = pm.getCustomStatusReason();
        this.result.fileLastModified = dateTimeFormatter.format(sr.getFileDates().getModified());
        this.result.id = Long.toString(pm.getId());
        this.result.lastModifiedBy = sr.getLastModifiedBy();
        this.result.match = pm.getSurroundingText();
        this.result.pattern = new PatternPart(this);
        this.result.pattern.patternName = pm.getDisplayName();
        this.result.reason = pm.getResultStatusReason().toString();
        this.result.status = pm.getStatus().toString();
        this.result.subPath = sr.getSubPath();
    }

    public void setAlertedEmail(String email) {
        this.event.alertedEmail = email;
    }

    public void addSigniture(String s) {
        if (this.result == null) {
            this.result = new ResultParts(this);
        }
        this.result.signature = s;
    }

    public void setFileCreated(String s) {
        if (this.file == null) {
            this.file = new FileParts(this);
        }
        this.file.created = s;
    }

    public void setArea(String s) {
        if (this.file == null) {
            this.file = new FileParts(this);
        }
        this.file.area = s;
    }

    public void setFileVersion(boolean b) {
        if (this.file == null) {
            this.file = new FileParts(this);
        }
        this.file.isCurrentVersion = Boolean.toString(b);
    }

    public void setUsers(String webUser, String srcUser) {
        this.event.webUser = webUser;
        this.event.owner = srcUser;
    }

    public void setClassificationName(String name) {
        this.event.classificationName = name;
    }

    public void setStatusReasons(ResultStatus status, ResultStatusReason reason, String customReason) {
        if (this.result == null) {
            this.result = new ResultParts(this);
        }
        this.result.status = status.toString();
        this.result.reason = reason.toString();
        this.result.customReason = customReason;
    }

    public void setRetrievalParts(RetrievalResult sr) {
        if (this.retrievalRepo == null) {
            this.retrievalRepo = new RetrievalParts(this);
        }
        this.retrievalRepo.filename = sr.getStoredFilename();
        this.retrievalRepo.path = sr.getStoredPath();
    }

    private void populateEcsEventTypes(AuditLogEventType t) {
        this.event.category = "process";
        switch (1.$SwitchMap$com$geolang$ascema$managerservice$auditlog$AuditLogEventType[t.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.event.type = "alert";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                this.event.type = "event";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                this.event.type = "asset";
                this.event.category = "vulnerability";
            }
        }
        this.event.module = BrandingStrings.PRODUCT_NAME;
    }

    public static DateTimeFormatter getDateTimeFormatter() {
        return dateTimeFormatter;
    }

    public EventParts getEvent() {
        return this.event;
    }

    public Host getHost() {
        return this.host;
    }

    public String getTimestamp_() {
        return this.timestamp_;
    }

    public FileParts getFile() {
        return this.file;
    }

    public TaskParts getTask() {
        return this.task;
    }

    public ResultParts getResult() {
        return this.result;
    }

    public RetrievalParts getRetrievalRepo() {
        return this.retrievalRepo;
    }

    public PatternPart getPattern() {
        return this.pattern;
    }

    public ActionParts getAction() {
        return this.action;
    }

    public DatabaseResultParts getDbresult() {
        return this.dbresult;
    }

    public KnowledgeBaseParts getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public String toLogString() {
        try {
            Object ret = mapper.writeValueAsString((Object)this);
            ret = ((String)ret).replace("timestamp_", "@timestamp") + "\n";
            return ret;
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(ECSLogEvent.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }
}

